/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.rest.OctaneConnection;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.Logger;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/space-configs")
@Scanned
public class ConfigurationRestResource {
    private OctaneConnectionManager octaneConnectionManager = OctaneConnectionManager.getInstance();
    private static final Logger log = SDKBasedLoggerProvider.getLogger(ConfigurationRestResource.class);
    private UserManager userManager;

    private UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        }
        return this.userManager;
    }

    private boolean hasPermissions(HttpServletRequest request) {
        UserProfile username = this.getUserManager().getRemoteUser(request);
        return username != null && this.getUserManager().isSystemAdmin(username.getUserKey());
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateConfiguration(@Context HttpServletRequest request, OctaneConnection model, @PathParam(value="id") String id) {
        log.info("update configuration " + id);
        if (!this.hasPermissions(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user does not have permission").build();
        }
        if (!model.getId().equals(id)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"invalid request : unexpected id").build();
        }
        if (this.octaneConnectionManager.getConnectionById(model.getId()) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No configuration with id " + id)).build();
        }
        this.octaneConnectionManager.replacePlainPasswordIfRequired(model);
        try {
            this.octaneConnectionManager.updateConfiguration(model);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        return Response.ok().entity((Object)model.cloneForUI()).build();
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addConfiguration(@Context HttpServletRequest request, OctaneConnection model) {
        if (!this.hasPermissions(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user dont have permission").build();
        }
        log.info("add configuration");
        if (!model.getId().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New configuration should not contain instance id").build();
        }
        model.setId(UUID.randomUUID().toString());
        try {
            this.octaneConnectionManager.addConfiguration(model);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        return Response.ok().entity((Object)model.cloneForUI()).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteConfiguration(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try {
            boolean deleted = this.octaneConnectionManager.deleteConfiguration(id);
            if (deleted) {
                return Response.ok().entity((Object)true).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No configuration with id " + id)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/")
    public Response getAllConfigurations(@Context HttpServletRequest request) {
        ArrayList newList = new ArrayList();
        this.octaneConnectionManager.getOctaneConnections().getOctaneConnections().forEach(c -> newList.add(c.cloneForUI()));
        return Response.ok(newList).build();
    }
}

