/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.gherkin;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.hp.octane.plugins.bamboo.octane.gherkin.ALMOctaneCucumberTestReporterUtils;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class ALMOctaneCucumberTestReporterTask
implements TaskType {
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        if (!taskContext.isFinalising()) {
            buildLogger.addBuildLogEntry("***************ALM octane cucumber test reporter task must be final*************");
        }
        File targetDirectory = Paths.get(taskContext.getWorkingDirectory().getAbsolutePath(), "ALM_Octane_Test_Results", "Build_" + taskContext.getBuildContext().getBuildNumber()).toFile();
        targetDirectory.mkdirs();
        try {
            ALMOctaneCucumberTestReporterUtils.copyTestResults(targetDirectory.getAbsolutePath(), taskContext.getWorkingDirectory().getAbsolutePath(), (String)taskContext.getConfigurationMap().get((Object)"cucumberReportXML"), buildLogger, taskContext.getBuildContext().getBuildResult().getTasksStartDate());
            ALMOctaneCucumberTestReporterUtils.aggregateGherkinFilesToMqmResultFile(targetDirectory.getAbsolutePath(), taskContext.getBuildContext().getShortName(), taskContext.getBuildContext().getBuildNumber(), buildLogger);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        catch (Exception e) {
            buildLogger.addBuildLogEntry("Exception running cucumber task : " + e.getMessage());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
    }
}

