/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.gherkin;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.hp.octane.plugins.bamboo.octane.ArtifactsHelper;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ALMOctaneCucumberTestReporterConfigurator
extends AbstractTaskConfigurator {
    public static final String CUCUMBER_REPORT_PATTERN_FIELD = "cucumberReportXML";

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.registerArtifacts((Job)context.get("plan"));
    }

    private boolean registerArtifacts(@NotNull Job job) {
        String pattern = "**/ALM_Octane_Test_Results/Build_${bamboo.buildNumber}/*.xml";
        return ArtifactsHelper.registerArtifactDefinition(job, "ALM Octane test results", pattern);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.registerArtifacts((Job)context.get("plan"));
        context.put(CUCUMBER_REPORT_PATTERN_FIELD, taskDefinition.getConfiguration().get(CUCUMBER_REPORT_PATTERN_FIELD));
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(CUCUMBER_REPORT_PATTERN_FIELD, params.getString(CUCUMBER_REPORT_PATTERN_FIELD));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.validateXmlFileValue(CUCUMBER_REPORT_PATTERN_FIELD, params.getString(CUCUMBER_REPORT_PATTERN_FIELD), errorCollection);
    }

    private void validateXmlFileValue(String field, String value, ErrorCollection errorCollection) {
        if (value.contains("../")) {
            errorCollection.addError(field, "Field should not contain '../'");
        }
    }
}

