/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.chains.events.ChainMovedEvent;
import com.atlassian.bamboo.event.ChainDeletedEvent;
import com.atlassian.bamboo.event.HibernateEventListenerAspect;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.v2.build.events.PostBuildCompletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.ItemType;
import com.hp.octane.plugins.bamboo.listener.BaseListener;
import com.hp.octane.plugins.bamboo.listener.MultibranchHelper;
import com.hp.octane.plugins.bamboo.listener.OctanePostChainAction;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;

public class GeneralEventsListener
extends BaseListener {
    private final PluginSettingsFactory settingsFactory;
    private final CachedPlanManager planMan;

    public GeneralEventsListener(PluginSettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.planMan = (CachedPlanManager)ComponentLocator.getComponent(CachedPlanManager.class);
    }

    @EventListener
    public void onChainDeleted(ChainDeletedEvent event) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        MultibranchHelper.onChainDeleted(event.getPlanKey());
    }

    @EventListener
    public void onChainMoved(ChainMovedEvent event) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        this.log.info("onChainMoved " + event.getOriginalPlanKey() + "=>" + event.getNewPlanKey());
        CIEvent renamedEvent = DefaultOctaneConverter.getDTOFactory().newDTO(CIEvent.class).setEventType(CIEventType.RENAMED);
        ImmutableChain chain = (ImmutableChain)this.planMan.getPlanByKey(event.getNewPlanKey());
        renamedEvent.setItemType(ItemType.MULTI_BRANCH);
        renamedEvent.setProject(event.getNewPlanKey().getKey()).setProjectDisplayName(chain.getName()).setPreviousProject(event.getOriginalPlanKey().getKey()).setPreviousProjectDisplayName(chain.getName());
        CIEvent renamedEvent2 = DefaultOctaneConverter.getDTOFactory().newDTO(CIEvent.class).setEventType(CIEventType.RENAMED).setItemType(ItemType.FOLDER).setProject(event.getNewPlanKey().getKey()).setProjectDisplayName(chain.getName()).setPreviousProject(event.getOriginalPlanKey().getKey()).setPreviousProjectDisplayName(chain.getName());
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(renamedEvent));
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(renamedEvent2));
    }

    @EventListener
    @HibernateEventListenerAspect
    public void onJobCompleted(PostBuildCompletedEvent event) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        this.log.info("on job completed " + event.getPlanKey().getKey());
        OctanePostChainAction.onJobCompleted(event);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if ("com.hpe.adm.octane.ciplugins.bamboo-ci-plugin".equals(event.getPlugin().getKey())) {
            OctaneConnectionManager.getInstance().initSdkClients(this.settingsFactory);
        }
    }

    @EventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        if ("com.hpe.adm.octane.ciplugins.bamboo-ci-plugin".equals(event.getPlugin().getKey())) {
            OctaneConnectionManager.getInstance().removeClients();
        }
    }
}

