/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.uft.DiscoveryResultDispatcher;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.CustomLogger;
import com.hp.octane.integrations.uft.items.JobRunContext;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.UftParameterDirection;
import com.hp.octane.integrations.uft.items.UftTestAction;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.uft.items.UftTestParameter;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MbtDiscoveryResultDispatcherImpl
extends DiscoveryResultDispatcher {
    private static final Logger logger = LogManager.getLogger(MbtDiscoveryResultDispatcherImpl.class);
    private static final Entity TESTING_TOOL_TYPE = MbtDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.bu_testing_tool_type.uft");
    private static final Entity AUTOMATED_AUTOMATION_STATUS = MbtDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.automation_status.automated");
    private static final Entity NOT_AUTOMATED_AUTOMATION_STATUS = MbtDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.automation_status.not_automated");
    private static final Entity INPUT_PARAMETER_TYPE = MbtDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.entity_parameter_type.input");
    private static final Entity OUTPUT_PARAMETER_TYPE = MbtDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.entity_parameter_type.output");

    @Override
    public void dispatchDiscoveryResults(EntitiesService entitiesService, UftTestDiscoveryResult result, JobRunContext jobRunContext, CustomLogger customLogger) {
        List allActions = result.getAllTests().stream().map(AutomatedTest::getActions).flatMap(Collection::stream).collect(Collectors.toList());
        long workspaceId = Long.parseLong(result.getWorkspaceId());
        Map<OctaneStatus, List<UftTestAction>> actionsByStatusMap = allActions.stream().collect(Collectors.groupingBy(UftTestAction::getOctaneStatus));
        Entity autoDiscoveredFolder = null;
        if (CollectionUtils.isNotEmpty((Collection)actionsByStatusMap.get((Object)OctaneStatus.NEW)) || CollectionUtils.isNotEmpty((Collection)actionsByStatusMap.get((Object)OctaneStatus.MODIFIED))) {
            autoDiscoveredFolder = this.retrieveParentFolder(entitiesService, workspaceId);
        }
        this.dispatchNewActions(entitiesService, actionsByStatusMap.get((Object)OctaneStatus.NEW), autoDiscoveredFolder, workspaceId, customLogger);
        this.dispatchDeletedActions(entitiesService, actionsByStatusMap.get((Object)OctaneStatus.DELETED), workspaceId, customLogger);
        this.dispatchUpdatedActions(entitiesService, actionsByStatusMap.get((Object)OctaneStatus.MODIFIED), autoDiscoveredFolder, workspaceId, customLogger);
    }

    private void dispatchNewActions(EntitiesService entitiesService, List<UftTestAction> newActions, Entity autoDiscoveredFolder, long workspaceId, CustomLogger customLogger) {
        if (CollectionUtils.isNotEmpty(newActions)) {
            Map<String, Entity> foldersMap = this.createParentFolders(entitiesService, newActions, autoDiscoveredFolder, workspaceId);
            this.postUnits(entitiesService, newActions, foldersMap, workspaceId);
        }
    }

    private Map<String, Entity> createParentFolders(EntitiesService entitiesService, List<UftTestAction> newActions, Entity autoDiscoveredFolder, long workspaceId) {
        List<Entity> existingSubFolders = this.retrieveChildFolders(entitiesService, workspaceId, Long.parseLong(autoDiscoveredFolder.getId()));
        Map<String, Entity> existingSubFoldersMap = existingSubFolders.stream().collect(Collectors.toMap(Entity::getName, entity -> entity));
        Set<String> testNames = newActions.stream().map(UftTestAction::getTestName).collect(Collectors.toSet());
        testNames.removeAll(existingSubFoldersMap.keySet());
        if (CollectionUtils.isNotEmpty(testNames)) {
            Map<String, Entity> newFoldersMap = this.postFolders(entitiesService, testNames, autoDiscoveredFolder, workspaceId);
            existingSubFoldersMap.putAll(newFoldersMap);
        }
        return existingSubFoldersMap;
    }

    private void dispatchDeletedActions(EntitiesService entitiesService, List<UftTestAction> deletedActions, long workspaceId, CustomLogger customLogger) {
        if (CollectionUtils.isNotEmpty(deletedActions)) {
            this.deleteUnits(entitiesService, deletedActions, workspaceId);
        }
    }

    private void dispatchUpdatedActions(EntitiesService entitiesService, List<UftTestAction> updatedActions, Entity autoDiscoveredFolder, long workspaceId, CustomLogger customLogger) {
        if (CollectionUtils.isNotEmpty(updatedActions)) {
            this.updateParentFolders(entitiesService, updatedActions, autoDiscoveredFolder, workspaceId);
            this.updateUnits(entitiesService, updatedActions, workspaceId);
        }
    }

    private void updateParentFolders(EntitiesService entitiesService, List<UftTestAction> updatedActions, Entity autoDiscoveredFolder, long workspaceId) {
        Map<String, String> oldNameToNewName = updatedActions.stream().filter(action -> action.isMoved() && !action.getTestName().equals(action.getOldTestName())).collect(Collectors.toMap(UftTestAction::getOldTestName, UftTestAction::getTestName, (s1, s2) -> s1));
        if (!oldNameToNewName.isEmpty()) {
            String condition1 = QueryHelper.conditionRef("parent", Long.parseLong(autoDiscoveredFolder.getId()));
            String condition2 = QueryHelper.conditionIn("name", oldNameToNewName.keySet(), false);
            List<Entity> foldersToUpdate = entitiesService.getEntities(workspaceId, "model_items", Arrays.asList(condition1, condition2), Arrays.asList("id", "name"));
            this.updateFolders(entitiesService, foldersToUpdate, oldNameToNewName, workspaceId);
        }
    }

    private Map<String, Entity> postFolders(EntitiesService entitiesService, Set<String> names, Entity parentFolder, long workspaceId) {
        if (!names.isEmpty()) {
            logger.info("dispatching {} new folders", (Object)names.size());
            List<Entity> foldersToAdd = names.stream().map(name -> this.createFolderEntity((String)name, parentFolder)).collect(Collectors.toList());
            Map<String, Entity> folderEntities = entitiesService.postEntities((Long)workspaceId, "model_items", foldersToAdd, Collections.singletonList("name")).stream().collect(Collectors.toMap(Entity::getName, Function.identity()));
            logger.info("actual new folders {} added", (Object)folderEntities.size());
            return folderEntities;
        }
        return Collections.emptyMap();
    }

    private void updateFolders(EntitiesService entitiesService, List<Entity> foldersToUpdate, Map<String, String> oldNameToNewName, long workspaceId) {
        if (!foldersToUpdate.isEmpty()) {
            logger.info("dispatching {} updated folders", (Object)foldersToUpdate.size());
            foldersToUpdate = foldersToUpdate.stream().map(entity -> dtoFactory.newDTO(Entity.class).setId(entity.getId()).setName((String)oldNameToNewName.get(entity.getName()))).collect(Collectors.toList());
            List<Entity> folderEntities = entitiesService.updateEntities((Long)workspaceId, "model_items", foldersToUpdate);
            logger.info("actual updated folders {}", (Object)folderEntities.size());
        }
    }

    private boolean postUnits(EntitiesService entitiesService, List<UftTestAction> actions, Map<String, Entity> foldersMap, long workspaceId) {
        if (!actions.isEmpty()) {
            logger.info("dispatching {} new units", (Object)actions.size());
            ArrayList<Entity> parameterToAdd = new ArrayList<Entity>();
            List<Entity> unitsToAdd = actions.stream().map(action -> this.createUnitEntity((UftTestAction)action, foldersMap, (List<Entity>)parameterToAdd)).collect(Collectors.toList());
            Map unitEntities = entitiesService.postEntities((Long)workspaceId, "model_items", unitsToAdd, Collections.singletonList("repository_path")).stream().collect(Collectors.toMap(entity -> entity.getField("repository_path").toString(), Function.identity()));
            logger.info("actual new units {} added", (Object)unitEntities.size());
            logger.info("dispatching {} new unit parameters", (Object)parameterToAdd.size());
            parameterToAdd.forEach(parameter -> {
                Entity parentUnit = (Entity)parameter.getField("model_item");
                Entity newParentUnit = (Entity)unitEntities.get(parentUnit.getField("repository_path").toString());
                parameter.setField("model_item", MbtDiscoveryResultDispatcherImpl.createModelItemEntity(newParentUnit));
            });
            List<Entity> unitParameterEntities = entitiesService.postEntities((Long)workspaceId, "entity_parameters", parameterToAdd);
            logger.info("actual new unit parameters {} added", (Object)unitParameterEntities.size());
        }
        return true;
    }

    private boolean deleteUnits(EntitiesService entitiesService, List<UftTestAction> actions, long workspaceId) {
        if (!actions.isEmpty()) {
            logger.info("dispatching {} deleted units", (Object)actions.size());
            List<Entity> unitsToUpdate = actions.stream().map(action -> dtoFactory.newDTO(Entity.class).setId(action.getId()).setField("repository_path", null).setField("automation_status", NOT_AUTOMATED_AUTOMATION_STATUS).setField("testing_tool_type", null)).collect(Collectors.toList());
            List<Entity> deletedUnitEntities = entitiesService.updateEntities((Long)workspaceId, "model_items", unitsToUpdate);
            logger.info("actual deleted units {} updated", (Object)deletedUnitEntities.size());
        }
        return true;
    }

    private boolean updateUnits(EntitiesService entitiesService, List<UftTestAction> actions, long workspaceId) {
        if (!actions.isEmpty()) {
            logger.info("dispatching {} updated units", (Object)actions.size());
            List<Entity> unitsToUpdate = actions.stream().map(action -> {
                String unitName = SdkStringUtils.isEmpty(action.getLogicalName()) || action.getLogicalName().startsWith("Action") ? action.getTestName() + ":" + action.getName() : action.getLogicalName();
                return dtoFactory.newDTO(Entity.class).setId(action.getId()).setField("name", unitName).setField("description", action.getDescription()).setField("repository_path", action.getRepositoryPath());
            }).collect(Collectors.toList());
            List<Entity> updatedUnitEntities = entitiesService.updateEntities((Long)workspaceId, "model_items", unitsToUpdate);
            logger.info("actual updated units {}", (Object)updatedUnitEntities.size());
        }
        return true;
    }

    private Entity retrieveParentFolder(EntitiesService entitiesService, long workspaceId) {
        String condition = QueryHelper.condition("logical_name", "mbt.discovery.unit.default_folder_name");
        List<Entity> entities = entitiesService.getEntities(workspaceId, "model_items", Collections.singletonList(condition), Collections.emptyList());
        return entities.get(0);
    }

    private List<Entity> retrieveChildFolders(EntitiesService entitiesService, long workspaceId, long parentFolderId) {
        String condition1 = QueryHelper.conditionRef("parent", parentFolderId);
        String condition2 = QueryHelper.condition("subtype", "model_folder");
        return entitiesService.getEntities(workspaceId, "model_items", Arrays.asList(condition1, condition2), Collections.emptyList());
    }

    private Entity createFolderEntity(String name, Entity parentFolder) {
        return dtoFactory.newDTO(Entity.class).setType("model_item").setField("subtype", "model_folder").setField("name", name).setField("parent", parentFolder);
    }

    private Entity createUnitEntity(UftTestAction action, Map<String, Entity> foldersMap, List<Entity> parameterEntities) {
        String unitName = SdkStringUtils.isEmpty(action.getLogicalName()) || action.getLogicalName().startsWith("Action") ? action.getTestName() + ":" + action.getName() : action.getLogicalName();
        Entity parentFolder = foldersMap.get(action.getTestName());
        Entity unitEntity = dtoFactory.newDTO(Entity.class).setType("model_item").setField("subtype", "unit").setField("name", unitName).setField("description", action.getDescription()).setField("parent", parentFolder).setField("automation_status", AUTOMATED_AUTOMATION_STATUS).setField("repository_path", action.getRepositoryPath()).setField("testing_tool_type", TESTING_TOOL_TYPE);
        if (CollectionUtils.isNotEmpty(action.getParameters())) {
            List parameters = action.getParameters().stream().map(parameter -> this.createUnitParameterEntity((UftTestParameter)parameter, unitEntity)).collect(Collectors.toList());
            parameterEntities.addAll(parameters);
        }
        return unitEntity;
    }

    private Entity createUnitParameterEntity(UftTestParameter parameter, Entity parentUnit) {
        Entity parameterType = null;
        if (UftParameterDirection.INPUT.equals((Object)parameter.getDirection())) {
            parameterType = INPUT_PARAMETER_TYPE;
        } else if (UftParameterDirection.OUTPUT.equals((Object)parameter.getDirection())) {
            parameterType = OUTPUT_PARAMETER_TYPE;
        }
        return dtoFactory.newDTO(Entity.class).setType("entity_parameter").setField("subtype", "unit_parameter").setField("name", parameter.getName()).setField("model_item", parentUnit).setField("parameter_type", parameterType).setField("value", parameter.getDefaultValue());
    }
}

