/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.ssc;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.dto.securityscans.SSCProjectConfiguration;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.vulnerabilities.DateUtils;
import com.hp.octane.integrations.services.vulnerabilities.IssuesFileSerializer;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesQueueItem;
import com.hp.octane.integrations.services.vulnerabilities.ssc.PackSSCIssuesToSendToOctane;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCHandler;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCService;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Issues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSCServiceImpl
implements SSCService {
    private static final Logger logger = LogManager.getLogger(SSCServiceImpl.class);
    protected final OctaneSDK.SDKServicesConfigurer configurer;
    protected final RestService restService;

    public SSCServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
    }

    @Override
    public OctaneSDK.SDKServicesConfigurer getConfigurer() {
        return this.configurer;
    }

    @Override
    public RestService getRestService() {
        return this.restService;
    }

    @Override
    public InputStream getVulnerabilitiesScanResultStream(VulnerabilitiesQueueItem queueItem) {
        try {
            String targetDir = IssuesFileSerializer.getTargetDir(this.getConfigurer().pluginServices.getAllowedOctaneStorage(), queueItem.getJobId(), queueItem.getBuildId());
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "targetDir:" + targetDir);
            InputStream cachedScanResult = IssuesFileSerializer.getCachedScanResult(targetDir);
            if (cachedScanResult != null) {
                logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "Results are cached.");
                return cachedScanResult;
            }
            List<OctaneIssue> octaneIssues = this.getNonCacheVulnerabilitiesScanResultStream(queueItem);
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "Done retrieving non-cached.");
            if (octaneIssues == null) {
                return null;
            }
            IssuesFileSerializer.cacheIssues(targetDir, octaneIssues);
            return IssuesFileSerializer.serializeIssues(octaneIssues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean vulnerabilitiesQueueItemCleanUp(VulnerabilitiesQueueItem vulnerabilitiesQueueItem) {
        String runRootDir = IssuesFileSerializer.getTargetDir(this.configurer.pluginServices.getAllowedOctaneStorage(), vulnerabilitiesQueueItem.getJobId(), vulnerabilitiesQueueItem.getBuildId());
        if (runRootDir == null) {
            return false;
        }
        File directoryToBeDeleted = new File(runRootDir);
        return IssuesFileSerializer.deleteDirectory(directoryToBeDeleted);
    }

    private List<OctaneIssue> getNonCacheVulnerabilitiesScanResultStream(VulnerabilitiesQueueItem queueItem) throws IOException {
        SSCProjectConfiguration sscProjectConfiguration = this.configurer.pluginServices.getSSCProjectConfiguration(queueItem.getJobId(), queueItem.getBuildId());
        if (sscProjectConfiguration == null || !sscProjectConfiguration.isValid()) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "cannot retrieve SSC Project CFG.");
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "SSC project configurations is missing or not valid, skipping processing for " + queueItem.getJobId() + " #" + queueItem.getBuildId());
            return null;
        }
        SSCHandler sscHandler = new SSCHandler(queueItem, sscProjectConfiguration, this.restService.obtainSSCRestClient());
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "retrieve issues from SSC");
        List<Issues.Issue> issuesFromSecurityTool = this.getIssuesFromSSC(sscHandler, queueItem);
        if (issuesFromSecurityTool == null) {
            return null;
        }
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "retrieve octane remote ids");
        List<String> octaneExistsIssuesIdsList = this.getRemoteIdsOfExistIssuesFromOctane(queueItem, sscProjectConfiguration.getRemoteTag());
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "done retrieveing octane remote ids");
        PackSSCIssuesToSendToOctane packSSCIssuesToSendToOctane = new PackSSCIssuesToSendToOctane();
        packSSCIssuesToSendToOctane.setConsiderMissing(queueItem.getBaselineDate() != null);
        packSSCIssuesToSendToOctane.setOctaneIssues(octaneExistsIssuesIdsList);
        packSSCIssuesToSendToOctane.setRemoteTag(sscProjectConfiguration.getRemoteTag());
        packSSCIssuesToSendToOctane.setSscHandler(sscHandler);
        packSSCIssuesToSendToOctane.setSscIssues(issuesFromSecurityTool);
        return packSSCIssuesToSendToOctane.packToOctaneIssues();
    }

    private List<Issues.Issue> getIssuesFromSSC(SSCHandler sscHandler, VulnerabilitiesQueueItem vulnerabilitiesQueueItem) {
        Optional<Issues> allIssues = sscHandler.getIssuesIfScanCompleted();
        if (!allIssues.isPresent()) {
            logger.debug(vulnerabilitiesQueueItem.toString() + " not completed yet");
            return null;
        }
        logger.debug(vulnerabilitiesQueueItem.toString() + " completed SSC scan.");
        List<Issues.Issue> filterIssuesByBaseLine = allIssues.get().getData();
        if (vulnerabilitiesQueueItem.getBaselineDate() != null) {
            filterIssuesByBaseLine = allIssues.get().getData().stream().filter(issue -> {
                Date foundDate = DateUtils.getDateFromUTCString(issue.foundDate, "yyyy-MM-dd'T'HH:mm:ss");
                return foundDate.compareTo(vulnerabilitiesQueueItem.getBaselineDate()) >= 0;
            }).collect(Collectors.toList());
        }
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "filterIssuesByBaseLine.size():" + filterIssuesByBaseLine.size());
        return filterIssuesByBaseLine;
    }
}

