/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;

public abstract class AuthenticationStrategy {
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private boolean manageCookies = true;

    public boolean isAuthenticationNeeded() {
        return false;
    }

    public boolean authenticate(HttpClient httpClient, boolean onUnauthorizedRetrial) {
        return false;
    }

    public boolean supportAuthenticationOnUnauthorizedException() {
        return false;
    }

    public void onCreateHttpRequest(RequestBuilder requestBuilder) {
    }

    public void onResponse(HttpResponse httpResponse, HttpClientContext context) {
        if (this.isManageCookies()) {
            context.getCookieStore().getCookies().forEach(c -> this.cookies.put(c.getName(), (Cookie)c));
        }
    }

    public void onCreateContext(HttpClientContext context) {
        if (this.isManageCookies()) {
            this.cookies.values().forEach(c -> context.getCookieStore().addCookie((Cookie)c));
        }
    }

    public boolean isManageCookies() {
        return this.manageCookies;
    }

    public void setManageCookies(boolean manageCookies) {
        this.manageCookies = manageCookies;
    }
}

