/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.github;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMRepositoryLinks;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.exceptions.ResourceNotFoundException;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.BranchFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.CommitUserIdPicker;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchUtils;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.PullRequestFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.RepoTemplates;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.JsonConverter;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.Branch;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.Commit;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.Compare;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.Entity;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.PullRequest;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.PullRequestRepo;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.PullRequestUser;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.RateLimitationInfo;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.Repo;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.SupportUpdatedTime;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.pojo.User;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class GithubV3FetchHandler
extends FetchHandler {
    public static final String CLOUD_SERVICE_PREFIX = "https://github.com/";
    private static final long NO_MIN_UPDATE_TIME = 0L;

    public GithubV3FetchHandler(AuthenticationStrategy authenticationStrategy) {
        super(authenticationStrategy);
    }

    @Override
    protected String parseRequestError(OctaneResponse response) {
        return JsonConverter.getErrorMessage(response.getBody());
    }

    @Override
    public List<com.hp.octane.integrations.dto.scm.Branch> fetchBranches(BranchFetchParameters fp, Map<String, Long> sha2DateMapCache, Consumer<String> logConsumer) throws IOException {
        String baseUrl = this.getRepoApiPath(fp.getRepoUrl());
        String apiUrl = this.getApiPath(fp.getRepoUrl());
        RateLimitationInfo rateLimitationInfo = this.getRateLimitationInfo(apiUrl, logConsumer);
        String branchesUrl = baseUrl + "/branches";
        logConsumer.accept("Branches url : " + branchesUrl);
        List<Branch> branches = this.getPagedEntities(branchesUrl, Branch.class, fp.getPageSize(), Integer.MAX_VALUE, 0L);
        List<Pattern> filterPatterns = FetchUtils.buildPatterns(fp.getFilter());
        List<com.hp.octane.integrations.dto.scm.Branch> filteredBranches = branches.stream().filter(br -> FetchUtils.isBranchMatch(filterPatterns, br.getName())).map(br -> this.convertToDTOBranch((Branch)br)).collect(Collectors.toList());
        logConsumer.accept(String.format("Found %d branches in Github, while %d are matching filters", branches.size(), filteredBranches.size()));
        Repo repo = this.getEntity(baseUrl, Repo.class);
        long outdatedTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(fp.getActiveBranchDays());
        int fetched = 0;
        int rateLimited = 0;
        int outdated = 0;
        int counter = 0;
        int notificationNumber = Math.max(20, filteredBranches.size() * 2 / 100);
        for (com.hp.octane.integrations.dto.scm.Branch branch : filteredBranches) {
            ++counter;
            if (sha2DateMapCache != null && sha2DateMapCache.containsKey(branch.getLastCommitSHA())) {
                branch.setLastCommitTime(sha2DateMapCache.get(branch.getLastCommitSHA()));
                if (branch.getLastCommitTime() < outdatedTime) {
                    ++outdated;
                    continue;
                }
            }
            if ((rateLimitationInfo == null || rateLimitationInfo.getRemaining() > 2) && fetched < fp.getMaxBranchesToFill()) {
                String urlCompareBranchUrl = String.format("%s/compare/%s...%s", baseUrl, repo.getDefault_branch(), branch.getLastCommitSHA());
                Compare compare = this.getEntity(urlCompareBranchUrl, Compare.class);
                Commit lastCommit = this.getEntity(branch.getLastCommitUrl(), Commit.class, rateLimitationInfo);
                String lastCommitTime = null;
                try {
                    lastCommitTime = lastCommit.getCommit().getCommitter().getDate();
                }
                catch (Exception e) {
                    logConsumer.accept("branch doesn't have last commit  data information : " + branch.getName());
                }
                branch.setLastCommitTime(FetchUtils.convertISO8601DateStringToLong(lastCommitTime)).setLastCommiterName(lastCommit.getCommit().getAuthor().getName()).setLastCommiterEmail(lastCommit.getCommit().getAuthor().getEmail()).setIsMerged(compare.getAhead_by() == 0L).setPartial(false);
                ++fetched;
            } else {
                if (rateLimited == 0) {
                    logConsumer.accept(String.format("Skipping fetching because of rate limit. First skipped branch '%s'.)", branch.getName()));
                }
                ++rateLimited;
            }
            if (rateLimited != 0 || counter <= 0 || counter % notificationNumber != 0) continue;
            logConsumer.accept("Fetching branch information " + counter * 100 / filteredBranches.size() + "%");
        }
        this.getRateLimitationInfo(apiUrl, logConsumer);
        logConsumer.accept(String.format("Fetching branches is done, fetched %s, skipped as outdated %s, skipped because of max limit/rate limit %s", fetched, outdated, rateLimited));
        return filteredBranches;
    }

    private com.hp.octane.integrations.dto.scm.Branch convertToDTOBranch(Branch branch) {
        return DTOFactory.getInstance().newDTO(com.hp.octane.integrations.dto.scm.Branch.class).setName(branch.getName()).setLastCommitSHA(branch.getCommit().getSha()).setLastCommitUrl(branch.getCommit().getUrl()).setPartial(true);
    }

    public abstract String getApiPath(String var1);

    @Override
    public List<com.hp.octane.integrations.dto.scm.PullRequest> fetchPullRequests(PullRequestFetchParameters parameters, CommitUserIdPicker commitUserIdPicker, Consumer<String> logConsumer) throws IOException {
        ArrayList<com.hp.octane.integrations.dto.scm.PullRequest> result = new ArrayList<com.hp.octane.integrations.dto.scm.PullRequest>();
        String baseUrl = this.getRepoApiPath(parameters.getRepoUrl());
        String apiUrl = this.getApiPath(parameters.getRepoUrl());
        logConsumer.accept(this.getClass().getSimpleName() + " handler, Base url : " + baseUrl);
        SCMRepositoryLinks links = this.pingRepository(baseUrl, logConsumer);
        parameters.setRepoUrlSsh(links.getSshUrl());
        if (parameters.isUseSSHFormat()) {
            logConsumer.accept("Repo ssh format url : " + parameters.getRepoUrlSsh());
        }
        this.getRateLimitationInfo(apiUrl, logConsumer);
        String pullRequestsUrl = baseUrl + "/pulls?state=all";
        logConsumer.accept("Pull requests url : " + pullRequestsUrl);
        List<PullRequest> pullRequests = this.getPagedEntities(pullRequestsUrl, PullRequest.class, parameters.getMaxPRsToFetch(), parameters.getMaxPRsToFetch(), parameters.getMinUpdateTime());
        List<Pattern> sourcePatterns = FetchUtils.buildPatterns(parameters.getSourceBranchFilter());
        List<Pattern> targetPatterns = FetchUtils.buildPatterns(parameters.getTargetBranchFilter());
        List<PullRequest> filteredPullRequests = pullRequests.stream().filter(pr -> FetchUtils.isBranchMatch(sourcePatterns, pr.getHead().getRef()) && FetchUtils.isBranchMatch(targetPatterns, pr.getBase().getRef())).collect(Collectors.toList());
        logConsumer.accept(String.format("Received %d pull-requests, while %d are matching source/target filters", pullRequests.size(), filteredPullRequests.size()));
        this.printPullRequestTitles(logConsumer, pullRequests, "Received pull-requests:");
        this.printPullRequestTitles(logConsumer, filteredPullRequests, "Matching pull-requests:");
        if (!filteredPullRequests.isEmpty()) {
            Set userUrls = filteredPullRequests.stream().map(PullRequest::getUser).map(PullRequestUser::getUrl).collect(Collectors.toSet());
            logConsumer.accept("Fetching PR owners information ...");
            int counter = 0;
            HashMap<String, User> login2User = new HashMap<String, User>();
            for (String url : userUrls) {
                User user = this.getEntity(url, User.class);
                login2User.put(user.getLogin(), user);
                if (counter > 0 && counter % 10 == 0) {
                    logConsumer.accept("Fetching PR owners information " + counter * 100 / userUrls.size() + "%");
                }
                ++counter;
            }
            Set usersWithoutMails = login2User.values().stream().filter(u -> u.getEmail() == null).map(u -> u.getLogin()).collect(Collectors.toSet());
            if (!usersWithoutMails.isEmpty()) {
                logConsumer.accept("Note : Some users doesn't have defined public email in their profile. For such users, SCM user will contain their login name:  " + usersWithoutMails);
            }
            logConsumer.accept("Fetching PR owners information is done");
            logConsumer.accept("Fetching commits ...");
            counter = 0;
            for (PullRequest pr2 : filteredPullRequests) {
                List<Commit> commits = this.getPagedEntities(pr2.getCommitsUrl(), Commit.class, parameters.getMaxCommitsToFetch(), parameters.getMaxCommitsToFetch(), parameters.getMinUpdateTime());
                ArrayList<SCMCommit> dtoCommits = new ArrayList<SCMCommit>();
                for (Commit commit : commits) {
                    SCMCommit dtoCommit = dtoFactory.newDTO(SCMCommit.class).setRevId(commit.getSha()).setComment(commit.getCommit().getMessage()).setUser(GithubV3FetchHandler.getUserName(commit.getCommit().getCommitter().getEmail(), commit.getCommit().getCommitter().getName())).setUserEmail(commit.getCommit().getCommitter().getEmail()).setTime(FetchUtils.convertISO8601DateStringToLong(commit.getCommit().getCommitter().getDate())).setParentRevId(commit.getParents().get(0).getSha());
                    dtoCommits.add(dtoCommit);
                }
                SCMRepository sourceRepository = this.buildScmRepository(parameters.isUseSSHFormat(), pr2.getHead());
                SCMRepository targetRepository = this.buildScmRepository(parameters.isUseSSHFormat(), pr2.getBase());
                User prAuthor = (User)login2User.get(pr2.getUser().getLogin());
                String userId = GithubV3FetchHandler.getUserName(commitUserIdPicker, prAuthor.getEmail(), prAuthor.getLogin());
                com.hp.octane.integrations.dto.scm.PullRequest dtoPullRequest = dtoFactory.newDTO(com.hp.octane.integrations.dto.scm.PullRequest.class).setId(Integer.toString(pr2.getNumber())).setTitle(pr2.getTitle()).setDescription(pr2.getBody()).setState(pr2.getState()).setCreatedTime(FetchUtils.convertISO8601DateStringToLong(pr2.getCreatedAt())).setUpdatedTime(FetchUtils.convertISO8601DateStringToLong(pr2.getUpdatedAt())).setMergedTime(FetchUtils.convertISO8601DateStringToLong(pr2.getMergedAt())).setIsMerged(pr2.getMergedAt() != null).setAuthorName(userId).setAuthorEmail(prAuthor.getEmail()).setClosedTime(FetchUtils.convertISO8601DateStringToLong(pr2.getClosedAt())).setSelfUrl(pr2.getHtmlUrl()).setSourceRepository(sourceRepository).setTargetRepository(targetRepository).setCommits(dtoCommits);
                result.add(dtoPullRequest);
                if (counter > 0 && counter % 25 == 0) {
                    logConsumer.accept("Fetching commits " + counter * 100 / filteredPullRequests.size() + "%");
                }
                ++counter;
            }
            logConsumer.accept("Fetching commits is done");
            this.getRateLimitationInfo(apiUrl, logConsumer);
            logConsumer.accept("Pull requests are ready");
        } else {
            logConsumer.accept("No new/updated PR is found.");
        }
        return result;
    }

    private void printPullRequestTitles(Consumer<String> logConsumer, List<PullRequest> pullRequests, String textToPrint) {
        if (pullRequests.isEmpty()) {
            return;
        }
        logConsumer.accept(textToPrint);
        for (PullRequest pr : pullRequests) {
            String prTitle = null == pr.getTitle() ? "<no title>" : pr.getTitle();
            logConsumer.accept(prTitle);
        }
    }

    private SCMRepository buildScmRepository(boolean useSSHFormat, PullRequestRepo ref) {
        String url = "unknown repository";
        if (ref.getRepo() != null) {
            url = useSSHFormat && ref.getRepo().getSsh_url() != null ? ref.getRepo().getSsh_url() : ref.getRepo().getClone_url();
        }
        return dtoFactory.newDTO(SCMRepository.class).setUrl(url).setBranch(ref.getRef()).setType(SCMType.GIT);
    }

    private RateLimitationInfo getRateLimitationInfo(String baseUrl, Consumer<String> logConsumer) throws IOException {
        String rateUrl = baseUrl + "/rate_limit";
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setUrl(rateUrl).setMethod(HttpMethod.GET);
        OctaneResponse response = this.restClient.executeRequest(request);
        if (response.getStatus() == 200 && response.getHeaders().containsKey("X-RateLimit-Limit")) {
            RateLimitationInfo info = new RateLimitationInfo();
            this.fillRateLimitationInfo(response, info);
            long minToNextReset = (info.getReset() - System.currentTimeMillis() / 1000L) / 60L;
            logConsumer.accept(String.format("RateLimit Info: Limit-%s; Remaining-%s; Reset in %s min. ", info.getLimit(), info.getRemaining(), minToNextReset));
            return info;
        }
        return null;
    }

    private void fillRateLimitationInfo(OctaneResponse response, RateLimitationInfo info) {
        Map<String, String> toLowerCaseMapping = response.getHeaders().keySet().stream().collect(Collectors.toMap(String::toLowerCase, Function.identity()));
        int limit = (int)this.getRateLimitationInfoValue("X-RateLimit-Limit", toLowerCaseMapping, response);
        int remaining = (int)this.getRateLimitationInfoValue("X-RateLimit-Remaining", toLowerCaseMapping, response);
        int used = (int)this.getRateLimitationInfoValue("X-RateLimit-Used", toLowerCaseMapping, response);
        long reset = this.getRateLimitationInfoValue("X-RateLimit-Reset", toLowerCaseMapping, response);
        info.setLimit(limit).setRemaining(remaining).setUsed(used).setReset(reset);
    }

    private long getRateLimitationInfoValue(String key, Map<String, String> toLowerCaseMapping, OctaneResponse response) {
        String actualKey = toLowerCaseMapping.get(key.toLowerCase());
        if (actualKey != null) {
            return Long.parseLong(response.getHeaders().get(actualKey));
        }
        return 0L;
    }

    private <T extends Entity> List<T> getPagedEntities(String url, Class<T> entityType, int pageSize, int maxTotal, long minUpdateTime) {
        try {
            boolean finished;
            ArrayList<T> result = new ArrayList<T>();
            String myUrl = url + (url.contains("?") ? "" : "?") + "&per_page=" + pageSize;
            do {
                finished = true;
                OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setUrl(myUrl).setMethod(HttpMethod.GET);
                OctaneResponse response = this.restClient.executeRequest(request);
                List<T> collection = JsonConverter.convertCollection(response.getBody(), entityType);
                result.addAll(collection);
                myUrl = this.getNextPageLink(response);
                if (myUrl != null) {
                    finished = false;
                }
                for (int i = result.size() - 1; i >= 0 && minUpdateTime > 0L; --i) {
                    if (((SupportUpdatedTime)((Object)((Entity)result.get(i)))).getUpdatedTime() > minUpdateTime) continue;
                    result.remove(i);
                }
                while (result.size() > maxTotal) {
                    result.remove(result.size() - 1);
                    finished = true;
                }
            } while (!finished);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getPagedEntities : " + e.getMessage(), e);
        }
    }

    private <T extends Entity> T getEntity(String url, Class<T> entityType) {
        return this.getEntity(url, entityType, null);
    }

    private <T extends Entity> T getEntity(String url, Class<T> entityType, RateLimitationInfo rateLimitationInfo) {
        try {
            OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setUrl(url).setMethod(HttpMethod.GET);
            OctaneResponse response = this.restClient.executeRequest(request);
            if (response.getStatus() == 404) {
                throw new ResourceNotFoundException(String.format("URL %s not found", url));
            }
            if (rateLimitationInfo != null) {
                this.fillRateLimitationInfo(response, rateLimitationInfo);
            }
            return (T)((Entity)JsonConverter.convert(response.getBody(), entityType));
        }
        catch (ResourceNotFoundException notFoundException) {
            throw notFoundException;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getEntity : " + e.getMessage(), e);
        }
    }

    private String getNextPageLink(OctaneResponse response) {
        String linkHeaderValue = response.getHeaders().get("Link");
        if (linkHeaderValue != null) {
            String[] linksArr;
            for (String link : linksArr = linkHeaderValue.split(",")) {
                String next;
                String[] segments;
                if (!link.endsWith("rel=\"next\"") || (segments = link.split(";")).length != 2 || !(next = segments[0].trim()).startsWith("<") || !next.endsWith(">")) continue;
                return next.substring(1, next.length() - 1);
            }
        }
        return null;
    }

    @Override
    public RepoTemplates buildRepoTemplates(String repoApiBaseUrl) {
        String selfUrl = repoApiBaseUrl.substring(0, repoApiBaseUrl.length() - 4);
        RepoTemplates repoTemplates = new RepoTemplates();
        repoTemplates.setDiffTemplate(selfUrl + "/commit/{revision}#{filePath}");
        repoTemplates.setSourceViewTemplate(selfUrl + "/blob/{revision}/{filePath}");
        repoTemplates.setBranchFileTemplate(selfUrl + "/tree/{branchName}/{filePath}");
        return repoTemplates;
    }

    @Override
    public SCMRepositoryLinks parseSCMRepositoryLinks(String responseBody) throws JsonProcessingException {
        Repo repo = JsonConverter.convert(responseBody, Repo.class);
        SCMRepositoryLinks links = dtoFactory.newDTO(SCMRepositoryLinks.class).setHttpUrl(repo.getClone_url()).setSshUrl(repo.getSsh_url());
        return links;
    }
}

