/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.entities;

import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class QueryHelper {
    public static String conditionRef(String name, long id) {
        return name + "={id=" + id + "}";
    }

    public static String conditionRef(String name, String refName, String value) {
        return name + "={" + QueryHelper.condition(refName, value) + "}";
    }

    public static String conditionRefEmpty(String name) {
        return name + "={null}";
    }

    public static String conditionNot(String condition) {
        return "!" + condition;
    }

    public static String conditionStartWith(String name, String value) {
        return name + "='" + QueryHelper.escapeQueryValue(value) + "*'";
    }

    public static String condition(String name, String value) {
        return name + "='" + QueryHelper.escapeQueryValue(value) + "'";
    }

    public static String condition(String name, int value) {
        return name + "=" + value;
    }

    public static String conditionEmpty(String name) {
        return name + "=null";
    }

    public static String condition(String name, long value) {
        return name + "=" + value;
    }

    public static String condition(String name, boolean value) {
        return name + "=" + value;
    }

    public static String orConditions(String ... conditions) {
        return "(" + Arrays.stream(conditions).map(c -> "(" + c + ")").collect(Collectors.joining("||")) + ")";
    }

    public static String conditionIn(String name, Collection<?> data, boolean isNumber) {
        if (isNumber) {
            return name + " IN " + SdkStringUtils.join(data, ",");
        }
        data = data.stream().map(o -> QueryHelper.escapeQueryValue((String)o)).collect(Collectors.toList());
        return name + " IN '" + SdkStringUtils.join(data, "','") + "'";
    }

    private static String escapeQueryValue(String value) {
        return value.replaceAll("(\\\\)", "$1$1").replaceAll("([\"'()])", "\\\\$1");
    }
}

