/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.executor.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestsToRunConverter;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomConverter
extends TestsToRunConverter {
    private static final String $_PACKAGE = "$package";
    private static final String $_CLASS = "$class";
    private static final String $_TEST_NAME = "$testName";
    private CustomFormat customFormat;

    public CustomConverter() {
    }

    public CustomConverter(String format) {
        this.setFormatInternal(format);
    }

    @Override
    public TestsToRunConverter setFormat(String format) {
        if (this.customFormat == null) {
            this.setFormatInternal(format);
        }
        return this;
    }

    protected TestsToRunConverter setFormatInternal(String format) {
        this.customFormat = CustomConverter.buildCustomFormat(format);
        if (SdkStringUtils.isNotEmpty(this.customFormat.getTestsToRunConvertedParameterName())) {
            this.setTestsToRunConvertedParameterName(this.customFormat.getTestsToRunConvertedParameterName());
        }
        return this;
    }

    protected static CustomFormat buildCustomFormat(String format) {
        CustomFormat customFormat = new CustomFormat();
        String defaultErrorTemplate = "Field '%s' is missing in format json";
        Map parsed = CustomConverter.parseJson(format, Map.class);
        customFormat.setAllowDuplication(CustomConverter.getMapValue(parsed, "allowDuplication", false, true));
        customFormat.setTestPattern(CustomConverter.getStringRequiredMapValue(parsed, "testPattern", defaultErrorTemplate));
        customFormat.setTestDelimiter(CustomConverter.getMapValue(parsed, "testDelimiter", false, ""));
        customFormat.setPrefix(CustomConverter.getMapValue(parsed, "prefix", false, ""));
        customFormat.setSuffix(CustomConverter.getMapValue(parsed, "suffix", false, ""));
        customFormat.setTestsToRunConvertedParameterName(CustomConverter.getMapValue(parsed, "testsToRunConvertedParameter", false, "testsToRunConverted"));
        List<Map> rawReplacement = (List<Map>)parsed.get("replacements");
        if (rawReplacement == null) {
            rawReplacement = Collections.emptyList();
        }
        rawReplacement.forEach(m -> {
            ReplaceAction action;
            String replacementType = CustomConverter.getMapValue(m, "type", true, null);
            String targetsRaw = CustomConverter.getMapValue(m, "target", true, null);
            HashSet<String> targets = new HashSet<String>(Arrays.asList(targetsRaw.split(Pattern.quote("|"))));
            targets.forEach(t -> {
                if (!t.startsWith("$")) {
                    throw new IllegalArgumentException(String.format("Illegal target '%s' in replacement '%s'. Target values must start with '$', for example $%s.", t, replacementType, t));
                }
            });
            String errorMessage = null;
            switch (replacementType) {
                case "notLatinAndDigitToOctal": {
                    action = new NotLatinAndDigitToOctal();
                    break;
                }
                case "replaceRegex": {
                    errorMessage = "The replacement 'replaceRegex' is missing field '%s'";
                    action = new ReplaceRegex().initialize(CustomConverter.getStringRequiredMapValue(m, "regex", errorMessage), CustomConverter.getStringRequiredMapValue(m, "replacement", errorMessage));
                    break;
                }
                case "replaceRegexFirst": {
                    errorMessage = "The replacement 'replaceRegexFirst' is missing field '%s'";
                    action = new ReplaceRegexFirst().initialize(CustomConverter.getStringRequiredMapValue(m, "regex", errorMessage), CustomConverter.getStringRequiredMapValue(m, "replacement", errorMessage));
                    break;
                }
                case "replaceString": {
                    errorMessage = "The replacement 'replaceString' is missing field '%s'";
                    action = new ReplaceString().initialize(CustomConverter.getStringRequiredMapValue(m, "string", errorMessage), CustomConverter.getStringRequiredMapValue(m, "replacement", errorMessage));
                    break;
                }
                case "joinString": {
                    action = new JoinString().initialize(CustomConverter.getMapValue(m, "prefix", "", false, null), CustomConverter.getMapValue(m, "suffix", "", false, null));
                    break;
                }
                case "toUpperCase": {
                    action = new ToUpperCase();
                    break;
                }
                case "toLowerCase": {
                    action = new ToLowerCase();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown replacement type '%s'", replacementType));
                }
            }
            for (String t2 : targets) {
                if (!customFormat.getReplacements().containsKey(t2)) {
                    customFormat.getReplacements().put(t2, new ArrayList());
                }
                customFormat.getReplacements().get(t2).add(action);
            }
        });
        return customFormat;
    }

    private static <T> T getMapValue(Map<String, Object> map, String fieldName, boolean required, T defaultValue) {
        return CustomConverter.getMapValue(map, fieldName, defaultValue, required, "Field '%s' is missing in format json");
    }

    private static String getStringRequiredMapValue(Map<String, Object> map, String fieldName, String errorMessageTemplateIfNull) {
        return CustomConverter.getMapValue(map, fieldName, "", true, errorMessageTemplateIfNull);
    }

    private static <T> T getMapValue(Map<String, Object> map, String fieldName, T defaultValue, boolean required, String errorMessageTemplateIfNull) {
        if (map.containsKey(fieldName)) {
            Object obj = map.get(fieldName);
            if (obj != null && defaultValue != null && obj instanceof String && !(defaultValue instanceof String)) {
                String suffix = "";
                if (defaultValue instanceof Boolean) {
                    suffix = ". Expected boolean value.";
                }
                throw new IllegalArgumentException("Illegal value for field " + fieldName + suffix);
            }
            return (T)obj;
        }
        if (required) {
            throw new IllegalArgumentException(String.format(errorMessageTemplateIfNull, fieldName));
        }
        return defaultValue;
    }

    @Override
    public String convertInternal(List<TestToRunData> data, String executionDirectory, Map<String, String> globalParameters) {
        HashSet<String> existingKeys = new HashSet<String>();
        this.addToSetIfPatterContains(existingKeys, $_PACKAGE);
        this.addToSetIfPatterContains(existingKeys, $_CLASS);
        this.addToSetIfPatterContains(existingKeys, $_TEST_NAME);
        data.stream().flatMap(t -> t.getParameters().keySet().stream()).map(param -> "$" + param).forEach(key -> this.addToSetIfPatterContains((Set<String>)existingKeys, (String)key));
        Stream<String> stream = data.stream().map(n -> this.convertToFormat((TestToRunData)n, (Set<String>)existingKeys)).filter(str -> str != null && !str.isEmpty());
        if (!this.customFormat.allowDuplication) {
            stream = stream.distinct();
        }
        String result = stream.collect(Collectors.joining(this.customFormat.getTestDelimiter(), this.customFormat.getPrefix(), this.customFormat.getSuffix()));
        return result;
    }

    private void addToSetIfPatterContains(Set<String> set, String key) {
        if (this.customFormat.getTestPattern().contains(key)) {
            set.add(key);
        }
    }

    protected String convertToFormat(TestToRunData testToRunData, Set<String> keysInTemplate) {
        int packageIndex = this.customFormat.getTestPattern().indexOf($_PACKAGE);
        String res = this.customFormat.getTestPattern();
        if (keysInTemplate.contains($_PACKAGE)) {
            String packageName = testToRunData.getPackageName();
            res = SdkStringUtils.isNotEmpty(packageName) ? res.replace($_PACKAGE, this.handleReplacements($_PACKAGE, packageName)) : (keysInTemplate.contains($_CLASS) ? this.splice(res, packageIndex, res.indexOf($_CLASS)) : this.splice(res, packageIndex, res.indexOf($_TEST_NAME)));
        }
        if (keysInTemplate.contains($_CLASS)) {
            String className = testToRunData.getClassName();
            res = SdkStringUtils.isNotEmpty(className) ? res.replace($_CLASS, this.handleReplacements($_CLASS, className)) : this.splice(res, res.indexOf($_CLASS), res.indexOf($_TEST_NAME));
        }
        res = res.replace($_TEST_NAME, this.handleReplacements($_TEST_NAME, testToRunData.getTestName()));
        for (Map.Entry entry : testToRunData.getParameters().entrySet()) {
            String replacementKey = "$" + (String)entry.getKey();
            if (!keysInTemplate.contains(replacementKey)) continue;
            res = res.replace(replacementKey, this.handleReplacements(replacementKey, (String)entry.getValue()));
        }
        Set<String> existingParameters = testToRunData.getParameters().keySet();
        Set set = keysInTemplate.stream().filter(key -> !existingParameters.contains(key)).filter(key -> !$_CLASS.equals(key) || !$_PACKAGE.equals(key) || !$_TEST_NAME.equals(key)).collect(Collectors.toSet());
        for (String missingParam : set) {
            res = res.replace(missingParam, "");
        }
        return res;
    }

    private String handleReplacements(String target, String str) {
        List<ReplaceAction> targetReplacements = this.customFormat.getReplacements().get(target);
        if (targetReplacements == null) {
            return str;
        }
        String myStr = str;
        for (ReplaceAction action : targetReplacements) {
            myStr = action.replace(myStr);
        }
        return myStr;
    }

    private String splice(String string, int beginIndex, int endIndex) {
        return string.substring(0, beginIndex) + string.substring(endIndex);
    }

    private static <T> T parseJson(String content, Class<T> valueType) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            T value = mapper.readValue(content, valueType);
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse :" + e.getMessage(), e);
        }
    }

    public static class NotLatinAndDigitToOctal
    implements ReplaceAction {
        @Override
        public String replace(String str) {
            StringBuilder sb = new StringBuilder(str.length());
            for (char c : str.toCharArray()) {
                if (this.isLatinLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                String octalRepresentation = String.format("\\%03o", c);
                sb.append(octalRepresentation);
            }
            return sb.toString();
        }

        private boolean isLatinLetterOrDigit(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }
    }

    public static class JoinString
    implements ReplaceAction {
        private String prefix;
        private String suffix;

        public JoinString initialize(String prefix, String suffix) {
            this.prefix = prefix == null ? "" : prefix;
            this.suffix = suffix == null ? "" : suffix;
            return this;
        }

        @Override
        public String replace(String string) {
            return this.prefix + string + this.suffix;
        }
    }

    public static class ToLowerCase
    implements ReplaceAction {
        @Override
        public String replace(String string) {
            return string.toLowerCase();
        }
    }

    public static class ToUpperCase
    implements ReplaceAction {
        @Override
        public String replace(String string) {
            return string.toUpperCase();
        }
    }

    public static class ReplaceRegexFirst
    implements ReplaceAction {
        private String regex;
        private String replacement;

        public ReplaceRegexFirst initialize(String regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
            return this;
        }

        @Override
        public String replace(String string) {
            return string.replaceFirst(this.regex, this.replacement);
        }
    }

    public static class ReplaceRegex
    implements ReplaceAction {
        private String regex;
        private String replacement;

        public ReplaceRegex initialize(String regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
            return this;
        }

        @Override
        public String replace(String string) {
            return string.replaceAll(this.regex, this.replacement);
        }
    }

    public static class ReplaceString
    implements ReplaceAction {
        private String str;
        private String replacement;

        public ReplaceString initialize(String str, String replacement) {
            this.str = str;
            this.replacement = replacement;
            return this;
        }

        @Override
        public String replace(String string) {
            return string.replace(this.str, this.replacement);
        }
    }

    public static class CustomFormat {
        private String testDelimiter = "";
        private String testPattern = "";
        private String prefix = "";
        private String suffix = "";
        private boolean allowDuplication = true;
        private String testsToRunConvertedParameterName;
        private Map<String, List<ReplaceAction>> replacements = new HashMap<String, List<ReplaceAction>>();

        public String getTestDelimiter() {
            return this.testDelimiter;
        }

        public CustomFormat setTestDelimiter(String testDelimiter) {
            this.testDelimiter = testDelimiter;
            return this;
        }

        public String getTestPattern() {
            return this.testPattern;
        }

        public CustomFormat setTestPattern(String testPattern) {
            this.testPattern = testPattern;
            return this;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public CustomFormat setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Map<String, List<ReplaceAction>> getReplacements() {
            return this.replacements;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getTestsToRunConvertedParameterName() {
            return this.testsToRunConvertedParameterName;
        }

        public CustomFormat setTestsToRunConvertedParameterName(String testsToRunConvertedParameterName) {
            this.testsToRunConvertedParameterName = testsToRunConvertedParameterName;
            return this;
        }

        public boolean isAllowDuplication() {
            return this.allowDuplication;
        }

        public void setAllowDuplication(boolean allowDuplication) {
            this.allowDuplication = allowDuplication;
        }
    }

    public static interface ReplaceAction {
        public String replace(String var1);
    }
}

