/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations;

import com.hp.octane.integrations.CIPluginServices;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneClientImpl;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.general.OctaneConnectivityStatus;
import com.hp.octane.integrations.exceptions.OctaneConnectivityException;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OctaneSDK {
    private static final Logger logger = LogManager.getLogger(OctaneSDK.class);
    private static final Map<OctaneConfiguration, OctaneClient> clients = new LinkedHashMap<OctaneConfiguration, OctaneClient>();
    public static final Integer API_VERSION;
    public static final String SDK_VERSION;

    public static synchronized OctaneClient addClient(OctaneConfiguration octaneConfiguration, Class<? extends CIPluginServices> pluginServicesClass) {
        CIPluginServices pluginServices;
        long startTime = System.currentTimeMillis();
        if (octaneConfiguration == null) {
            throw new IllegalArgumentException("octane configuration MUST NOT be null");
        }
        if (clients.containsKey(octaneConfiguration)) {
            throw new IllegalStateException("provided octane configuration instance already in use");
        }
        String instanceId = octaneConfiguration.getInstanceId();
        logger.info(octaneConfiguration.getLocationForLog() + "Octane Client instance initializing, instanceId " + octaneConfiguration.getInstanceId());
        if (!OctaneSDK.isInstanceIdUnique(instanceId)) {
            throw new IllegalStateException("SDK instance claiming for instance ID [" + instanceId + "] is already present");
        }
        String sharedSpace = octaneConfiguration.getSharedSpace();
        if (!OctaneSDK.isSharedSpaceUnique(octaneConfiguration.getUrl(), sharedSpace)) {
            throw new IllegalStateException("SDK instance claiming for shared space ID [" + sharedSpace + "] is already present");
        }
        if (pluginServicesClass == null) {
            throw new IllegalArgumentException("plugin service class MUST be initialized with valid plugin services provider");
        }
        try {
            pluginServices = pluginServicesClass.newInstance();
            pluginServices.setInstanceId(instanceId);
            if (!pluginServices.isValid()) {
                throw new IllegalArgumentException("plugin services implementation is invalid");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("failed to instantiate plugin services '" + pluginServicesClass.getSimpleName() + "'", e);
        }
        OctaneClientImpl newInstance = new OctaneClientImpl(new SDKServicesConfigurer(octaneConfiguration, pluginServices));
        octaneConfiguration.attached = true;
        clients.put(octaneConfiguration, newInstance);
        long initTime = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info(octaneConfiguration.getLocationForLog() + "OctaneClient is initialized SUCCESSFULLY in " + initTime + " sec.");
        return newInstance;
    }

    public static List<OctaneClient> getClients() {
        return new ArrayList<OctaneClient>(clients.values());
    }

    public static boolean hasClients() {
        return !clients.isEmpty();
    }

    public static OctaneClient getClientByInstanceId(String instanceId) throws IllegalStateException {
        if (instanceId == null || instanceId.isEmpty()) {
            throw new IllegalArgumentException("instance ID MUST NOT be null nor empty");
        }
        OctaneClient result = clients.entrySet().stream().filter(e -> instanceId.equals(((OctaneConfiguration)e.getKey()).getInstanceId())).findFirst().map(Map.Entry::getValue).orElse(null);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("no client with instance ID [" + instanceId + "] present");
    }

    public static synchronized OctaneClient removeClient(OctaneClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client MUST NOT be null");
        }
        Map.Entry<OctaneConfiguration, OctaneClient> targetEntry = null;
        for (Map.Entry<OctaneConfiguration, OctaneClient> entry : clients.entrySet()) {
            if (entry.getValue() != client) continue;
            targetEntry = entry;
            break;
        }
        OctaneClient removedClient = null;
        if (targetEntry != null) {
            try {
                removedClient = clients.remove(targetEntry.getKey());
                targetEntry.getKey().attached = false;
                if (removedClient != null) {
                    ((OctaneClientImpl)targetEntry.getValue()).remove();
                }
            }
            catch (Throwable throwable) {
                logger.error("failure detected while closing OctaneClient", throwable);
            }
        }
        return removedClient;
    }

    public static List<Entity> testOctaneConfigurationAndFetchAvailableWorkspaces(String octaneServerUrl, String sharedSpaceId, String client, String secret, Class<? extends CIPluginServices> pluginServicesClass) throws IOException {
        CIPluginServices pluginServices;
        OctaneConfiguration configuration = OctaneConfiguration.create(UUID.randomUUID().toString(), octaneServerUrl, sharedSpaceId);
        configuration.setSecret(secret);
        configuration.setClient(client);
        if (pluginServicesClass == null) {
            throw new IllegalArgumentException("plugin services provider is invalid");
        }
        try {
            pluginServices = pluginServicesClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("failed to instantiate plugin services '" + pluginServicesClass.getSimpleName() + "'", e);
        }
        SDKServicesConfigurer configurer = new SDKServicesConfigurer(configuration, pluginServices);
        RestService restService = RestService.newInstance(configurer);
        ConfigurationService configurationService = ConfigurationService.newInstance(configurer, restService);
        OctaneConnectivityStatus octaneConnectivityStatus = configurationService.validateConfigurationAndGetConnectivityStatus();
        if (!CIPluginSDKUtils.isSdkSupported(octaneConnectivityStatus)) {
            throw new OctaneConnectivityException(0, "UNSUPPORTED_SDK_VERSION", "This plugin version is outdated and is not supported by ALM Octane.");
        }
        try {
            EntitiesService entitiesService = EntitiesService.newInstance(configurer, restService);
            List<Entity> workspaces = entitiesService.getEntities(null, "workspaces", null, Arrays.asList("name"));
            return workspaces;
        }
        catch (Exception e) {
            logger.error(configuration.getLocationForLog() + "Failed to fetch workspaces in testOctaneConfigurationAndFetchAvailableWorkspaces : " + e.getMessage());
            return null;
        }
    }

    static boolean isInstanceIdUnique(String instanceId) {
        return clients.keySet().stream().noneMatch(oc -> oc.getInstanceId().equals(instanceId));
    }

    static boolean isSharedSpaceUnique(String host, String sharedSpace) {
        return clients.keySet().stream().noneMatch(oc -> (oc.getUrl() + oc.getSharedSpace()).equals(host + sharedSpace));
    }

    static {
        Properties p = new Properties();
        try {
            p.load(OctaneSDK.class.getClassLoader().getResourceAsStream("sdk.properties"));
            if (p.isEmpty()) {
                throw new IllegalStateException("SDK properties found to be empty (someone tampered with the binary? 'sdk.properties' resource has been overrode?)");
            }
            API_VERSION = Integer.parseInt(p.getProperty("api.version"));
            SDK_VERSION = p.getProperty("sdk.version");
        }
        catch (Throwable t) {
            logger.error("initialization failed: failed to load SDK properties", t);
            throw new IllegalStateException("OctaneSDK initialization failed: failed to load SDK properties", t);
        }
    }

    public static final class SDKServicesConfigurer {
        public final OctaneConfiguration octaneConfiguration;
        public final CIPluginServices pluginServices;

        private SDKServicesConfigurer(OctaneConfiguration octaneConfiguration, CIPluginServices pluginServices) {
            this.octaneConfiguration = octaneConfiguration;
            this.pluginServices = pluginServices;
        }
    }
}

