/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.uft;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.ChainCreationService;
import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.RequirementService;
import com.atlassian.bamboo.variable.VariableConfigurationService;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.web.utils.BuildConfigurationActionHelper;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.sal.api.component.ComponentLocator;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.CredentialsInfo;
import com.hp.octane.integrations.dto.executor.DiscoveryInfo;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.hp.octane.plugins.bamboo.octane.ArtifactsHelper;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UftManager {
    private BambooUserManager bambooUserManager = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
    private ChainCreationService chainCreationService = (ChainCreationService)ComponentLocator.getComponent(ChainCreationService.class);
    private CredentialsManager credentialsManager = (CredentialsManager)ComponentLocator.getComponent(CredentialsManager.class);
    private EncryptionService encryptionService = (EncryptionService)ComponentLocator.getComponent(EncryptionService.class);
    private CachedPlanManager cachedPlanManager;
    private PlanManager planManager = (PlanManager)ComponentLocator.getComponent(PlanManager.class);
    private ProjectManager projectManager;
    private JobCreationService jobCreationService;
    private TriggerTypeManager triggerTypeManager;
    private TriggerConfigurationService triggerConfigurationService;
    private VariableConfigurationService variableConfigurationService;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private VcsRepositoryManager vcsRepositoryManager;
    private VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    private RequirementService requirementService;
    private static String CREDENTIALS_USERNAME_FIELD = "username";
    private static String CREDENTIALS_PASSWORD_FIELD = "password";
    private static String USERNAME_PASSWORD_PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials";
    private static String SSH_CREDENTIALS_PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials";
    private static String DISCOVERY_TASK_PLUGIN_KEY = "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octaneUftTestDiscovery";
    private static String EXECUTION_TASK_PLUGIN_KEY = "com.adm.app-delivery-management-bamboo:RunFromFileSystemUftTask";
    private static String CONVERTER_TASK_PLUGIN_KEY = "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octaneTestFrameworkConverter";
    private static String UFT_REQUIREMENT_KEY = "system.builder.Micro Focus.Unified Functional Testing";
    private static final String TRIGGER_POLLING_PLUGIN_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
    public static final String PROJECT_KEY = "UOI";
    public static final String DISCOVERY_PREFIX_KEY = "UFTDISCOVERY";
    public static final String EXECUTOR_PREFIX_KEY = "UFTEXECUTOR";
    public static final String ALL_USERS = "ALL_USERS";
    private static final Logger log = SDKBasedLoggerProvider.getLogger(UftManager.class);
    private static final String UFT_INTEGRATION_PREFIX = "UFT";
    private static UftManager instance = new UftManager();

    public static UftManager getInstance() {
        return instance;
    }

    private UftManager() {
        this.cachedPlanManager = (CachedPlanManager)ComponentLocator.getComponent(CachedPlanManager.class);
        this.projectManager = (ProjectManager)ComponentLocator.getComponent(ProjectManager.class);
        this.repositoryDefinitionManager = (RepositoryDefinitionManager)ComponentLocator.getComponent(RepositoryDefinitionManager.class);
        this.vcsRepositoryConfigurationService = (VcsRepositoryConfigurationService)ComponentLocator.getComponent(VcsRepositoryConfigurationService.class);
        this.vcsRepositoryManager = (VcsRepositoryManager)ComponentLocator.getComponent(VcsRepositoryManager.class);
        this.jobCreationService = (JobCreationService)ComponentLocator.getComponent(JobCreationService.class);
        this.triggerTypeManager = (TriggerTypeManager)ComponentLocator.getComponent(TriggerTypeManager.class);
        this.triggerConfigurationService = (TriggerConfigurationService)ComponentLocator.getComponent(TriggerConfigurationService.class);
        this.variableConfigurationService = (VariableConfigurationService)ComponentLocator.getComponent(VariableConfigurationService.class);
        this.requirementService = (RequirementService)ComponentLocator.getComponent(RequirementService.class);
    }

    public List<CredentialsInfo> getCredentials() {
        ArrayList<CredentialsInfo> results = new ArrayList<CredentialsInfo>();
        Iterable allCredentials = this.credentialsManager.getAllCredentials();
        for (CredentialsData cred : allCredentials) {
            if (!cred.getPluginKey().equals(USERNAME_PASSWORD_PLUGIN_KEY) && !cred.getPluginKey().equals(SSH_CREDENTIALS_PLUGIN_KEY)) continue;
            CredentialsInfo cr = DefaultOctaneConverter.getDTOFactory().newDTO(CredentialsInfo.class).setUsername(cred.getName()).setCredentialsId(Long.toString(cred.getId()));
            results.add(cr);
        }
        return results;
    }

    public OctaneResponse upsertCredentials(CredentialsInfo credentialsInfo) {
        OctaneResponse result = DefaultOctaneConverter.getDTOFactory().newDTO(OctaneResponse.class);
        result.setStatus(201);
        if (SdkStringUtils.isNotEmpty(credentialsInfo.getUsername()) && credentialsInfo.getPassword() != null) {
            boolean found = false;
            Iterable credentialsIterator = this.credentialsManager.getAllCredentials(USERNAME_PASSWORD_PLUGIN_KEY);
            for (CredentialsData cred : credentialsIterator) {
                if (!cred.getName().startsWith(UFT_INTEGRATION_PREFIX)) continue;
                String credUserName = cred.getName();
                String credPassword = (String)cred.getConfiguration().get(CREDENTIALS_PASSWORD_FIELD);
                if (!SdkStringUtils.equals(credentialsInfo.getUsername(), credUserName) || !SdkStringUtils.equals(credentialsInfo.getPassword(), this.encryptionService.decrypt(credPassword))) continue;
                result.setBody(Long.toString(cred.getId()));
                found = true;
                break;
            }
            if (!found) {
                HashMap<String, String> confMap = new HashMap<String, String>();
                confMap.put(CREDENTIALS_USERNAME_FIELD, credentialsInfo.getUsername());
                confMap.put(CREDENTIALS_PASSWORD_FIELD, this.encryptionService.encrypt(credentialsInfo.getPassword()));
                CredentialTypeModuleDescriptor credentialTypeModuleDescriptor = this.credentialsManager.getCredentialTypeDescriptor(USERNAME_PASSWORD_PLUGIN_KEY);
                try {
                    CredentialsData cred = this.credentialsManager.createCredentials(credentialTypeModuleDescriptor, this.createCredentialName(credentialsInfo.getUsername(), true), confMap);
                    result.setBody(Long.toString(cred.getId()));
                }
                catch (Exception e) {
                    result.setStatus(500);
                    result.setBody("Failed to create credentials " + e.getMessage());
                    log.error("Failed to create credentials " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public OctaneResponse checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo) {
        log.info("checkRepositoryConnectivity");
        OctaneResponse result = DefaultOctaneConverter.getDTOFactory().newDTO(OctaneResponse.class);
        if (testConnectivityInfo.getScmRepository() == null || SdkStringUtils.isEmpty(testConnectivityInfo.getScmRepository().getUrl())) {
            result.setStatus(400);
            result.setBody("Missing input for testing");
        } else {
            try {
                PartialVcsRepositoryData vcsRepositoryData = this.createRepositoryData("tempRepositoryForTestingConnectivity", testConnectivityInfo.getScmRepository(), testConnectivityInfo.getUsername(), testConnectivityInfo.getPassword(), testConnectivityInfo.getCredentialsId());
                VcsRepositoryModuleDescriptor vcsDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
                ErrorCollection errors = vcsDescriptor.getConnectionTester().testConnection(vcsRepositoryData.getCompleteData(), 1L, TimeUnit.MINUTES);
                if (errors.getErrorMessages().isEmpty()) {
                    result.setStatus(200);
                } else {
                    result.setStatus(403);
                    result.setBody((String)errors.getErrorMessages().iterator().next());
                }
            }
            catch (Exception e) {
                result.setStatus(500);
                result.setBody("Exception occurred : " + e.getMessage());
            }
        }
        return result;
    }

    public void runTestDiscovery(DiscoveryInfo discoveryInfo, String impersonatedUser) {
        try {
            log.info("Creating TestDiscovery plan for " + discoveryInfo.getScmRepository().getUrl());
            BambooUser bambooUser = this.bambooUserManager.getBambooUser(impersonatedUser);
            Project project = this.getMainProject();
            VcsRepositoryData linkedRepository = this.getLinkedRepository(discoveryInfo.getScmRepository(), discoveryInfo.getScmRepositoryCredentialsId(), bambooUser);
            this.buildDiscoveryPlan(project, discoveryInfo, linkedRepository);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to runTestDiscovery : " + e.getMessage(), e);
        }
    }

    public void deleteExecutor(String id) {
        log.info("deleteExecutor " + id);
        String discoveryKeyPrefixById = this.createChainBuildKey(DISCOVERY_PREFIX_KEY, id, "");
        String discoveryKeyPrefixByLogical = "LOGICAL" + id.toUpperCase();
        Project project = this.getMainProject();
        List plans = this.planManager.getAllPlansByProject(project, TopLevelPlan.class);
        for (TopLevelPlan plan : plans) {
            if (!plan.getBuildKey().startsWith(DISCOVERY_PREFIX_KEY) || !plan.getBuildKey().startsWith(discoveryKeyPrefixById) && !plan.getBuildKey().contains(discoveryKeyPrefixByLogical)) continue;
            this.planManager.markPlansForDeletion(plan.getPlanKey());
        }
    }

    private String createCredentialName(String username, boolean creation) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        String createOrUpdate = creation ? " , created on " : " , updated on ";
        String credentialsName = "UFT - " + username + createOrUpdate + formatter.format(new Date());
        return credentialsName;
    }

    private Project getMainProject() {
        String name = "UftOctaneIntegration";
        String desc = "This project was created by the Micro Focus Octane plugin for managing execution of UFT tests and integration with ALM Octane.";
        Project project = this.projectManager.getProjectByKey(PROJECT_KEY);
        if (project == null) {
            project = this.projectManager.createProject(PROJECT_KEY, name, desc);
            this.projectManager.saveProject(project);
        }
        return project;
    }

    private Plan buildDiscoveryPlan(Project project, DiscoveryInfo discoveryInfo, VcsRepositoryData linkedRepository) throws PlanCreationDeniedException {
        String description = String.format("This plan was created by the Micro Focus plugin for discovery of UFT tests. It is associated with ALM Octane test runner #%s.", discoveryInfo.getExecutorId());
        String key = this.createChainBuildKey(DISCOVERY_PREFIX_KEY, discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName());
        String name = String.format("UFT test discovery - Test Runner ID %s (%s)", discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName());
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        String chainBuildKeyStr = this.createChain(project, linkedRepository, key, description, name, buildConfiguration);
        ActionParametersMap actionParametersMap = this.configureDefaultStageAndJob(buildConfiguration, chainBuildKeyStr);
        this.configureDiscoveryTask(buildConfiguration, discoveryInfo);
        this.jobCreationService.createJobAndBranches(buildConfiguration, actionParametersMap, PlanCreationService.EnablePlan.ENABLED);
        PlanKey chainKey = PlanKeys.getPlanKey((String)chainBuildKeyStr);
        Chain chain = (Chain)this.planManager.getPlanByKeyIfOfType(chainKey, Chain.class);
        PlanRepositoryLink repositoryLink = (PlanRepositoryLink)this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)chain).get(0);
        this.createPollTrigger(chainKey, repositoryLink.getRepositoryDataEntity().getId());
        Job job = (Job)((ChainStage)chain.getAllStages().get(0)).getJobs().iterator().next();
        this.registerArtifactForDiscovery(job);
        this.chainCreationService.triggerCreationCompleteEvents(chainKey);
        return chain;
    }

    private void configureDiscoveryTask(BuildConfiguration buildConfiguration, DiscoveryInfo discoveryInfo) {
        LinkedList<TaskDefinitionImpl> tasks = new LinkedList<TaskDefinitionImpl>(TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)"buildTasks.", (HierarchicalConfiguration)buildConfiguration));
        TaskDefinitionImpl discoveryTask = new TaskDefinitionImpl(TaskConfigurationUtils.getUniqueId(tasks), DISCOVERY_TASK_PLUGIN_KEY, "Discover UFT tests and data tables", true, new HashMap());
        discoveryTask.getConfiguration().put("scmRepositoryId", discoveryInfo.getScmRepositoryId());
        discoveryTask.getConfiguration().put("testRunnerId", discoveryInfo.getExecutorId());
        discoveryTask.getConfiguration().put("workspaceId", discoveryInfo.getWorkspaceId());
        discoveryTask.getConfiguration().put("spaceConfigurationId", discoveryInfo.getConfigurationId());
        tasks.add(discoveryTask);
        buildConfiguration.clearTree("buildTasks");
        TaskConfigurationUtils.addTaskDefinitionsToConfig(tasks, (HierarchicalConfiguration)buildConfiguration, (String)"buildTasks.");
    }

    private void configureExecutionTask(BuildConfiguration buildConfiguration) {
        LinkedList<TaskDefinitionImpl> tasks = new LinkedList<TaskDefinitionImpl>(TaskConfigurationUtils.getTaskDefinitionsFromConfig((String)"buildTasks.", (HierarchicalConfiguration)buildConfiguration));
        TaskDefinitionImpl convertTask = new TaskDefinitionImpl(1L, CONVERTER_TASK_PLUGIN_KEY, "Uft test converter", true, new HashMap());
        convertTask.getConfiguration().put("framework", "uft");
        convertTask.getConfiguration().put("taskName", "Uft_test_converter");
        tasks.add(convertTask);
        TaskDefinitionImpl executionTask = new TaskDefinitionImpl(2L, EXECUTION_TASK_PLUGIN_KEY, "UFT Executor", true, new HashMap());
        executionTask.getConfiguration().put("testPathInput", "${bamboo.testsToRunConverted}");
        executionTask.getConfiguration().put("publishMode", "RunFromFileSystemTask.publishMode.always");
        executionTask.getConfiguration().put("taskName", "File_System_Execution");
        tasks.add(executionTask);
        buildConfiguration.clearTree("buildTasks");
        TaskConfigurationUtils.addTaskDefinitionsToConfig(tasks, (HierarchicalConfiguration)buildConfiguration, (String)"buildTasks.");
    }

    private void createPollTrigger(PlanKey planKey, long repositoryId) {
        TriggerModuleDescriptor triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(TRIGGER_POLLING_PLUGIN_KEY);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("repository.change.poll.pollingPeriod", "120");
        configuration.put("repository.change.poll.type", "PERIOD");
        configuration.put("repository.change.poll.cronExpression", "0 0 0 ? * *");
        HashMap<String, String> triggerConditionsConfiguration = new HashMap<String, String>();
        triggerConditionsConfiguration.put("custom.triggerrCondition.plansGreen.enabled", "false");
        this.triggerConfigurationService.createTrigger(planKey, triggerDescriptor, "Polling trigger", true, new HashSet<Long>(Arrays.asList(repositoryId)), configuration, triggerConditionsConfiguration);
    }

    private ActionParametersMap configureDefaultStageAndJob(BuildConfiguration buildConfiguration, String buildKey) {
        ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(new HashMap());
        JobParamMapHelper.setBuildKey((ActionParametersMap)actionParametersMap, (String)buildKey);
        JobParamMapHelper.setBuildName((ActionParametersMap)actionParametersMap, (String)"Default Job");
        JobParamMapHelper.setSubBuildKey((ActionParametersMap)actionParametersMap, (String)"JOB1");
        JobParamMapHelper.setStageName((ActionParametersMap)actionParametersMap, (String)"Default Stage");
        JobParamMapHelper.setExistingStage((ActionParametersMap)actionParametersMap, (String)JobCreationConstants.NEW_STAGE_MARKER);
        buildConfiguration.setProperty("inheritRepository", (Object)"true");
        return actionParametersMap;
    }

    private String replaceSpecialCharactersInUrl(String url) {
        return url.trim().replaceAll("[<>:\"/\\|?*{}@&%!;~]", "_");
    }

    private VcsRepositoryData getLinkedRepository(SCMRepository scmRepository, String sharedCredentialsId, BambooUser impersonatedUser) {
        VcsRepositoryData result = null;
        String repositoryName = "UFT_" + this.replaceSpecialCharactersInUrl(scmRepository.getUrl());
        List repositories = this.repositoryDefinitionManager.getLinkedRepositories();
        for (VcsRepositoryData data : repositories) {
            if (!data.getName().equalsIgnoreCase(repositoryName)) continue;
            result = data;
            break;
        }
        if (result == null) {
            Optional<Type> accessOptionParameter;
            PartialVcsRepositoryData vcsRepositoryData = this.createRepositoryData(repositoryName, scmRepository, null, null, sharedCredentialsId);
            Optional<Method> createLinkedRepositoryMethod = Arrays.asList(this.vcsRepositoryConfigurationService.getClass().getDeclaredMethods()).stream().filter(method -> method.getName().equals("createLinkedRepository")).findFirst();
            if (createLinkedRepositoryMethod.isPresent() && (accessOptionParameter = Arrays.asList(createLinkedRepositoryMethod.get().getParameters()).stream().map(parameter -> parameter.getParameterizedType()).filter(type -> type.getTypeName().contains("RepositoryAccess")).findFirst()).isPresent()) {
                PartialVcsRepositoryData temp = null;
                try {
                    Object all_users = Arrays.asList(Class.forName(accessOptionParameter.get().getTypeName()).getEnumConstants()).stream().filter(c -> c.toString().equals(ALL_USERS)).findFirst().get();
                    temp = (PartialVcsRepositoryData)createLinkedRepositoryMethod.get().invoke((Object)this.vcsRepositoryConfigurationService, vcsRepositoryData, impersonatedUser, all_users);
                    result = temp.getCompleteData();
                }
                catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
                    log.error("failed to create linked repository. " + e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PartialVcsRepositoryData createRepositoryData(String repositoryName, SCMRepository scmRepository, String username, String password, String credentialsId) {
        String pluginKey = null;
        HashMap<String, String> serverConfiguration = new HashMap<String, String>();
        CredentialsData selectedCredentials = null;
        if (SdkStringUtils.isNotEmpty(credentialsId) && (selectedCredentials = this.credentialsManager.getCredentials(Long.parseLong(credentialsId))) == null) {
            throw new IllegalArgumentException("Credentials not found for id=" + credentialsId);
        }
        if (scmRepository.getType().equals((Object)SCMType.GIT)) {
            pluginKey = "com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2";
            serverConfiguration.put("repository.git.repositoryUrl", scmRepository.getUrl());
            serverConfiguration.put("repository.git.branch", "master");
            serverConfiguration.put("repository.git.useShallowClones", Boolean.toString(true));
            serverConfiguration.put("repository.git.fetch.whole.repository", Boolean.toString(false));
            if (selectedCredentials != null) {
                if (USERNAME_PASSWORD_PLUGIN_KEY.equals(selectedCredentials.getPluginKey())) {
                    serverConfiguration.put("repository.git.authenticationType", GitAuthenticationType.PASSWORD.name());
                    serverConfiguration.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.SHARED_CREDENTIALS.name());
                    serverConfiguration.put("repository.git.passwordSharedCredentials", credentialsId);
                } else {
                    if (!SSH_CREDENTIALS_PLUGIN_KEY.equals(selectedCredentials.getPluginKey())) throw new UnsupportedOperationException("Plugin doesn't support using of " + this.extractPluginId(selectedCredentials.getPluginKey()) + " for GIT.");
                    serverConfiguration.put("repository.git.authenticationType", GitAuthenticationType.SSH_KEYPAIR.name());
                    serverConfiguration.put("repository.git.sshCredentialsSource", GitPasswordCredentialsSource.SHARED_CREDENTIALS.name());
                    serverConfiguration.put("repository.git.sharedCredentials", credentialsId);
                }
            } else if (SdkStringUtils.isNotEmpty(username)) {
                serverConfiguration.put("repository.git.authenticationType", GitAuthenticationType.PASSWORD.name());
                serverConfiguration.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
                serverConfiguration.put("repository.git.username", username);
                serverConfiguration.put("temporary.git.password", password);
                serverConfiguration.put("temporary.git.password.change", Boolean.toString(true));
            } else {
                serverConfiguration.put("repository.git.authenticationType", GitAuthenticationType.NONE.name());
            }
        } else if (scmRepository.getType().equals((Object)SCMType.SVN)) {
            if (selectedCredentials != null && !USERNAME_PASSWORD_PLUGIN_KEY.equals(selectedCredentials.getPluginKey())) {
                throw new UnsupportedOperationException("Plugin doesn't support using of " + this.extractPluginId(selectedCredentials.getPluginKey()) + " for SVN");
            }
            pluginKey = "com.atlassian.bamboo.plugin.system.repository:svnv2";
            serverConfiguration.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, scmRepository.getUrl());
            serverConfiguration.put(SvnConfigurationConstants.SVN_AUTH_TYPE, AuthenticationType.PASSWORD.getKey());
            serverConfiguration.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, Boolean.toString(true));
            serverConfiguration.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, Boolean.toString(true));
            String myUsername = username;
            String myPassword = password;
            if (SdkStringUtils.isNotEmpty(credentialsId)) {
                CredentialsData cred = this.credentialsManager.getCredentials(Long.parseLong(credentialsId));
                myUsername = (String)cred.getConfiguration().get(CREDENTIALS_USERNAME_FIELD);
                String encryptedPassword = (String)cred.getConfiguration().get(CREDENTIALS_PASSWORD_FIELD);
                try {
                    myPassword = this.encryptionService.decrypt(encryptedPassword);
                }
                catch (Exception e) {
                    myPassword = encryptedPassword;
                }
            }
            serverConfiguration.put(SvnConfigurationConstants.SVN_USERNAME, myUsername);
            serverConfiguration.put(SvnConfigurationConstants.TEMPORARY_SVN_PASSWORD, myPassword);
            serverConfiguration.put(SvnConfigurationConstants.TEMPORARY_SVN_PASSWORD_CHANGE, Boolean.toString(true));
        }
        ActionParametersMapImpl apm = new ActionParametersMapImpl(serverConfiguration);
        VcsRepositoryModuleDescriptor vcsDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(pluginKey);
        PartialVcsRepositoryDataBuilder vcsRepositoryDataBuilder = PartialVcsRepositoryDataBuilder.newBuilder().copyWithEmptyConfig(null).name(repositoryName).description("").pluginKey(pluginKey);
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        HashMap cfgMap = vcsConfigurator.generateConfigMap((ActionParametersMap)apm, null);
        vcsRepositoryDataBuilder.serverConfiguration((Map)cfgMap);
        VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator();
        cfgMap = changeDetectionOptionsConfigurator.generateConfigMap((ActionParametersMap)apm, null);
        vcsRepositoryDataBuilder.changeDetectionConfiguration((Map)cfgMap);
        VcsBranchConfigurator branchConfigurator = vcsDescriptor.getVcsBranchConfigurator();
        cfgMap = new HashMap();
        vcsRepositoryDataBuilder.branchConfiguration(cfgMap);
        vcsRepositoryDataBuilder.vcsBranch(branchConfigurator.getVcsBranchFromConfig(cfgMap));
        return vcsRepositoryDataBuilder.build();
    }

    public String extractPluginId(String pluginKey) {
        int index = pluginKey.lastIndexOf(":");
        if (index > 0) {
            return pluginKey.substring(index + 1);
        }
        return pluginKey;
    }

    private ImmutableChain createExecutorChain(DiscoveryInfo discoveryInfo, BambooUser bambooUser) throws PlanCreationDeniedException {
        VcsRepositoryData linkedRepository = this.getLinkedRepository(discoveryInfo.getScmRepository(), discoveryInfo.getScmRepositoryCredentialsId(), bambooUser);
        String chainKeyStr = this.createChainBuildKey(EXECUTOR_PREFIX_KEY, discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName());
        log.warn("Creating execution plan for test runner " + discoveryInfo.getExecutorId());
        String description = String.format("This plan was created by the Micro Focus plugin for execution of UFT tests. It is associated with ALM Octane test runner #%s.", discoveryInfo.getExecutorId());
        String name = String.format("UFT test executor - Test Runner ID %s (%s)", discoveryInfo.getExecutorId(), discoveryInfo.getExecutorLogicalName());
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        String chainBuildKeyStr = this.createChain(this.getMainProject(), linkedRepository, chainKeyStr, description, name, buildConfiguration);
        ActionParametersMap actionParametersMap = this.configureDefaultStageAndJob(buildConfiguration, chainBuildKeyStr);
        this.configureExecutionTask(buildConfiguration);
        this.jobCreationService.createJobAndBranches(buildConfiguration, actionParametersMap, PlanCreationService.EnablePlan.ENABLED);
        PlanKey chainKey = PlanKeys.getPlanKey((String)chainBuildKeyStr);
        Chain createdChain = (Chain)this.planManager.getPlanByKeyIfOfType(chainKey, Chain.class);
        this.createVariablesForExecution(createdChain);
        Job job = (Job)((ChainStage)createdChain.getAllStages().get(0)).getJobs().iterator().next();
        this.registerArtifactForExecution(job);
        this.createRequirementsForExecution(job.getPlanKey());
        this.chainCreationService.triggerCreationCompleteEvents(chainKey);
        String fullPlanKeyStr = "UOI-" + chainKeyStr;
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)fullPlanKeyStr), ImmutableChain.class);
        return chain;
    }

    private void createRequirementsForExecution(PlanKey jobKey) {
        try {
            this.requirementService.addRequirement(jobKey, "system.builder.Micro Focus.Unified Functional Testing", ImmutableRequirement.MatchType.EXISTS, ".*");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to createRequirementsForExecution : " + e.getMessage());
        }
    }

    private String createChain(Project project, VcsRepositoryData linkedRepository, String chainKey, String chainDescription, String chainName, BuildConfiguration buildConfiguration) throws PlanCreationDeniedException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("existingProjectKey", project.getKey());
        context.put("chainKey", chainKey);
        context.put("chainName", chainName);
        context.put("chainDescription", chainDescription);
        context.put("linkedRepositoryAccessOption", ALL_USERS);
        context.put("repositoryTypeOption", "LINKED");
        context.put("selectedRepository", linkedRepository.getId());
        ActionParametersMapImpl apm = new ActionParametersMapImpl(context);
        BuildConfigurationActionHelper.copyParamsToBuildConfiguration((ActionParametersMap)apm, (BuildConfiguration)buildConfiguration);
        return this.chainCreationService.createPlan(buildConfiguration, (ActionParametersMap)apm, PlanCreationService.EnablePlan.ENABLED);
    }

    private String createChainBuildKey(String prefix, String executorId, String executorLogicalName) {
        return String.format("%s%sLOGICAL%s", prefix, executorId, executorLogicalName).toUpperCase();
    }

    private boolean registerArtifactForDiscovery(@NotNull Job job) {
        String name = "UFT discovery result";
        String pattern = "**/uft_discovery_result_build_${bamboo.buildNumber}*";
        return ArtifactsHelper.registerArtifactDefinition(job, name, pattern);
    }

    private boolean registerArtifactForExecution(@NotNull Job job) {
        String name = "Micro Focus Tasks Artifact Definition";
        String pattern = "UFT_Build_${bamboo.buildNumber}/**";
        return ArtifactsHelper.registerArtifactDefinition(job, name, pattern);
    }

    private void createVariablesForExecution(@NotNull Chain chain) {
        this.createVariables(chain, "testsToRun", "");
    }

    private void createVariables(@NotNull Chain chain, String key, @NotNull String value) {
        try {
            this.variableConfigurationService.createPlanVariable((Plan)chain, key, value);
        }
        catch (Exception e) {
            log.warn(String.format("Failed to add variable <%s> to chain <%s>", key, chain.getName()));
        }
    }

    public PipelineNode createExecutor(DiscoveryInfo discoveryInfo, String runAsUser) {
        BambooUser user = this.bambooUserManager.getBambooUser(runAsUser);
        try {
            ImmutableChain chain = this.createExecutorChain(discoveryInfo, user);
            return DefaultOctaneConverter.getInstance().getRootPipelineNodeFromTopLevelPlan((ImmutableTopLevelPlan)chain);
        }
        catch (Exception e) {
            String msg = "Failed to createExecutor : " + e.getMessage();
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
    }
}

