/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.gherkin;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.utils.SystemProperty;
import com.hp.octane.integrations.testresults.GherkinUtils;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class ALMOctaneCucumberTestReporterUtils {
    public static final String GHERKIN_NGA_RESULTS = "OctaneGherkinResults";
    public static final String DEFAULT_GLOB = "**/*OctaneGherkinResults.xml";

    public static void aggregateGherkinFilesToMqmResultFile(String targetDirectoryPath, String planName, int buildNumber, BuildLogger buildLogger) throws Exception {
        List<File> gherkinFiles = GherkinUtils.findGherkinFilesByTemplateWithCounter(targetDirectoryPath, "OctaneGherkinResults%s.xml", 0);
        File mqmFile = new File(targetDirectoryPath, "mqmTests.xml");
        ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Creating mqm test result file : " + mqmFile.getAbsolutePath());
        GherkinUtils.aggregateGherkinFilesToMqmResultFile(gherkinFiles, mqmFile, planName, Integer.toString(buildNumber), DefaultOctaneConverter.getDTOFactory());
    }

    private static String generateGherkinResultFileName(int index, String targetDirectoryPath) {
        return targetDirectoryPath + File.separator + GHERKIN_NGA_RESULTS + index + ".xml";
    }

    private static void addLogEntry(BuildLogger buildLogger, String message) {
        buildLogger.addBuildLogEntry("Micro Focus ALM Octane Cucumber test reporter: " + message);
    }

    public static void copyTestResults(String targetDirectoryPath, String workingDirectoryPath, String userPattern, final BuildLogger buildLogger, final Date taskStartDate) throws IOException {
        ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Collecting results");
        Path startDir = Paths.get(workingDirectoryPath, new String[0]);
        FileSystem fs = FileSystems.getDefault();
        if (StringUtils.isEmpty((String)userPattern)) {
            userPattern = DEFAULT_GLOB;
            ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Cucumber report XMLs configuration is empty. Using default pattern : **/*OctaneGherkinResults.xml");
        }
        userPattern = "{" + userPattern + "}";
        final PathMatcher matcher = fs.getPathMatcher("glob:" + userPattern);
        final PathMatcher exclude = fs.getPathMatcher("glob:**/ALM_Octane_Test_Results/**");
        final ArrayList finalCollection = new ArrayList();
        SimpleFileVisitor<Path> matcherVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attribs) {
                if (matcher.matches(file.toAbsolutePath()) && !exclude.matches(file.toAbsolutePath())) {
                    File tempFile = file.toFile();
                    boolean isFileRecentEnough = this.isFileRecentEnough(tempFile);
                    if (!isFileRecentEnough) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        String msg = String.format("File %s was ignored because it was modified (%s) before task started (%s)", file, dateFormat.format(new Date(tempFile.lastModified())), dateFormat.format(taskStartDate));
                        ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, msg);
                    } else {
                        finalCollection.add(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isFileRecentEnough(File file) {
                return file.lastModified() >= taskStartDate.getTime() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue();
            }
        };
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)matcherVisitor);
        ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Search for result files that match the pattern '" + userPattern + "'. Found " + finalCollection.size() + " files.");
        int i = 0;
        ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Copy result files to " + targetDirectoryPath);
        for (Path file : finalCollection) {
            File newGherkinTestResultsFile = new File(ALMOctaneCucumberTestReporterUtils.generateGherkinResultFileName(i++, targetDirectoryPath));
            ALMOctaneCucumberTestReporterUtils.addLogEntry(buildLogger, "Copying " + file.getFileName() + " to " + newGherkinTestResultsFile.getName());
            FileUtils.copyFile((File)file.toFile(), (File)newGherkinTestResultsFile);
        }
    }
}

