/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.executor;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.hp.octane.integrations.executor.TestsToRunConverterResult;
import com.hp.octane.integrations.executor.TestsToRunConvertersFactory;
import com.hp.octane.integrations.executor.TestsToRunFramework;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TestFrameworkConverterTask
implements TaskType {
    private String framework;
    private String format;
    public static final String FRAMEWORK_PARAMETER = "framework";
    public static final String CONVERTER_FORMAT = "customConverterFormat";
    private static final String TESTS_TO_RUN_CONVERTED_PARAMETER = "testsToRunConverted";
    public static final String DEFAULT_EXECUTING_DIRECTORY = "${bamboo.build.working.directory}";
    private static final String CHECKOUT_DIRECTORY_PARAMETER = "testsToRunCheckoutDirectory";

    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        boolean skip = false;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        Map variables = taskContext.getBuildContext().getVariableContext().getEffectiveVariables();
        String rawTests = this.getTestsToRunValue(variables);
        String checkoutDirectory = DEFAULT_EXECUTING_DIRECTORY;
        if (StringUtils.isNotEmpty((String)rawTests)) {
            String checkoutDir;
            TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRun found with value : " + rawTests);
            String string = checkoutDir = variables.containsKey(CHECKOUT_DIRECTORY_PARAMETER) ? ((VariableDefinitionContext)variables.get(CHECKOUT_DIRECTORY_PARAMETER)).getValue() : null;
            if (StringUtils.isEmpty(checkoutDir)) {
                checkoutDir = DEFAULT_EXECUTING_DIRECTORY;
                TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRunCheckoutDirectory is not defined, using default value : " + checkoutDir);
            } else {
                TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRunCheckoutDirectory parameter found with value : " + checkoutDirectory);
            }
        } else {
            skip = true;
            TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRun is not defined or has empty value. Skipping.");
        }
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.framework = (String)configurationMap.get((Object)FRAMEWORK_PARAMETER);
        if (StringUtils.isEmpty((String)this.framework)) {
            TestFrameworkConverterTask.addLogEntry(buildLogger, "No framework is selected. Skipping.");
            skip = true;
        }
        if (!skip) {
            this.format = (String)configurationMap.get((Object)CONVERTER_FORMAT);
            TestsToRunFramework testsToRunFramework = TestsToRunFramework.fromValue(this.framework);
            TestFrameworkConverterTask.addLogEntry(buildLogger, "framework : " + this.framework);
            if (this.framework.equals("custom")) {
                TestFrameworkConverterTask.addLogEntry(buildLogger, "format : " + this.format);
            }
            TestsToRunConverterResult convertResult = TestsToRunConvertersFactory.createConverter(testsToRunFramework).setFormat(this.format).convert(rawTests, checkoutDirectory, null);
            TestFrameworkConverterTask.addLogEntry(buildLogger, "Found #tests : " + convertResult.getTestsData().size());
            TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRunConverted = " + convertResult.getConvertedTestsString());
            TestFrameworkConverterTask.addLogEntry(buildLogger, "testsToRunConverted length = " + convertResult.getConvertedTestsString().length());
            String testToRunConverted = convertResult.getConvertedTestsString();
            if (convertResult.getConvertedTestsString().length() >= 3900) {
                if (testsToRunFramework.equals(TestsToRunFramework.MF_UFT)) {
                    File converterResultFile = TestFrameworkConverterTask.saveUftTestsToMtbxFile(taskContext, buildLogger, convertResult);
                    testToRunConverted = converterResultFile.getAbsolutePath();
                } else {
                    String msg = String.format("Conversion value is too long (%s characters) for Bamboo. Check possibility to reduce number of tests for execution. Max allowed value is %s.", convertResult.getConvertedTestsString().length(), 3900);
                    buildLogger.addBuildLogEntry(msg);
                    throw new TaskException(msg);
                }
            }
            taskContext.getBuildContext().getVariableContext().addResultVariable(TESTS_TO_RUN_CONVERTED_PARAMETER, testToRunConverted);
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    @NotNull
    private String getTestsToRunValue(Map<String, VariableDefinitionContext> variables) {
        StringBuilder rawTestsStringBuilder = new StringBuilder();
        if (variables.containsKey("test-to-run-split-count")) {
            int splitCount = Integer.parseInt(variables.get("test-to-run-split-count").getValue());
            for (int i = 0; i < splitCount; ++i) {
                rawTestsStringBuilder.append(variables.containsKey("testsToRun" + i) ? variables.get("testsToRun" + i).getValue() : "");
            }
        } else {
            rawTestsStringBuilder.append(variables.containsKey("testsToRun") ? variables.get("testsToRun").getValue() : "");
        }
        return rawTestsStringBuilder.toString();
    }

    private static void addLogEntry(BuildLogger buildLogger, String message) {
        buildLogger.addBuildLogEntry("octaneTestFrameworkConverter: " + message);
    }

    private static File saveUftTestsToMtbxFile(@NotNull TaskContext taskContext, BuildLogger buildLogger, TestsToRunConverterResult convertResult) throws TaskException {
        File converterResultFile = new File(taskContext.getWorkingDirectory(), "Uft_Build_" + taskContext.getBuildContext().getBuildNumber() + ".mtbx");
        try {
            FileOutputStream fop = new FileOutputStream(converterResultFile);
            byte[] contentInBytes = convertResult.getConvertedTestsString().replace(DEFAULT_EXECUTING_DIRECTORY, taskContext.getWorkingDirectory().getAbsolutePath()).getBytes(StandardCharsets.UTF_8);
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
            buildLogger.addBuildLogEntry("MTBX file is saved in " + converterResultFile.getAbsolutePath());
            return converterResultFile;
        }
        catch (IOException e) {
            String msg = String.format("Failed to save MTBX file  " + converterResultFile.getAbsolutePath() + " : " + e.getMessage(), new Object[0]);
            buildLogger.addBuildLogEntry(msg);
            throw new TaskException(msg, (Throwable)e);
        }
    }
}

