/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.executor;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.hp.octane.integrations.executor.TestsToRunFramework;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TestFrameworkConverterConfigurator
extends AbstractTaskConfigurator {
    private static String SUPPORTED_FRAMEWORKS = "supportedFrameworks";

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("framework", taskDefinition.getConfiguration().get("framework"));
        context.put("customConverterFormat", taskDefinition.getConfiguration().get("customConverterFormat"));
        this.populateContextForLists(context);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("framework", "");
        context.put("customConverterFormat", "");
        this.populateContextForLists(context);
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("framework", params.getString("framework"));
        config.put("customConverterFormat", params.getString("customConverterFormat"));
        return config;
    }

    private void populateContextForLists(Map<String, Object> context) {
        context.put(SUPPORTED_FRAMEWORKS, this.getSupportedFrameworks());
    }

    private Object getSupportedFrameworks() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TestsToRunFramework fr : TestsToRunFramework.values()) {
            map.put(fr.value(), fr.getDesc());
        }
        return map;
    }
}

