/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameterType;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParametersHelper {
    public static final String SUITE_ID_PARAMETER = "suiteId";
    public static final String SUITE_RUN_ID_PARAMETER = "suiteRunId";
    public static final String TESTS_TO_RUN_PARAMETER = "testsToRun";
    private static List<String> encryptedVariable = Arrays.asList("password", "sshkey", "passphrase", "secret");

    public static void addParametersToEvent(CIEvent ciEvent, BuildContext buildContext) {
        try {
            Map variables = buildContext.getVariableContext().getEffectiveVariables();
            ArrayList<CIParameter> parameters = new ArrayList<CIParameter>();
            variables.entrySet().forEach(v -> {
                if (!ParametersHelper.isEncrypted((VariableDefinitionContext)v.getValue())) {
                    parameters.add(DefaultOctaneConverter.getDTOFactory().newDTO(CIParameter.class).setName((String)v.getKey()).setValue(((VariableDefinitionContext)v.getValue()).getValue()).setType(CIParameterType.STRING));
                }
            });
            if (parameters != null && !parameters.isEmpty()) {
                ciEvent.setParameters(parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isEncrypted(VariableDefinitionContext variable) {
        String variableName = variable.getKey().toLowerCase();
        for (String val : encryptedVariable) {
            if (!variableName.contains(val)) continue;
            return true;
        }
        return false;
    }
}

