/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.events.PostBuildCompletedEvent;
import com.atlassian.sal.api.component.ComponentLocator;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.uft.UftTestDispatchUtils;
import com.hp.octane.integrations.uft.items.JobRunContext;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.plugins.bamboo.listener.BaseListener;
import com.hp.octane.plugins.bamboo.listener.MultibranchHelper;
import com.hp.octane.plugins.bamboo.listener.ParametersHelper;
import com.hp.octane.plugins.bamboo.octane.ArtifactsHelper;
import com.hp.octane.plugins.bamboo.octane.MqmResultsHelper;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class OctanePostChainAction
extends BaseListener
implements PostChainAction {
    private static final Logger LOG = SDKBasedLoggerProvider.getLogger(OctanePostChainAction.class);
    private static Set<String> testResultExpected = new HashSet<String>();
    private static final String TEST_RESULT_PUBLISHER_TASK = "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octanetestresultpublisher";
    private static final String CUCUMBER_TEST_RESULT_PUBLISHER_TASK = "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octanecucumber";
    private static final Set<String> octaneResultReporterTask = new HashSet<String>(Arrays.asList("com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octanetestresultpublisher", "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin:octanecucumber"));
    private static final String DISCOVERY_JOB_ARTIFACT_NAME = "UFT discovery result";

    public static void onJobCompleted(PostBuildCompletedEvent event) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        PlanKey planKey = event.getPlanKey();
        PlanResultKey planResultKey = event.getPlanResultKey();
        ArtifactContext artifactContext = event.getContext().getArtifactContext();
        boolean hasTestResultsArtifact = artifactContext.getPublishingResults().stream().anyMatch(r -> r.getArtifactDefinitionContext().getName().equals("ALM Octane test results"));
        boolean hasDefinedOctanePublisherTask = event.getContext().getRuntimeTaskDefinitions().stream().anyMatch(task -> octaneResultReporterTask.contains(task.getPluginKey().toLowerCase()));
        CurrentBuildResult results = event.getContext().getBuildResult();
        boolean hasTests = hasTestResultsArtifact && hasDefinedOctanePublisherTask || results.getFailedTestResults() != null && !results.getFailedTestResults().isEmpty() || results.getSkippedTestResults() != null && !results.getSkippedTestResults().isEmpty() || results.getSuccessfulTestResults() != null && !results.getSuccessfulTestResults().isEmpty();
        LOG.info(planResultKey.toString() + " : onJobCompleted, hasTests = " + hasTests);
        CIEventCause parentReason = CONVERTER.getCause(event.getContext().getTriggerReason());
        String parentId = event.getContext().getParentBuildContext().getPlanResultKey().getPlanKey().getKey();
        CIEventCause cause = CONVERTER.getUpstreamCause(event.getContext().getParentBuildIdentifier().getPlanResultKey().getKey(), parentId, parentReason);
        CIEvent ciEvent = CONVERTER.getEventWithDetails(planResultKey.getPlanKey().getKey(), planResultKey.getKey(), event.getContext().getShortName(), CIEventType.FINISHED, event.getContext().getCurrentResult().getTasksStartDate().getTime(), 100L, Arrays.asList(cause), String.valueOf(planResultKey.getBuildNumber()), event.getContext().getCurrentResult().getBuildState(), event.getTimestamp() - event.getContext().getCurrentResult().getTasksStartDate().getTime(), PhaseType.INTERNAL);
        ciEvent.setTestResultExpected(hasTests);
        MultibranchHelper.enrichMultiBranchEventForJob(event.getContext(), ciEvent);
        ParametersHelper.addParametersToEvent(ciEvent, event.getContext());
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(ciEvent));
        if (hasTests) {
            try {
                OctanePostChainAction.saveJobTestResults(event, hasTestResultsArtifact && hasDefinedOctanePublisherTask);
            }
            catch (Exception e) {
                LOG.error("Failed to saveJobTestResults : " + e.getMessage());
            }
            testResultExpected.add(event.getContext().getParentBuildContext().getPlanResultKey().getKey());
            OctaneSDK.getClients().forEach(client -> client.getTestsService().enqueuePushTestsResult(planKey.getKey(), planResultKey.getKey(), parentId));
        }
        OctanePostChainAction.handleDiscoveryResults(event);
    }

    private static void handleDiscoveryResults(PostBuildCompletedEvent event) {
        String discoveryHasClients = (String)event.getContext().getBuildResult().getCustomBuildData().get("uftDiscoveryHasClients");
        boolean hasDiscoveryTask = event.getContext().getArtifactContext().getPublishingResults().stream().anyMatch(r -> r.getArtifactDefinitionContext().getName().equals(DISCOVERY_JOB_ARTIFACT_NAME));
        try {
            if (hasDiscoveryTask && StringUtils.isNoneEmpty(discoveryHasClients) && "false".equals(discoveryHasClients)) {
                PlanResultKey planResultKey = event.getPlanResultKey();
                ResultsSummaryManager resultsSummaryManager = (ResultsSummaryManager)ComponentLocator.getComponent(ResultsSummaryManager.class);
                ResultsSummary rs = resultsSummaryManager.getResultsSummary(planResultKey);
                ArtifactLinkManager artifactLinkManager = (ArtifactLinkManager)ComponentLocator.getComponent(ArtifactLinkManager.class);
                Collection links = artifactLinkManager.getArtifactLinks(rs, null);
                ArtifactLink link = links.stream().filter(l -> l.getArtifact().getLabel().equals(DISCOVERY_JOB_ARTIFACT_NAME)).findFirst().orElse(null);
                if (link != null) {
                    LOG.info(planResultKey + " : Generating discovery from artifacts. ");
                    UftTestDiscoveryResult result = ArtifactsHelper.getTestDiscovery(link.getArtifact(), planResultKey);
                    if (result != null) {
                        LOG.info("DISCOVERY RESULTS = " + result);
                        OctaneSDK.getClientByInstanceId(result.getConfigurationId()).getConfigurationService().validateConfigurationAndGetConnectivityStatus();
                        EntitiesService entitiesService = OctaneSDK.getClientByInstanceId(result.getConfigurationId()).getEntitiesService();
                        UftTestDispatchUtils.prepareDiscoveryResultForDispatch(entitiesService, result);
                        JobRunContext jobRunContext = new JobRunContext(event.getContext().getProjectName(), event.getContext().getBuildNumber());
                        UftTestDispatchUtils.dispatchDiscoveryResult(entitiesService, result, jobRunContext, LOG::info);
                        File discoveryResultsFolder = new File(MqmResultsHelper.getBuildResultDirectory(planResultKey.getPlanKey()), "_discovery_results");
                        if (!discoveryResultsFolder.exists()) {
                            discoveryResultsFolder.mkdir();
                        }
                        File reportXmlFile = new File(discoveryResultsFolder, "uft_discovery_result_build_" + event.getContext().getBuildNumber() + ".xml");
                        try {
                            result.writeToFile(reportXmlFile);
                            LOG.info("Final result file is saved in {}", (Object)reportXmlFile.getAbsolutePath());
                        }
                        catch (IOException e) {
                            LOG.info(String.format("Failed to save final result file {} : {}", reportXmlFile.getAbsolutePath(), e.getMessage()));
                        }
                    } else {
                        LOG.info("Failed to get discovery results {} - {}", (Object)link.getArtifact().getLabel(), (Object)link.getArtifact());
                    }
                } else {
                    new RuntimeException("ALM Octane test results artifact is not found");
                }
            } else if ("false".equals(discoveryHasClients)) {
                LOG.info("Discovery task don't have client and no discovery exist= " + event.getContext().getArtifactContext().getPublishingResults().stream().map(art -> art.getArtifactDefinitionContext().getName()).collect(Collectors.joining(",")));
            }
        }
        catch (IOException ioe) {
            LOG.error("Failed to get Discovery artifact = " + ioe);
        }
        OctanePostChainAction.enqueueBuildLog(event.getPlanResultKey().getPlanKey().getKey(), event.getPlanResultKey().getKey(), OctanePostChainAction.getRootJob(event.getContext()));
    }

    private static String getRootJob(BuildContext buildContext) {
        if (buildContext.getParentBuildContext() == null) {
            return buildContext.getPlanResultKey().getPlanKey().getKey();
        }
        return OctanePostChainAction.getRootJob(buildContext.getParentBuildContext());
    }

    private static void saveJobTestResults(PostBuildCompletedEvent event, boolean hasTestResultsArtifact) {
        PlanResultKey planResultKey = event.getPlanResultKey();
        if (hasTestResultsArtifact) {
            LOG.info(planResultKey.toString() + " : test result artifact found - " + "ALM Octane test results");
            ResultsSummaryManager resultsSummaryManager = (ResultsSummaryManager)ComponentLocator.getComponent(ResultsSummaryManager.class);
            ResultsSummary rs = resultsSummaryManager.getResultsSummary(planResultKey);
            ArtifactLinkManager artifactLinkManager = (ArtifactLinkManager)ComponentLocator.getComponent(ArtifactLinkManager.class);
            Collection links = artifactLinkManager.getArtifactLinks(rs, null);
            ArtifactLink link = links.stream().filter(l -> l.getArtifact().getLabel().equals("ALM Octane test results")).findFirst().orElse(null);
            if (link != null) {
                File buildResultDirectory = new File(MqmResultsHelper.getBuildResultDirectory(planResultKey.getPlanKey()), "ALM_Octane_Test_Results");
                LOG.info(planResultKey + " : Generating test result from artifacts. Copy artifacts to " + buildResultDirectory.getAbsolutePath());
                ArtifactsHelper.copyArtifactTo(buildResultDirectory, link.getArtifact());
            } else {
                new RuntimeException("ALM Octane test results artifact is not found");
            }
        } else {
            LOG.info(planResultKey.toString() + " : Generating test result from context");
            InputStream is = MqmResultsHelper.generateTestResultStream(event.getContext(), planResultKey.getKey(), Integer.toString(planResultKey.getBuildNumber()));
            Path targetFilePath = MqmResultsHelper.getMqmResultFilePath(planResultKey);
            MqmResultsHelper.saveStreamToFile(is, planResultKey, targetFilePath);
        }
        File testResultFile = MqmResultsHelper.getMqmResultFilePath(planResultKey).toFile();
        boolean testResultFileExist = testResultFile.exists();
        LOG.info(planResultKey + " : test result file created=" + testResultFileExist + ". Path is " + testResultFile);
    }

    public void execute(Chain chain, ChainResultsSummary chainResultsSummary, ChainExecution chainExecution) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        LOG.info("Chain " + chainExecution.getBuildIdentifier().getPlanResultKey() + " completed with result " + chainResultsSummary.getBuildState().toString());
        CIEvent ciEvent = CONVERTER.getEventWithDetails(chain.getPlanKey().getKey(), chainExecution.getBuildIdentifier().getPlanResultKey().getKey(), chain.getName(), CIEventType.FINISHED, chainExecution.getStartTime() != null ? chainExecution.getStartTime().getTime() : chainExecution.getQueueTime().getTime(), chainResultsSummary.getDuration(), Collections.singletonList(CONVERTER.getCause(chainExecution.getTriggerReason())), String.valueOf(chainExecution.getBuildIdentifier().getBuildNumber()), chainResultsSummary.getBuildState(), chainResultsSummary.getProcessingDuration(), PhaseType.INTERNAL);
        if (chainExecution.isStopRequested()) {
            ciEvent.setResult(CIBuildResult.ABORTED);
        }
        String key = chainExecution.getPlanResultKey().getKey();
        ciEvent.setTestResultExpected(testResultExpected.contains(key));
        testResultExpected.remove(key);
        MultibranchHelper.enrichMultiBranchEvent((ImmutableChain)chain, ciEvent);
        BuildContext buildContext = (BuildContext)chainExecution.getBuildIdentifier();
        ParametersHelper.addParametersToEvent(ciEvent, buildContext);
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(ciEvent));
        String buildCiId = PlanKeys.getPlanResultKey((PlanKey)chain.getPlanKey(), (int)chainExecution.getBuildIdentifier().getBuildNumber()).getKey();
        OctanePostChainAction.enqueueBuildLog(chain.getPlanKey().getKey(), buildCiId, chain.getPlanKey().getKey());
    }

    private static void enqueueBuildLog(String jobCiId, String buildCiId, String parents) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        try {
            LOG.info("enqueued build '" + jobCiId + " #" + buildCiId + "' for log submission");
            OctaneSDK.getClients().forEach(octaneClient -> octaneClient.getLogsService().enqueuePushBuildLog(jobCiId, buildCiId, parents));
        }
        catch (IllegalArgumentException iae) {
            LOG.error(iae.getMessage());
        }
        catch (Exception t) {
            LOG.error("failed to enqueue " + jobCiId + " for logs push to Octane", (Throwable)t);
        }
    }
}

