/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.MultiBranchType;
import com.hp.octane.plugins.bamboo.listener.BaseListener;
import com.hp.octane.plugins.bamboo.listener.OctanePostChainAction;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import org.apache.logging.log4j.Logger;

public class MultibranchHelper {
    private static CachedPlanManager cachedPlanManager;
    private static PlanManager planManager;
    protected static final Logger log;

    private static CachedPlanManager getCachedPlanManager() {
        if (cachedPlanManager == null) {
            cachedPlanManager = (CachedPlanManager)ComponentLocator.getComponent(CachedPlanManager.class);
        }
        return cachedPlanManager;
    }

    private static PlanManager getPlanManager() {
        if (planManager == null) {
            planManager = (PlanManager)ComponentLocator.getComponent(PlanManager.class);
        }
        return planManager;
    }

    public static void enrichMultiBranchEventForJob(BuildContext buildContext, CIEvent ciEvent) {
        try {
            boolean isMultiBranchChild;
            PlanKey parentKey = buildContext.getParentBuildContext().getPlanResultKey().getPlanKey();
            ImmutablePlan plan = MultibranchHelper.getCachedPlanManager().getPlanByKey(parentKey);
            boolean bl = isMultiBranchChild = plan != null && plan instanceof ImmutableChainBranch;
            if (isMultiBranchChild) {
                ciEvent.setSkipValidation(true);
            }
        }
        catch (Exception e) {
            log.error("Failed to enrichMultiBranchEventForJob : " + e.getMessage());
        }
    }

    public static void enrichMultiBranchEvent(ImmutableChain chain, CIEvent ciEvent) {
        if (chain instanceof ImmutableChainBranch) {
            ciEvent.setParentCiId(chain.getMaster().getPlanKey().toString()).setMultiBranchType(MultiBranchType.MULTI_BRANCH_CHILD).setSkipValidation(true);
        }
    }

    public static void onChainDeleted(PlanKey planKey) {
        Plan plan = MultibranchHelper.getPlanManager().getPlanByKey(planKey);
        if (plan instanceof ImmutableChainBranch) {
            CIEvent cievent = BaseListener.CONVERTER.getEventWithDetails(planKey.toString(), CIEventType.DELETED);
            OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(cievent));
        }
    }

    static {
        log = SDKBasedLoggerProvider.getLogger(OctanePostChainAction.class);
    }
}

