/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.admin;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class AdminServlet
extends HttpServlet {
    @ComponentImport
    private final TemplateRenderer renderer;

    @Inject
    public AdminServlet(TemplateRenderer renderer) {
        this.renderer = renderer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserManager userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        UserProfile username = userManager.getRemoteUser(request);
        if (username == null || !userManager.isSystemAdmin(username.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/admin.vm", (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LoginUriProvider loginUriProvider = (LoginUriProvider)ComponentLocator.getComponent(LoginUriProvider.class);
        response.sendRedirect(loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

