/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.uft.DiscoveryResultDispatcher;
import com.hp.octane.integrations.uft.DiscoveryResultPreparer;
import com.hp.octane.integrations.uft.MbtDiscoveryResultDispatcherImpl;
import com.hp.octane.integrations.uft.MbtDiscoveryResultPreparerImpl;
import com.hp.octane.integrations.uft.UftDiscoveryResultDispatcherImpl;
import com.hp.octane.integrations.uft.UftDiscoveryResultPreparerImpl;
import com.hp.octane.integrations.uft.items.CustomLogger;
import com.hp.octane.integrations.uft.items.JobRunContext;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UftTestDispatchUtils {
    private static final Logger logger = LogManager.getLogger(UftTestDispatchUtils.class);
    private static Map<TestingToolType, DiscoveryResultPreparer> preparersMap = new HashMap<TestingToolType, DiscoveryResultPreparer>();
    private static Map<TestingToolType, DiscoveryResultDispatcher> dispatchersMap = new HashMap<TestingToolType, DiscoveryResultDispatcher>();

    public static void prepareDiscoveryResultForDispatch(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        logger.info("Prepare discovery results before dispatching for: {}, full sync: {} ", (Object)discoveryResult.getTestingToolType(), (Object)discoveryResult.isFullScan());
        if (discoveryResult.isFullScan()) {
            UftTestDispatchUtils.getDiscoveryResultPreparer(discoveryResult.getTestingToolType()).prepareDiscoveryResultForDispatchInFullSyncMode(entitiesService, discoveryResult);
        } else {
            UftTestDispatchUtils.getDiscoveryResultPreparer(discoveryResult.getTestingToolType()).prepareDiscoveryResultForDispatchInScmChangesMode(entitiesService, discoveryResult);
        }
    }

    public static void dispatchDiscoveryResult(EntitiesService entitiesService, UftTestDiscoveryResult result, JobRunContext jobRunContext, CustomLogger customLogger) {
        UftTestDispatchUtils.getDiscoveryResultDispatcher(result.getTestingToolType()).dispatchDiscoveryResults(entitiesService, result, jobRunContext, customLogger);
    }

    private static DiscoveryResultPreparer getDiscoveryResultPreparer(TestingToolType testingToolType) {
        return preparersMap.get((Object)testingToolType);
    }

    private static DiscoveryResultDispatcher getDiscoveryResultDispatcher(TestingToolType testingToolType) {
        return dispatchersMap.get((Object)testingToolType);
    }

    static {
        preparersMap.put(TestingToolType.UFT, new UftDiscoveryResultPreparerImpl());
        preparersMap.put(TestingToolType.MBT, new MbtDiscoveryResultPreparerImpl());
        dispatchersMap.put(TestingToolType.UFT, new UftDiscoveryResultDispatcherImpl());
        dispatchersMap.put(TestingToolType.MBT, new MbtDiscoveryResultDispatcherImpl());
    }
}

