/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.entities.EntityList;
import com.hp.octane.integrations.dto.entities.OctaneRestExceptionData;
import com.hp.octane.integrations.exceptions.OctaneBulkException;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.uft.DiscoveryResultDispatcher;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.CustomLogger;
import com.hp.octane.integrations.uft.items.JobRunContext;
import com.hp.octane.integrations.uft.items.ScmResourceFile;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.uft.items.UftTestType;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UftDiscoveryResultDispatcherImpl
extends DiscoveryResultDispatcher {
    private static final Logger logger = LogManager.getLogger(UftDiscoveryResultDispatcherImpl.class);
    private static final int POST_BULK_SIZE = 100;

    @Override
    public void dispatchDiscoveryResults(EntitiesService entitiesService, UftTestDiscoveryResult result, JobRunContext jobRunContext, CustomLogger customLogger) {
        String msg;
        List<ScmResourceFile> resources;
        boolean updated;
        String msg2;
        List<AutomatedTest> tests;
        if (SdkStringUtils.isNotEmpty(result.getTestRunnerId()) && !this.checkExecutorExistInOctane(entitiesService, result)) {
            String msg3 = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : executor " + result.getTestRunnerId() + " is not exist. Tests are not sent.";
            this.logMessage(logger, Level.WARN, customLogger, msg3);
        }
        if (!(tests = result.getNewTests()).isEmpty()) {
            boolean posted = this.postTests(entitiesService, tests, result.getWorkspaceId(), result.getScmRepositoryId(), result.getTestRunnerId());
            msg2 = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + tests.size() + "  new tests posted successfully = " + posted;
            this.logMessage(logger, Level.INFO, customLogger, msg2);
        }
        if (!(tests = result.getUpdatedTests()).isEmpty()) {
            updated = this.updateTests(entitiesService, tests, result.getWorkspaceId(), result.getScmRepositoryId(), result.getTestRunnerId());
            msg2 = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + tests.size() + "  updated tests posted successfully = " + updated;
            this.logMessage(logger, Level.INFO, customLogger, msg2);
        }
        if (!(tests = result.getDeletedTests()).isEmpty()) {
            updated = this.updateTests(entitiesService, tests, result.getWorkspaceId(), result.getScmRepositoryId(), null);
            msg2 = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + tests.size() + "  deleted tests set as not executable successfully = " + updated;
            this.logMessage(logger, Level.INFO, customLogger, msg2);
        }
        if (!(resources = result.getNewScmResourceFiles()).isEmpty()) {
            boolean posted = this.postScmResources(entitiesService, resources, result.getWorkspaceId(), result.getScmRepositoryId());
            msg = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + resources.size() + "  new scmResources posted successfully = " + posted;
            this.logMessage(logger, Level.INFO, customLogger, msg);
        }
        if (!(resources = result.getUpdatedScmResourceFiles()).isEmpty()) {
            boolean posted = this.updateScmResources(entitiesService, resources, result.getWorkspaceId());
            msg = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + resources.size() + "  updated scmResources posted successfully = " + posted;
            this.logMessage(logger, Level.INFO, customLogger, msg);
        }
        if (!(resources = result.getDeletedScmResourceFiles()).isEmpty()) {
            boolean posted = this.deleteScmResources(entitiesService, resources, result.getWorkspaceId());
            msg = "Persistence [" + jobRunContext.getProjectName() + "#" + jobRunContext.getBuildNumber() + "] : " + resources.size() + "  scmResources deleted successfully = " + posted;
            this.logMessage(logger, Level.INFO, customLogger, msg);
        }
    }

    private boolean postTests(EntitiesService entitiesService, List<AutomatedTest> tests, String workspaceId, String scmRepositoryId, String testRunnerId) {
        if (!tests.isEmpty()) {
            ArrayList<Entity> testsForPost = new ArrayList<Entity>(tests.size());
            Entity uftTestingTool = UftDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.testing_tool_type.uft");
            Entity uftFramework = UftDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.je.framework.uft");
            Entity guiTestType = UftDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.test_type.gui");
            Entity apiTestType = UftDiscoveryResultDispatcherImpl.createListNodeEntity("list_node.test_type.api");
            Entity scmRepository = dtoFactory.newDTO(Entity.class).setType("scm_repository").setId(scmRepositoryId);
            Entity testRunner = SdkStringUtils.isNotEmpty(testRunnerId) ? dtoFactory.newDTO(Entity.class).setType("executor").setId(testRunnerId) : null;
            for (AutomatedTest test : tests) {
                Entity testType = UftTestType.API.equals((Object)test.getUftTestType()) ? apiTestType : guiTestType;
                EntityList testTypeList = dtoFactory.newDTO(EntityList.class).addEntity(testType);
                Entity octaneTest = dtoFactory.newDTO(Entity.class).setType("automated_test").setField("testing_tool_type", uftTestingTool).setField("framework", uftFramework).setField("test_type", testTypeList).setField("scm_repository", scmRepository).setField("name", test.getName()).setField("package", test.getPackage()).setField("description", test.getDescription()).setField("executable", test.getExecutable());
                testsForPost.add(octaneTest);
                if (testRunner == null) continue;
                octaneTest.setField("test_runner", testRunner);
            }
            for (int i = 0; i < testsForPost.size(); i += 100) {
                try {
                    List<Entity> subList = testsForPost.subList(i, Math.min(i + 100, testsForPost.size()));
                    entitiesService.postEntities((Long)Long.parseLong(workspaceId), "automated_tests", subList);
                    continue;
                }
                catch (OctaneBulkException e) {
                    return this.checkIfExceptionCanBeIgnoredInPOST(e, "Failed to post tests");
                }
            }
        }
        return true;
    }

    private boolean postScmResources(EntitiesService entitiesService, List<ScmResourceFile> resources, String workspaceId, String scmRepositoryId) {
        if (!resources.isEmpty()) {
            ArrayList<Entity> entitiesForPost = new ArrayList<Entity>(resources.size());
            Entity scmRepository = dtoFactory.newDTO(Entity.class).setType("scm_repository").setId(scmRepositoryId);
            for (ScmResourceFile resource : resources) {
                Entity entity = dtoFactory.newDTO(Entity.class).setType("scm_resource_file").setName(resource.getName()).setField("scm_repository", scmRepository).setField("relative_path", resource.getRelativePath());
                entitiesForPost.add(entity);
            }
            for (int i = 0; i < resources.size(); i += 100) {
                try {
                    List<Entity> subList = entitiesForPost.subList(i, Math.min(i + 100, entitiesForPost.size()));
                    entitiesService.postEntities((Long)Long.parseLong(workspaceId), "scm_resource_files", subList);
                    continue;
                }
                catch (OctaneBulkException e) {
                    return this.checkIfExceptionCanBeIgnoredInPOST(e, "Failed to post scm resource files");
                }
            }
        }
        return true;
    }

    private boolean updateTests(EntitiesService entitiesService, Collection<AutomatedTest> tests, String workspaceId, String scmRepositoryId, String testRunnerId) {
        Entity testRunner = SdkStringUtils.isNotEmpty(testRunnerId) ? dtoFactory.newDTO(Entity.class).setType("executor").setId(testRunnerId) : null;
        try {
            ArrayList<Entity> testsForUpdate = new ArrayList<Entity>();
            for (AutomatedTest test : tests) {
                Entity octaneTest = dtoFactory.newDTO(Entity.class).setType("automated_test").setId(test.getId()).setField("executable", test.getExecutable());
                if (test.getDescription() != null) {
                    octaneTest.setField("description", test.getDescription());
                }
                if (test.getIsMoved().booleanValue()) {
                    octaneTest.setName(test.getName());
                    octaneTest.setField("package", test.getPackage());
                }
                if (test.isMissingScmRepository()) {
                    Entity scmRepository = dtoFactory.newDTO(Entity.class).setType("scm_repository").setId(scmRepositoryId);
                    octaneTest.setField("scm_repository", scmRepository);
                }
                if (test.isMissingTestRunner() && testRunner != null) {
                    octaneTest.setField("test_runner", testRunner);
                }
                testsForUpdate.add(octaneTest);
            }
            if (!testsForUpdate.isEmpty()) {
                for (int i = 0; i < tests.size(); i += 100) {
                    List<Entity> subList = testsForUpdate.subList(i, Math.min(i + 100, tests.size()));
                    entitiesService.updateEntities((Long)Long.parseLong(workspaceId), "automated_tests", subList);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to update tests : " + e.getMessage());
            return false;
        }
    }

    private boolean updateScmResources(EntitiesService entitiesService, List<ScmResourceFile> updatedResourceFiles, String workspaceId) {
        try {
            ArrayList<Entity> entitiesForUpdate = new ArrayList<Entity>(updatedResourceFiles.size());
            for (ScmResourceFile resource : updatedResourceFiles) {
                Entity entity = dtoFactory.newDTO(Entity.class).setType("scm_resource_file").setName(resource.getName()).setId(resource.getId()).setField("relative_path", resource.getRelativePath());
                entitiesForUpdate.add(entity);
            }
            if (!updatedResourceFiles.isEmpty()) {
                for (int i = 0; i < updatedResourceFiles.size(); i += 100) {
                    List<Entity> data = entitiesForUpdate.subList(i, Math.min(i + 100, entitiesForUpdate.size()));
                    entitiesService.updateEntities((Long)Long.parseLong(workspaceId), "scm_resource_files", data);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to update data tables : " + e.getMessage());
            return false;
        }
    }

    private boolean deleteScmResources(EntitiesService entitiesService, List<ScmResourceFile> deletedResourceFiles, String workspaceId) {
        HashSet<String> deletedIds = new HashSet<String>();
        try {
            for (ScmResourceFile scmResource : deletedResourceFiles) {
                deletedIds.add(scmResource.getId());
            }
            entitiesService.deleteEntitiesByIds(Long.parseLong(workspaceId), "scm_resource_files", deletedIds);
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to delete data tables : " + e.getMessage());
            return false;
        }
    }

    private boolean checkExecutorExistInOctane(EntitiesService entitiesService, UftTestDiscoveryResult result) {
        List<Entity> entities = entitiesService.getEntitiesByIds(Long.parseLong(result.getWorkspaceId()), "executors", Arrays.asList(result.getTestRunnerId()));
        return !entities.isEmpty();
    }

    private boolean checkIfExceptionCanBeIgnoredInPOST(OctaneBulkException e, String errorPrefix) {
        boolean isRealException = true;
        if (e.getResponseStatus() == 409) {
            isRealException = false;
            for (OctaneRestExceptionData exceptionData : e.getData().getErrors()) {
                if (exceptionData.getErrorCode().equals("platform.duplicate_entity_error")) continue;
                isRealException = true;
            }
        }
        if (isRealException) {
            logger.error(errorPrefix + "  :  " + e.getMessage());
        }
        return isRealException;
    }
}

