/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.uft.DiscoveryResultPreparer;
import com.hp.octane.integrations.uft.UftTestDiscoveryUtils;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.UftTestAction;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MbtDiscoveryResultPreparerImpl
implements DiscoveryResultPreparer {
    private static final Logger logger = LogManager.getLogger(MbtDiscoveryResultPreparerImpl.class);

    @Override
    public void prepareDiscoveryResultForDispatchInFullSyncMode(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        String condition = QueryHelper.conditionNot(QueryHelper.conditionEmpty("repository_path"));
        List<Entity> unitsFromServer = this.getUnitsFromServer(entitiesService, discoveryResult.getWorkspaceId(), condition);
        Map<String, Entity> octaneUnitsMap = unitsFromServer.stream().collect(Collectors.toMap(entity -> entity.getStringValue("repository_path").toLowerCase(), action -> action, (action1, action2) -> action1));
        this.removeExistingUnits(discoveryResult, octaneUnitsMap);
    }

    @Override
    public void prepareDiscoveryResultForDispatchInScmChangesMode(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        this.prepareMovedTests(discoveryResult);
        this.handleDeletedTests(entitiesService, discoveryResult);
        this.handleAddedTests(entitiesService, discoveryResult);
        this.handleUpdatedTests(entitiesService, discoveryResult);
        this.handleMovedTests(entitiesService, discoveryResult);
    }

    private List<Entity> getUnitsFromServer(EntitiesService entitiesService, String workspaceId, String ... conditions) {
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("id", "name", "description", "repository_path"));
        return entitiesService.getEntities(Long.parseLong(workspaceId), "model_items", Arrays.asList(conditions), fields);
    }

    private void removeExistingUnits(UftTestDiscoveryResult discoveryResult, Map<String, Entity> octaneUnitsMap) {
        discoveryResult.getAllTests().forEach(automatedTest -> {
            automatedTest.getActions().forEach(action -> {
                if (Objects.nonNull(octaneUnitsMap.get(action.getRepositoryPath().toLowerCase()))) {
                    action.setOctaneStatus(OctaneStatus.NONE);
                }
            });
            this.removeItemsWithStatusNone(automatedTest.getActions());
        });
    }

    private void prepareMovedTests(UftTestDiscoveryResult result) {
        List<AutomatedTest> newTests = result.getNewTests();
        List<AutomatedTest> deletedTests = result.getDeletedTests();
        if (!newTests.isEmpty() && !deletedTests.isEmpty()) {
            logger.info("processing moved tests");
            Map<String, AutomatedTest> dst2Test = newTests.stream().filter(automatedTest -> SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst())).collect(Collectors.toMap(AutomatedTest::getChangeSetDst, automatedTest -> automatedTest));
            Map<AutomatedTest, AutomatedTest> deleted2newMovedTests = deletedTests.stream().filter(automatedTest -> SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst()) && dst2Test.containsKey(automatedTest.getChangeSetDst())).collect(Collectors.toMap(automatedTest -> automatedTest, automatedTest -> (AutomatedTest)dst2Test.get(automatedTest.getChangeSetDst())));
            deleted2newMovedTests.forEach((deletedTest, newTest) -> {
                newTest.setIsMoved(true);
                newTest.setOldName(deletedTest.getName());
                newTest.setOldPackage(deletedTest.getPackage());
                newTest.setOctaneStatus(OctaneStatus.MODIFIED);
                result.getAllTests().remove(deletedTest);
            });
            logger.info("found {} tests that were moved", (Object)deleted2newMovedTests.size());
        }
    }

    private void handleDeletedTests(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        List<AutomatedTest> deletedTests = discoveryResult.getDeletedTests();
        if (CollectionUtils.isEmpty(deletedTests)) {
            return;
        }
        logger.info("processing deleted tests. found {} tests", (Object)deletedTests.size());
        String condition = QueryHelper.orConditions((String[])deletedTests.stream().map(test -> this.getActionPathPrefixCondition((AutomatedTest)test, false)).toArray(String[]::new));
        List<Entity> unitsFromServer = this.getUnitsFromServer(entitiesService, discoveryResult.getWorkspaceId(), condition);
        deletedTests.forEach(automatedTest -> {
            String actionPathPrefix = UftTestDiscoveryUtils.getTestPathPrefix(automatedTest, false);
            List unitEntitiesOfTest = unitsFromServer.stream().filter(entity -> entity.getStringValue("repository_path").startsWith(actionPathPrefix)).collect(Collectors.toList());
            unitsFromServer.removeAll(unitEntitiesOfTest);
            List<UftTestAction> actions = unitEntitiesOfTest.stream().map(entity -> {
                UftTestAction action = this.convertToAction((Entity)entity);
                action.setOctaneStatus(OctaneStatus.DELETED);
                return action;
            }).collect(Collectors.toList());
            automatedTest.setActions(actions);
        });
    }

    private String getActionPathPrefixCondition(AutomatedTest test, boolean orgPath) {
        String actionPathPrefix = UftTestDiscoveryUtils.getTestPathPrefix(test, orgPath);
        return QueryHelper.conditionStartWith("repository_path", actionPathPrefix);
    }

    private void handleAddedTests(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        List<AutomatedTest> newTests = discoveryResult.getNewTests();
        if (CollectionUtils.isEmpty(newTests)) {
            return;
        }
        logger.info("processing new tests. found {} tests", (Object)newTests.size());
        Set newActionsRepositoryPaths = newTests.stream().filter(automatedTest -> automatedTest.getIsMoved() == false).map(AutomatedTest::getActions).flatMap(Collection::stream).map(UftTestAction::getRepositoryPath).collect(Collectors.toSet());
        String condition = QueryHelper.conditionIn("repository_path", newActionsRepositoryPaths, false);
        List<Entity> unitsFromServer = this.getUnitsFromServer(entitiesService, discoveryResult.getWorkspaceId(), condition);
        Map<String, Entity> octaneUnitsMap = unitsFromServer.stream().collect(Collectors.toMap(entity -> entity.getStringValue("repository_path").toLowerCase(), action -> action, (action1, action2) -> action1));
        this.removeExistingUnits(discoveryResult, octaneUnitsMap);
    }

    private void handleUpdatedTests(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        List<AutomatedTest> updatedTests = discoveryResult.getUpdatedTests().stream().filter(automatedTest -> automatedTest.getIsMoved() == false).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(updatedTests)) {
            return;
        }
        logger.info("processing updated tests. found {} tests", (Object)updatedTests.size());
        Map<String, UftTestAction> scmPathToActionMap = updatedTests.stream().map(AutomatedTest::getActions).flatMap(Collection::stream).collect(Collectors.toMap(action -> this.extractScmPathFromActionPath(action.getRepositoryPath()), action -> action));
        String condition = QueryHelper.orConditions((String[])updatedTests.stream().map(test -> this.getActionPathPrefixCondition((AutomatedTest)test, false)).toArray(String[]::new));
        List<Entity> unitsFromServer = this.getUnitsFromServer(entitiesService, discoveryResult.getWorkspaceId(), condition);
        Map<String, Entity> scmPathToEntityMap = unitsFromServer.stream().collect(Collectors.toMap(entity -> this.extractScmPathFromActionPath(entity.getStringValue("repository_path")), action -> action, (action1, action2) -> action1));
        this.handleUpdatedTestAddedActionCase(scmPathToActionMap, scmPathToEntityMap);
        this.handleUpdatedTestDeletedActionCase(scmPathToActionMap, scmPathToEntityMap, updatedTests);
        this.handleUpdatedTestUpdatedActionCase(scmPathToActionMap, scmPathToEntityMap);
        if (!scmPathToActionMap.isEmpty() || !scmPathToEntityMap.isEmpty()) {
            logger.warn("not all of the existing units or actions were processed");
        }
    }

    private void handleMovedTests(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        List<AutomatedTest> movedTests = discoveryResult.getUpdatedTests().stream().filter(AutomatedTest::getIsMoved).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(movedTests)) {
            return;
        }
        String condition = QueryHelper.orConditions((String[])movedTests.stream().map(test -> this.getActionPathPrefixCondition((AutomatedTest)test, true)).toArray(String[]::new));
        List<Entity> unitsFromServer = this.getUnitsFromServer(entitiesService, discoveryResult.getWorkspaceId(), condition);
        HashMap actionPathToUnitIdMap = new HashMap();
        movedTests.forEach(automatedTest -> {
            String originalActionPathPrefix = UftTestDiscoveryUtils.getTestPathPrefix(automatedTest, true);
            String newActionPathPrefix = UftTestDiscoveryUtils.getTestPathPrefix(automatedTest, false);
            List<Entity> entities = unitsFromServer.stream().filter(entity -> entity.getStringValue("repository_path").startsWith(originalActionPathPrefix)).collect(Collectors.toList());
            entities.forEach(entity -> {
                String key = entity.getStringValue("repository_path").replace(originalActionPathPrefix, newActionPathPrefix);
                actionPathToUnitIdMap.put(key, entity.getId());
            });
            unitsFromServer.removeAll(entities);
        });
        if (CollectionUtils.isNotEmpty(unitsFromServer)) {
            logger.warn("not all units from octane were mapped to moved tests");
        }
        movedTests.forEach(automatedTest -> automatedTest.getActions().forEach(action -> {
            action.setId((String)actionPathToUnitIdMap.get(action.getRepositoryPath()));
            action.setOctaneStatus(OctaneStatus.MODIFIED);
            action.setMoved(true);
            action.setOldTestName(automatedTest.getOldName());
            action.getParameters().forEach(parameter -> parameter.setOctaneStatus(OctaneStatus.NONE));
            this.removeItemsWithStatusNone(action.getParameters());
        }));
    }

    private String extractScmPathFromActionPath(String repositoryPath) {
        int index = repositoryPath.indexOf(":");
        if (index == -1) {
            return repositoryPath;
        }
        return repositoryPath.substring(0, index).toLowerCase();
    }

    private void handleUpdatedTestAddedActionCase(Map<String, UftTestAction> scmPathToActionMap, Map<String, Entity> scmPathToEntityMap) {
        Collection<String> addedActions = CollectionUtils.removeAll(scmPathToActionMap.keySet(), scmPathToEntityMap.keySet());
        if (CollectionUtils.isNotEmpty(addedActions)) {
            logger.info("found {} updated tests for added action", (Object)addedActions.size());
            addedActions.forEach(s -> {
                ((UftTestAction)scmPathToActionMap.get(s)).setOctaneStatus(OctaneStatus.NEW);
                scmPathToActionMap.remove(s);
            });
        }
    }

    private void handleUpdatedTestDeletedActionCase(Map<String, UftTestAction> scmPathToActionMap, Map<String, Entity> scmPathToEntityMap, List<AutomatedTest> updatedTests) {
        Collection<String> deletedActions = CollectionUtils.removeAll(scmPathToEntityMap.keySet(), scmPathToActionMap.keySet());
        if (CollectionUtils.isNotEmpty(deletedActions)) {
            HashSet updatedTestsCounter = new HashSet();
            deletedActions.forEach(s -> {
                String scmTestPath = this.extractScmTestPath((String)s);
                if (Objects.isNull(scmTestPath)) {
                    logger.warn("repository path {} of unit id {} name {} is not valid and will be discarded", s, (Object)((Entity)scmPathToEntityMap.get(s)).getId(), (Object)((Entity)scmPathToEntityMap.get(s)).getName());
                    scmPathToEntityMap.remove(s);
                } else {
                    updatedTests.forEach(automatedTest -> {
                        String calculatedTestPath = UftTestDiscoveryUtils.getTestPathPrefix(automatedTest, false).toLowerCase();
                        if (calculatedTestPath.equals(scmTestPath)) {
                            Entity entity = (Entity)scmPathToEntityMap.get(s);
                            UftTestAction action = this.convertToAction(entity);
                            action.setOctaneStatus(OctaneStatus.DELETED);
                            automatedTest.getActions().add(action);
                            updatedTestsCounter.add(automatedTest);
                        }
                    });
                    scmPathToEntityMap.remove(s);
                    logger.info("found {} updated tests for deleted action", (Object)updatedTestsCounter.size());
                }
            });
        }
    }

    private void handleUpdatedTestUpdatedActionCase(Map<String, UftTestAction> scmPathToActionMap, Map<String, Entity> scmPathToEntityMap) {
        Collection<String> sameActions = CollectionUtils.retainAll(scmPathToEntityMap.keySet(), scmPathToActionMap.keySet());
        if (CollectionUtils.isNotEmpty(sameActions)) {
            sameActions.forEach(scmPath -> {
                UftTestAction action = (UftTestAction)scmPathToActionMap.get(scmPath);
                action.setOctaneStatus(OctaneStatus.NONE);
                action.getParameters().forEach(parameter -> parameter.setOctaneStatus(OctaneStatus.NONE));
                scmPathToActionMap.remove(scmPath);
                scmPathToEntityMap.remove(scmPath);
            });
        }
    }

    private boolean isEquals(UftTestAction action, Entity unitEntity) {
        String unitName = unitEntity.getStringValue("name");
        String unitDescription = unitEntity.getStringValue("description");
        if (SdkStringUtils.isNotEmpty(unitDescription)) {
            unitDescription = this.removeHtmlTagsFromString(unitDescription);
        }
        return !unitName.toLowerCase().contains(action.getName().toLowerCase()) && action.getLogicalName().equalsIgnoreCase(unitName) && (SdkStringUtils.isEmpty(action.getDescription()) && SdkStringUtils.isEmpty(unitDescription) || SdkStringUtils.isNotEmpty(action.getDescription()) && SdkStringUtils.isNotEmpty(unitDescription) && action.getDescription().equalsIgnoreCase(unitDescription));
    }

    private String extractScmTestPath(String scmPath) {
        int index = (scmPath = this.extractScmPathFromActionPath(scmPath)).lastIndexOf(92);
        if (index == -1) {
            return null;
        }
        String scmTestPath = scmPath.substring(0, index);
        String actionNumber = scmPath.substring(index + 1, scmPath.length() - 1);
        if (actionNumber.startsWith("action")) {
            return scmTestPath;
        }
        return null;
    }

    private String removeHtmlTagsFromString(String str) {
        if (SdkStringUtils.isEmpty(str)) {
            return str;
        }
        str = str.replace("<p>", "\n");
        return str.replaceAll("\\<.*?>", "");
    }

    private UftTestAction convertToAction(Entity entity) {
        UftTestAction action = new UftTestAction();
        action.setId(entity.getId());
        action.setName(entity.getName());
        action.setLogicalName(entity.getName());
        action.setRepositoryPath(String.valueOf(entity.getField("repository_path")));
        return action;
    }
}

