/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.sonar;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.services.vulnerabilities.OctaneIssueConsts;
import com.hp.octane.integrations.services.vulnerabilities.sonar.dto.SonarIssue;
import com.hp.octane.integrations.services.vulnerabilities.sonar.dto.SonarRule;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCToOctaneIssueUtil;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonarToOctaneIssueUtil {
    private static final Logger logger = LogManager.getLogger(SSCToOctaneIssueUtil.class);
    public static final String SONAR_SEVERITY_BLOCKER = "BLOCKER";
    public static final String SONAR_SEVERITY_CRITICAL = "CRITICAL";
    public static final String SONAR_SEVERITY_MAJOR = "MAJOR";
    public static final String SONAR_SEVERITY_MINOR = "MINOR";
    public static final String EXTERNAL_TOOL_NAME = "SonarQube";

    public static List<OctaneIssue> createOctaneIssues(List<SonarIssue> issues, String remoteTag, String sonarUrl, Set<String> issuesRequiredExtendedDataKeys, Map<String, SonarRule> rules) {
        if (issues == null) {
            return new ArrayList<OctaneIssue>();
        }
        DTOFactory dtoFactory = DTOFactory.getInstance();
        ArrayList<OctaneIssue> octaneIssues = new ArrayList<OctaneIssue>();
        for (SonarIssue issue : issues) {
            OctaneIssue octaneIssue = SonarToOctaneIssueUtil.createOctaneIssue(dtoFactory, issue, rules, sonarUrl);
            octaneIssue.setRemoteTag(remoteTag);
            octaneIssues.add(octaneIssue);
            if (issuesRequiredExtendedDataKeys.contains(issue.getKey())) {
                Map<String, String> extendedData = SonarToOctaneIssueUtil.prepareExtendedData(issue, rules);
                octaneIssue.setExtendedData(extendedData);
                SonarToOctaneIssueUtil.setOctaneStatus(issue, octaneIssue, true);
                continue;
            }
            SonarToOctaneIssueUtil.setOctaneStatus(issue, octaneIssue, false);
        }
        return octaneIssues;
    }

    private static OctaneIssue createOctaneIssue(DTOFactory dtoFactory, SonarIssue issue, Map<String, SonarRule> rules, String sonarUrl) {
        logger.debug("enter createOctaneIssue");
        OctaneIssue octaneIssue = dtoFactory.newDTO(OctaneIssue.class);
        SonarToOctaneIssueUtil.setOctaneSeverity(issue, octaneIssue);
        SonarToOctaneIssueUtil.setPrimaryLocationFull(issue, octaneIssue);
        SonarToOctaneIssueUtil.setExternalLink(issue, octaneIssue, sonarUrl);
        octaneIssue.setLine(issue.getLine());
        octaneIssue.setRemoteId(issue.getKey());
        octaneIssue.setIntroducedDate(SonarToOctaneIssueUtil.convertDates(issue.getCreationDate()));
        octaneIssue.setToolName(EXTERNAL_TOOL_NAME);
        octaneIssue.setCategory(rules.get(issue.getRule()).getName());
        logger.debug("exit createOctaneIssue");
        return octaneIssue;
    }

    private static String convertDates(String inputFoundDate) {
        if (inputFoundDate == null) {
            return null;
        }
        try {
            SimpleDateFormat sourceDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssz");
            SimpleDateFormat dfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
            dfUtc.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dfUtc.format(sourceDateFormat.parse(inputFoundDate));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            logger.error(e.getStackTrace());
            return null;
        }
    }

    private static void setOctaneStatus(SonarIssue issue, OctaneIssue octaneIssue, boolean isNew) {
        if (issue.getStatus() != null) {
            String listNodeId = "";
            if (issue.getStatus().equalsIgnoreCase("OPEN")) {
                listNodeId = isNew ? "list_node.issue_state_node.new" : "list_node.issue_state_node.existing";
            } else if (issue.getStatus().equalsIgnoreCase("CONFIRMED") || issue.getStatus().equalsIgnoreCase("RESOLVED")) {
                listNodeId = "list_node.issue_state_node.existing";
            } else if (issue.getStatus().equalsIgnoreCase("REOPENED")) {
                listNodeId = "list_node.issue_state_node.reopen";
            } else if (issue.getStatus().equalsIgnoreCase("CLOSED")) {
                listNodeId = "list_node.issue_state_node.closed";
            }
            if (OctaneIssueConsts.isLegalOctaneState(listNodeId)) {
                octaneIssue.setState(SonarToOctaneIssueUtil.createListNodeEntity(listNodeId));
            }
        }
    }

    private static void setPrimaryLocationFull(SonarIssue issue, OctaneIssue octaneIssue) {
        Integer offset = issue.getProject().length();
        String path = issue.getComponent().substring(offset + 1);
        octaneIssue.setPrimaryLocationFull(path);
    }

    private static void setExternalLink(SonarIssue issue, OctaneIssue octaneIssue, String sonarUrl) {
        String encodedProject = CIPluginSDKUtils.urlEncodeQueryParam(issue.getProject());
        String encodedKey = CIPluginSDKUtils.urlEncodeQueryParam(issue.getKey());
        if (!sonarUrl.substring(sonarUrl.length() - 1).equals("/")) {
            sonarUrl = sonarUrl + "/";
        }
        octaneIssue.setExternalLink(String.format("%sproject/issues?issues=%s&id=%s&open=%s", sonarUrl, encodedKey, encodedProject, encodedKey));
    }

    private static Map<String, String> prepareExtendedData(SonarIssue issue, Map<String, SonarRule> rules) {
        String ruleKey = issue.getRule();
        SonarRule rule = rules.get(ruleKey);
        HashMap<String, String> retVal = new HashMap<String, String>();
        retVal.put("ruleName", rule.getName());
        if (rule.getHtmlDesc() != null) {
            retVal.put("htmlDesc", rule.getHtmlDesc());
        }
        return retVal;
    }

    private static void setOctaneSeverity(SonarIssue issue, OctaneIssue octaneIssue) {
        if (issue.getSeverity() != null) {
            String octaneSeverity = SonarToOctaneIssueUtil.getOctaneSeverityFromSSCValue(issue.getSeverity());
            octaneIssue.setSeverity(SonarToOctaneIssueUtil.createListNodeEntity(octaneSeverity));
        }
    }

    private static String getOctaneSeverityFromSSCValue(String severity) {
        if (severity == null) {
            return null;
        }
        String logicalNameForSeverity = null;
        if (severity.equals(SONAR_SEVERITY_BLOCKER) || severity.equals(SONAR_SEVERITY_CRITICAL)) {
            logicalNameForSeverity = "list_node.severity.urgent";
        } else if (severity.equals(SONAR_SEVERITY_MAJOR)) {
            logicalNameForSeverity = "list_node.severity.high";
        } else if (severity.equals(SONAR_SEVERITY_MINOR)) {
            logicalNameForSeverity = "list_node.severity.low";
        }
        return logicalNameForSeverity;
    }

    public static Entity createListNodeEntity(String id) {
        if (id == null) {
            return null;
        }
        return DTOFactory.getInstance().newDTO(Entity.class).setType("list_node").setId(id);
    }
}

