/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.fod.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODConfig;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODEntityCollection;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Predicate;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FODConnector
implements FODSource {
    private static final Logger logger = LogManager.getLogger(FODConnector.class);
    private CloseableHttpClient httpClient;
    private String access_token;
    private long accessTokenTime;
    private final FODConfig fodConfig;

    public FODConnector(FODConfig fodConfig) {
        this.fodConfig = fodConfig;
    }

    public void initConnection(OctaneSDK.SDKServicesConfigurer configurer) {
        logger.debug("init FOD connector");
        try {
            CIProxyConfiguration proxyConfiguration = configurer.pluginServices.getProxyConfiguration(new URL(this.fodConfig.authURL));
            if (proxyConfiguration != null) {
                logger.warn("FOD connection needs proxy");
                HttpClientBuilder clientBuilder = HttpClients.custom();
                String proxyHost = proxyConfiguration.getHost();
                Integer proxyPortNumber = proxyConfiguration.getPort();
                clientBuilder.setProxy(new HttpHost(proxyHost, (int)proxyPortNumber));
                this.httpClient = clientBuilder.build();
            } else {
                logger.warn("FOD connection does not need proxy");
                this.httpClient = HttpClients.createDefault();
            }
            this.getAccessToken();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T extends FODEntityCollection> T getAllFODEntities(String rawURL, Class<T> targetClass, Predicate<T> whenToStopFetch) {
        try {
            FODEntityCollection fetchedEnts = (FODEntityCollection)targetClass.newInstance();
            boolean allIsFetched = false;
            boolean shouldStopFetching = false;
            while (!allIsFetched) {
                try {
                    int offset = fetchedEnts.items.size();
                    String indexedURL = this.addOffsetToURL(rawURL, offset);
                    String rawResponse = this.getRawResponseFromFOD(indexedURL);
                    FODEntityCollection entityCollection = (FODEntityCollection)new ObjectMapper().readValue(rawResponse, TypeFactory.defaultInstance().constructType(fetchedEnts.getClass()));
                    if (whenToStopFetch != null) {
                        shouldStopFetching = whenToStopFetch.test(entityCollection);
                    }
                    fetchedEnts.items.addAll(entityCollection.items);
                    fetchedEnts.totalCount = fetchedEnts.items.size();
                    allIsFetched = fetchedEnts.totalCount == entityCollection.totalCount || shouldStopFetching;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            return (T)fetchedEnts;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <T> T getSpeceficFODEntity(String rawURL, Class<T> targetClass) {
        try {
            T fetchedEntityInstance = targetClass.newInstance();
            String rawResponse = this.getRawResponseFromFOD(rawURL);
            Object entityFetched = new ObjectMapper().readValue(rawResponse, TypeFactory.defaultInstance().constructType(fetchedEntityInstance.getClass()));
            return entityFetched;
        }
        catch (PermanentException e) {
            throw e;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String addOffsetToURL(String rawURL, int offset) {
        String offsetDirective = "offset=" + String.valueOf(offset);
        if (!rawURL.contains("?")) {
            return rawURL + "?" + offsetDirective;
        }
        return rawURL + "&" + offsetDirective;
    }

    private String getRawResponseFromFOD(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Authorization", "Bearer " + this.getUpdatedAccessToken());
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Cookie", "__zlcmid=hTgaa94NtAdw5T; FoD=1725197834.36895.0000");
        httpGet.setHeader("Accept-Encoding", "gzip, deflate, br");
        HttpResponse response = null;
        try {
            logger.debug("sending the request : " + url);
            response = this.httpClient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() > 300) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new PermanentException("Cannot authenticate , the user is Unauthorized , make sure you are using the correct role for the user (): " + response.getStatusLine().getReasonPhrase());
                }
                if (response.getStatusLine().getStatusCode() == 503) {
                    throw new TemporaryException("Service Unavailable ,  retry");
                }
                throw new PermanentException("unexpected return response : " + response.getStatusLine().getReasonPhrase());
            }
            String string = FODConnector.isToString(response.getEntity().getContent());
            return string;
        }
        catch (IOException e) {
            throw new PermanentException(e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
        }
    }

    private String getUpdatedAccessToken() {
        long delta;
        long currentTime = new Date().getTime();
        if (currentTime - this.accessTokenTime >= (delta = FODConnector.getTimeToRefreshToken().longValue())) {
            this.getAccessToken();
        }
        return this.access_token;
    }

    private void getAccessToken() {
        HttpPost post = new HttpPost(this.fodConfig.authURL);
        StringEntity content = new StringEntity(this.fodConfig.getAuthBody(), ContentType.APPLICATION_FORM_URLENCODED);
        post.setEntity(content);
        HttpResponse response = null;
        try {
            logger.debug("inside getAccessToken():before Post ");
            response = this.httpClient.execute(post);
            logger.debug("inside getAccessToken():after Post, got status : " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                logger.error("inside getAccessToken():after Post, got status : " + response.getStatusLine().getStatusCode());
                throw new PermanentException("Cannot authenticate:" + response.getStatusLine().getReasonPhrase());
            }
            String secToken = FODConnector.isToString(response.getEntity().getContent());
            HashMap secTokeAsMap = new ObjectMapper().readValue(secToken, HashMap.class);
            this.access_token = secTokeAsMap.get("access_token").toString();
            this.accessTokenTime = new Date().getTime();
            logger.debug("inside getAccessToken():after Post ");
        }
        catch (IOException e) {
            logger.error("inside getAccessToken():After Post inside exception ", (Throwable)e);
            e.printStackTrace();
            throw new PermanentException("Cannot authenticate:" + e.getMessage());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
        }
    }

    static String isToString(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(Charset.forName("UTF-8").name());
    }

    @Override
    public String getEntitiesURL() {
        return this.fodConfig.entitiesURL;
    }

    public static Long getTimeToRefreshToken() {
        return 3600000L;
    }
}

