/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.sonar;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.coverage.BuildCoverage;
import com.hp.octane.integrations.dto.coverage.CoverageReportType;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.SonarIntegrationException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.coverage.CoverageService;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.sonar.SonarService;
import com.hp.octane.integrations.services.sonar.SonarUtils;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonarServiceImpl
implements SonarService {
    private static final Logger logger = LogManager.getLogger(SonarServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String SONAR_COVERAGE_QUEUE_FILE = "sonar-coverage-queue.dat";
    private static final String WEBHOOK_CREATE_URI = "/api/webhooks/create";
    private static final String WEBHOOK_LIST_URI = "/api/webhooks/list";
    private static final String SONAR_STATUS_URI = "/api/system/status";
    private static final String CONNECTION_FAILURE = "CONNECTION_FAILURE";
    private static final String COMPONENT_TREE_URI = "/api/measures/component_tree";
    private final ExecutorService sonarIntegrationExecutor = Executors.newSingleThreadExecutor(new SonarIntegrationWorkerThreadFactory());
    private final ObjectQueue<SonarBuildCoverageQueueItem> sonarIntegrationQueue;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final CoverageService coverageService;
    private final WorkerPreflight workerPreflight;
    private final ConfigurationService configurationService;
    private int TEMPORARY_ERROR_BREATHE_INTERVAL = 15000;

    public SonarServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, QueueingService queueingService, CoverageService coverageService, ConfigurationService configurationService) {
        if (configurer == null || configurer.pluginServices == null || configurer.octaneConfiguration == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (queueingService == null) {
            throw new IllegalArgumentException("queue service MUST NOT be null");
        }
        if (coverageService == null) {
            throw new IllegalArgumentException("coverage service MUST NOT be null");
        }
        this.configurer = configurer;
        this.coverageService = coverageService;
        this.configurationService = configurationService;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        this.sonarIntegrationQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue(SONAR_COVERAGE_QUEUE_FILE, SonarBuildCoverageQueueItem.class) : queueingService.initMemoQueue();
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.sonarIntegrationExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.sonarIntegrationQueue.getClass().getSimpleName() + ")");
    }

    private void worker() {
        while (!this.sonarIntegrationExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            SonarBuildCoverageQueueItem sonarBuildCoverageQueueItem = null;
            try {
                sonarBuildCoverageQueueItem = this.sonarIntegrationQueue.peek();
                this.retrieveAndPushSonarDataToOctane(sonarBuildCoverageQueueItem);
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "successfully processed " + sonarBuildCoverageQueueItem);
                this.sonarIntegrationQueue.remove();
            }
            catch (TemporaryException te) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + sonarBuildCoverageQueueItem + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying", (Throwable)te);
                CIPluginSDKUtils.doWait(this.TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (PermanentException pe) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + sonarBuildCoverageQueueItem + ", passing over", (Throwable)pe);
                this.sonarIntegrationQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build coverage item '" + sonarBuildCoverageQueueItem + "', passing over", t);
                this.sonarIntegrationQueue.remove();
            }
        }
    }

    @Override
    public synchronized void ensureSonarWebhookExist(String ciCallbackUrl, String sonarURL, String sonarToken) throws SonarIntegrationException {
        try {
            String webhookKey = this.getWebhookKey(ciCallbackUrl, sonarURL, sonarToken);
            if (webhookKey == null) {
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                String name = this.configurer.pluginServices.getServerInfo().getType() + "-" + this.configurer.pluginServices.getServerInfo().getUrl().replaceAll("[<>:\"/\\|?*]", "_").trim();
                URIBuilder uriBuilder = new URIBuilder(sonarURL + WEBHOOK_CREATE_URI).setParameter("name", name).setParameter("url", ciCallbackUrl);
                HttpPost request = new HttpPost(uriBuilder.toString());
                this.setTokenInHttpRequest(request, sonarToken);
                HttpResponse response = httpClient.execute(request);
                if (response.getStatusLine().getStatusCode() != 200) {
                    String errorMessage = "exception during webhook registration for  ciNotificationUrl: ".concat(ciCallbackUrl).concat(" with status code: ").concat(String.valueOf(response.getStatusLine().getStatusCode()));
                    throw new SonarIntegrationException(errorMessage);
                }
            }
        }
        catch (SonarIntegrationException e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "exception during webhook registration for ciNotificationUrl: " + ciCallbackUrl;
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + errorMessage, (Throwable)e);
            throw new SonarIntegrationException(errorMessage, e);
        }
    }

    @Override
    public void shutdown() {
        this.sonarIntegrationExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.sonarIntegrationExecutor.isShutdown();
    }

    @Override
    public void enqueueFetchAndPushSonarCoverage(String jobId, String buildId, String projectKey, String sonarURL, String sonarToken, String rootJobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (sonarURL == null || sonarURL.isEmpty()) {
            throw new IllegalArgumentException("sonar URL MUST NOT be null nor empty");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        this.sonarIntegrationQueue.add(new SonarBuildCoverageQueueItem(jobId, buildId, projectKey, sonarURL, sonarToken));
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public String getSonarStatus(String sonarURL) {
        try {
            URIBuilder uriBuilder = new URIBuilder(sonarURL + SONAR_STATUS_URI);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(uriBuilder.build());
            HttpResponse response = httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                return CIPluginSDKUtils.getObjectMapper().readTree(response.getEntity().getContent()).get("status").textValue();
            }
            return CONNECTION_FAILURE;
        }
        catch (IOException | URISyntaxException e) {
            return CONNECTION_FAILURE;
        }
    }

    private void retrieveAndPushSonarDataToOctane(SonarBuildCoverageQueueItem queueItem) {
        if (!this.coverageService.isSonarReportRelevant(queueItem.jobId)) {
            return;
        }
        StringBuilder errorMessage = new StringBuilder().append("failed to inject sonarqube coverage data to octane for project key: ").append(queueItem.projectKey).append(" with ciIdentity: ").append(this.configurer.octaneConfiguration.getInstanceId()).append(" with jobId: ").append(queueItem.jobId).append(" with buildId: ").append(queueItem.buildId);
        try {
            JsonNode jsonReport;
            Integer pageIndex = 0;
            BuildCoverage buildCoverageReport = dtoFactory.newDTO(BuildCoverage.class);
            do {
                Integer n = pageIndex;
                Integer n2 = pageIndex = Integer.valueOf(pageIndex + 1);
                InputStream reportStream = this.getPageFromSonar(queueItem, pageIndex);
                jsonReport = CIPluginSDKUtils.getObjectMapper().readTree(reportStream);
                buildCoverageReport.mergeSonarCoverageReport(jsonReport);
            } while (SonarUtils.sonarReportHasAnotherPage(pageIndex, jsonReport).booleanValue());
            OctaneResponse response = this.coverageService.pushCoverage(queueItem.jobId, queueItem.buildId, CoverageReportType.SONAR_REPORT, dtoFactory.dtoToJsonStream(buildCoverageReport));
            if (response.getStatus() == 503) {
                errorMessage.append(" with status code: ").append(response.getStatus());
                throw new TemporaryException(errorMessage.toString());
            }
            if (response.getStatus() != 200) {
                errorMessage.append(" with status code: ").append(response.getStatus()).append(" and response body: ").append(response.getBody());
                throw new PermanentException(errorMessage.toString());
            }
        }
        catch (Throwable throwable) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + errorMessage.toString(), throwable);
            throw new PermanentException(throwable);
        }
    }

    private String getWebhookKey(String ciNotificationUrl, String sonarURL, String token) throws SonarIntegrationException {
        try {
            URIBuilder uriBuilder = new URIBuilder(sonarURL + WEBHOOK_LIST_URI);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(uriBuilder.build());
            this.setTokenInHttpRequest(request, token);
            HttpResponse response = httpClient.execute(request);
            InputStream content = response.getEntity().getContent();
            if (content.available() != 0) {
                JsonNode jsonResponse = CIPluginSDKUtils.getObjectMapper().readTree(content);
                if (response.getStatusLine().getStatusCode() == 200) {
                    ArrayNode webhooksListJson = (ArrayNode)jsonResponse.get("webhooks");
                    if (webhooksListJson.size() > 0) {
                        for (JsonNode webhookNode : webhooksListJson) {
                            String entryURL = webhookNode.get("url").textValue();
                            if (!entryURL.equals(ciNotificationUrl)) continue;
                            return webhookNode.get("key").textValue();
                        }
                    }
                    return null;
                }
                String errorMessage = "".concat("failed to get webhook key from sonarqube with notification URL: ").concat(ciNotificationUrl).concat(" with status code: ").concat(String.valueOf(response.getStatusLine().getStatusCode())).concat(" with errors: ").concat(jsonResponse.get("errors").toString());
                throw new SonarIntegrationException(errorMessage);
            }
            return null;
        }
        catch (SonarIntegrationException e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "".concat("failed to get webhook key from sonarqube with notification URL: ").concat(ciNotificationUrl);
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + errorMessage, (Throwable)e);
            throw new SonarIntegrationException(errorMessage, e);
        }
    }

    private InputStream getPageFromSonar(SonarBuildCoverageQueueItem queueItem, Integer page) {
        String sonarURL = queueItem.sonarURL;
        String projectKey = queueItem.projectKey;
        String token = queueItem.sonarToken;
        StringBuilder errorMessage = new StringBuilder().append("failed to get data from sonar for project key: ").append(projectKey);
        try {
            URIBuilder uriBuilder = new URIBuilder(sonarURL + COMPONENT_TREE_URI);
            uriBuilder.setParameter("metricKeys", "lines_to_cover,uncovered_lines").setParameter("component", projectKey).setParameter("qualifiers", "FIL,TRK").setParameter("ps", "500").setParameter("p", page.toString());
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(uriBuilder.build());
            this.setTokenInHttpRequest(request, token);
            HttpResponse httpResponse = httpClient.execute(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                errorMessage.append(" with status code: ").append(statusCode).append(" and response body: ").append(EntityUtils.toString(httpResponse.getEntity(), "UTF-8"));
                throw new PermanentException(errorMessage.toString());
            }
            return httpResponse.getEntity().getContent();
        }
        catch (PermanentException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + errorMessage.toString(), (Throwable)e);
            throw new PermanentException(errorMessage.toString(), e);
        }
    }

    private void setTokenInHttpRequest(HttpRequest request, String token) throws AuthenticationException {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(token, "");
        request.addHeader(new BasicScheme().authenticate(creds, request, null));
    }

    @Override
    public long getQueueSize() {
        return this.sonarIntegrationQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.sonarIntegrationQueue.size() > 0) {
            this.sonarIntegrationQueue.remove();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private static final class SonarIntegrationWorkerThreadFactory
    implements ThreadFactory {
        private SonarIntegrationWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("SonarIntegrationWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    private static final class SonarBuildCoverageQueueItem
    implements QueueingService.QueueItem {
        private String jobId;
        private String buildId;
        private String projectKey;
        private String sonarURL;
        private String sonarToken;

        private SonarBuildCoverageQueueItem() {
        }

        public SonarBuildCoverageQueueItem(String jobId, String buildId, String projectKey, String sonarURL, String sonarToken) {
            this.jobId = jobId;
            this.buildId = buildId;
            this.projectKey = projectKey;
            this.sonarURL = sonarURL;
            this.sonarToken = sonarToken;
        }

        public String toString() {
            return "'" + this.jobId + " #" + this.buildId + "'";
        }
    }
}

