/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pipelines;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.entities.OctaneBulkExceptionData;
import com.hp.octane.integrations.dto.entities.OctaneRestExceptionData;
import com.hp.octane.integrations.dto.pipelines.PipelineContext;
import com.hp.octane.integrations.dto.pipelines.PipelineContextList;
import com.hp.octane.integrations.exceptions.OctaneBulkException;
import com.hp.octane.integrations.exceptions.OctaneRestException;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.pipelines.PipelineContextService;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class PipelineContextServiceImpl
implements PipelineContextService {
    private static final Logger logger = LogManager.getLogger(PipelineContextServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;

    PipelineContextServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    private String getSharedspaceAnalyticsContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/internal-api/shared_spaces/" + sharedSpaceId + "/analytics/ci/";
    }

    private String getWorkspaceAnalyticsContextPath(String octaneBaseUrl, String sharedSpaceId, long workspaceId) {
        return octaneBaseUrl + "/internal-api/shared_spaces/" + sharedSpaceId + "/workspaces/" + workspaceId + "/analytics/ci/";
    }

    private String getConfigurationUrl(String serverIdentity, String jobName) {
        boolean base64 = this.isEncodeBase64();
        String jobNameEncoded = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobName) : CIPluginSDKUtils.urlEncodePathParam(jobName);
        String url = this.getSharedspaceAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + String.format("servers/%s/jobs/%s/configuration", CIPluginSDKUtils.urlEncodePathParam(serverIdentity), jobNameEncoded);
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
            logger.info("Using base64, " + url);
        }
        return url;
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    @Override
    public PipelineContextList getJobConfiguration(String serverIdentity, String jobName) throws IOException {
        String url = this.getConfigurationUrl(serverIdentity, jobName);
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.GET).setUrl(url).setHeaders(headers);
        OctaneResponse response = octaneRestClient.execute(request);
        PipelineContextServiceImpl.validateResponse(200, response);
        PipelineContextList result = dtoFactory.dtoFromJson(response.getBody(), PipelineContextList.class);
        return result;
    }

    @Override
    public PipelineContext updatePipeline(String serverIdentity, String jobName, PipelineContext pipelineContext) throws IOException {
        String url = this.getConfigurationUrl(serverIdentity, jobName);
        this.validateReleaseAndMilestone(pipelineContext);
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        PipelineContextList list = dtoFactory.newDTO(PipelineContextList.class).setData(Arrays.asList(pipelineContext));
        String jsonData = dtoFactory.dtoToJson(list);
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.PUT).setUrl(url).setBody(jsonData).setHeaders(headers);
        OctaneResponse response = octaneRestClient.execute(request);
        PipelineContextServiceImpl.validateResponse(200, response);
        PipelineContextList resultList = dtoFactory.dtoFromJson(response.getBody(), PipelineContextList.class);
        PipelineContext result = resultList.getData().stream().filter(p -> p.getContextEntityId() == pipelineContext.getContextEntityId()).findFirst().get();
        return result;
    }

    @Override
    public PipelineContext createPipeline(String serverIdentity, String jobName, PipelineContext pipelineContext) throws IOException {
        String url = this.getConfigurationUrl(serverIdentity, jobName);
        this.validateReleaseAndMilestone(pipelineContext);
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        String jsonData = dtoFactory.dtoToJson(pipelineContext);
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.POST).setUrl(url).setBody(jsonData).setHeaders(headers);
        OctaneResponse response = octaneRestClient.execute(request);
        PipelineContextServiceImpl.validateResponse(201, response);
        PipelineContextList list = dtoFactory.dtoFromJson(response.getBody(), PipelineContextList.class);
        PipelineContext result = list.getData().stream().filter(p -> p.getWorkspaceId() == pipelineContext.getWorkspaceId()).findFirst().get();
        return result;
    }

    private void validateReleaseAndMilestone(PipelineContext pipelineContext) {
        if (pipelineContext.getReleaseId() != null && pipelineContext.getReleaseId() == -1L) {
            pipelineContext.setReleaseId(null);
        }
        if (pipelineContext.getMilestoneId() != null && pipelineContext.getMilestoneId() == -1L) {
            pipelineContext.setMilestoneId(null);
        }
    }

    @Override
    public void deleteTestsFromPipelineNodes(String jobName, long pipelineId, long workspaceId) throws IOException {
        String url = this.getWorkspaceAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace(), workspaceId) + String.format("pipelines/%s/jobs/%s/tests", pipelineId, CIPluginSDKUtils.urlEncodePathParam(jobName));
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.DELETE).setUrl(url).setHeaders(headers);
        OctaneResponse response = octaneRestClient.execute(request);
        PipelineContextServiceImpl.validateResponse(200, response);
    }

    private static void validateResponse(int expectedResult, OctaneResponse response) {
        if (response.getStatus() != expectedResult) {
            try {
                String body = response.getBody();
                if (body.contains("exceeds_total_count")) {
                    OctaneBulkExceptionData data = dtoFactory.dtoFromJson(body, OctaneBulkExceptionData.class);
                    throw new OctaneBulkException(response.getStatus(), data);
                }
                OctaneRestExceptionData data = dtoFactory.dtoFromJson(body, OctaneRestExceptionData.class);
                throw new OctaneRestException(response.getStatus(), data);
            }
            catch (OctaneBulkException | OctaneRestException ex1) {
                throw ex1;
            }
            catch (Exception ex2) {
                throw new RuntimeException("The request failed : " + response.getBody(), ex2);
            }
        }
    }
}

