/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.logging;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.logging.CommonLoggerContextUtil;
import com.hp.octane.integrations.services.logging.LoggingService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

final class LoggingServiceImpl
implements LoggingService {
    private static final Logger logger = LogManager.getLogger(LoggingServiceImpl.class);
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private boolean isShutdown;
    private final LoggerContext commonLoggerContext;

    LoggingServiceImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        this.configurer = configurer;
        this.commonLoggerContext = CommonLoggerContextUtil.configureLogger(configurer.pluginServices.getAllowedOctaneStorage());
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "logger is configured");
    }

    @Override
    public void shutdown() {
        if (OctaneSDK.getClients().isEmpty() && this.commonLoggerContext != null) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "last client is closing; general logger context is STOPPING");
            this.commonLoggerContext.stop();
            this.isShutdown = true;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }
}

