/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.executor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestToRunDataCollection;
import com.hp.octane.integrations.executor.TestsToRunConverterResult;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class TestsToRunConverter {
    public static final String DEFAULT_TESTS_TO_RUN_CONVERTED_PARAMETER = "testsToRunConverted";
    private String testsToRunConvertedParameterName = "testsToRunConverted";
    private String format = "";

    public TestsToRunConverter setFormat(String format) {
        this.format = format;
        return this;
    }

    protected String getFormat() {
        return this.format;
    }

    public TestsToRunConverterResult convert(String testsToRunStr, String executionDirectory, Map<String, String> globalParameters) {
        List<TestToRunData> data = TestsToRunConverter.parse(testsToRunStr);
        return this.convert(data, executionDirectory, globalParameters);
    }

    public TestsToRunConverterResult convert(List<TestToRunData> data, String executionDirectory, Map<String, String> globalParameters) {
        String converted = this.convertInternal(data, executionDirectory, globalParameters);
        TestsToRunConverterResult result = new TestsToRunConverterResult(data, converted, executionDirectory, this.testsToRunConvertedParameterName);
        this.afterConvert(result);
        return result;
    }

    public void enrichTestsData(List<TestToRunData> tests, Map<String, String> globalParameters) {
    }

    protected void afterConvert(TestsToRunConverterResult result) {
    }

    protected abstract String convertInternal(List<TestToRunData> var1, String var2, Map<String, String> var3);

    protected void setTestsToRunConvertedParameterName(String value) {
        if (SdkStringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("TestsToRunConvertedParameter cannot be empty");
        }
        this.testsToRunConvertedParameterName = value;
    }

    public static List<TestToRunData> parse(String rawTests) {
        if (SdkStringUtils.isEmpty(rawTests)) {
            return null;
        }
        boolean bTestToRunStringVersion = rawTests.startsWith("v1");
        if (bTestToRunStringVersion) {
            return TestsToRunConverter.parse(rawTests.substring(rawTests.indexOf(":") + 1).split(";"));
        }
        return TestsToRunConverter.parseJson(rawTests);
    }

    private static List<TestToRunData> parseJson(String rawTestsJson) {
        try {
            ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            TestToRunDataCollection result = objectMapper.readValue(rawTestsJson, TestToRunDataCollection.class);
            return result.getTestsToRun();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid tests format: " + e.getMessage(), e);
        }
    }

    private static List<TestToRunData> parse(String[] rawTestsArr) {
        ArrayList<TestToRunData> result = new ArrayList<TestToRunData>(rawTestsArr.length);
        int TEST_PARTS_MINIMAL_SIZE = 3;
        int PARAMETER_SIZE = 2;
        for (String rawtest : rawTestsArr) {
            String[] testParts = rawtest.split("\\|");
            if (testParts.length < TEST_PARTS_MINIMAL_SIZE) {
                throw new IllegalArgumentException("Test '" + rawtest + "' does not contains all required components");
            }
            TestToRunData data = new TestToRunData();
            result.add(data);
            data.setPackageName(testParts[0]).setClassName(testParts[1]).setTestName(testParts[2]);
            for (int i = TEST_PARTS_MINIMAL_SIZE; i < testParts.length; ++i) {
                String[] parameterParts = testParts[i].split("=");
                if (parameterParts.length != PARAMETER_SIZE) {
                    throw new IllegalArgumentException("Test' " + rawtest + "' contains an illegal parameter format.\nTextual format uses the following characters as separators: |;=. Your values probably contain these characters.Switch to JSON format by defining in ALM Octane the space parameter 'TESTS_TO_RUN_PARAMETER_JSON_FORMAT' = true.");
                }
                data.addParameters(parameterParts[0], parameterParts[1]);
            }
        }
        return result;
    }
}

