/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.general.OctaneConnectivityStatus;
import com.hp.octane.integrations.exceptions.OctaneValidationException;
import com.hp.octane.integrations.services.bridge.BridgeService;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.coverage.CoverageService;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.events.EventsService;
import com.hp.octane.integrations.services.logging.LoggingService;
import com.hp.octane.integrations.services.logs.LogsService;
import com.hp.octane.integrations.services.pipelines.PipelineContextService;
import com.hp.octane.integrations.services.pullrequestsandbranches.PullRequestAndBranchService;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.scmdata.SCMDataService;
import com.hp.octane.integrations.services.sonar.SonarService;
import com.hp.octane.integrations.services.tasking.TasksProcessor;
import com.hp.octane.integrations.services.testexecution.TestExecutionService;
import com.hp.octane.integrations.services.tests.TestsService;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesService;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesToolService;
import com.hp.octane.integrations.services.vulnerabilities.fod.FODService;
import com.hp.octane.integrations.services.vulnerabilities.sonar.SonarVulnerabilitiesService;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class OctaneClientImpl
implements OctaneClient {
    private static final Logger logger = LogManager.getLogger(OctaneClientImpl.class);
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final LoggingService loggingService;
    private final BridgeService bridgeService;
    private final ConfigurationService configurationService;
    private final CoverageService coverageService;
    private final SonarService sonarService;
    private final SSCService sscService;
    private final EntitiesService entitiesService;
    private final SonarVulnerabilitiesService sonarVulnerabilitiesService;
    private final PipelineContextService pipelineContextService;
    private final EventsService eventsService;
    private final LogsService logsService;
    private final QueueingService queueingService;
    private final RestService restService;
    private final TasksProcessor tasksProcessor;
    private final TestsService testsService;
    private final VulnerabilitiesService vulnerabilitiesService;
    private final PullRequestAndBranchService pullRequestAndBranchService;
    private final TestExecutionService testExecutionService;
    private final SCMDataService scmDataService;
    private final Thread shutdownHook;
    private boolean isShutdownHookActivated;
    private long shutdownHookActivatedTime;
    private long started = System.currentTimeMillis();

    OctaneClientImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        if (configurer == null) {
            throw new IllegalArgumentException("services configurer MUST NOT be null nor empty");
        }
        this.configurer = configurer;
        this.ensureStorageIfAny();
        this.loggingService = LoggingService.newInstance(configurer);
        this.queueingService = QueueingService.newInstance(configurer);
        this.restService = RestService.newInstance(configurer);
        this.configurationService = ConfigurationService.newInstance(configurer, this.restService);
        if (configurer.octaneConfiguration.isSuspended()) {
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "Client is SUSPENDED !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        this.refreshSdkSupported();
        if (!configurer.octaneConfiguration.isSdkSupported()) {
            logger.error(configurer.octaneConfiguration.getLocationForLog() + "Client is DISABLED: " + "This plugin version is outdated and is not supported by ALM Octane.");
        }
        this.tasksProcessor = TasksProcessor.newInstance(configurer, this.configurationService);
        this.tasksProcessor.resetJobListCache();
        this.coverageService = CoverageService.newInstance(configurer, this.queueingService, this.restService, this.configurationService);
        this.entitiesService = EntitiesService.newInstance(configurer, this.restService);
        this.pipelineContextService = PipelineContextService.newInstance(configurer, this.restService);
        this.eventsService = EventsService.newInstance(configurer, this.restService, this.configurationService);
        this.logsService = LogsService.newInstance(configurer, this.queueingService, this.restService, this.configurationService);
        this.testsService = TestsService.newInstance(configurer, this.queueingService, this.restService, this.configurationService);
        this.sscService = SSCService.newInstance(configurer, this.restService);
        this.sonarService = SonarService.newInstance(configurer, this.queueingService, this.coverageService, this.configurationService);
        this.sonarVulnerabilitiesService = SonarVulnerabilitiesService.newInstance(configurer, this.restService);
        FODService fodService = FODService.newInstance(configurer, this.restService);
        VulnerabilitiesToolService[] vulnerabilitiesToolServices = new VulnerabilitiesToolService[]{this.sscService, this.sonarVulnerabilitiesService, fodService};
        this.vulnerabilitiesService = VulnerabilitiesService.newInstance(this.queueingService, vulnerabilitiesToolServices, configurer, this.restService, this.configurationService);
        this.pullRequestAndBranchService = PullRequestAndBranchService.newInstance(configurer, this.restService, this.entitiesService);
        this.testExecutionService = TestExecutionService.newInstance(configurer, this.restService, this.entitiesService);
        this.scmDataService = SCMDataService.newInstance(this.queueingService, configurer, this.restService, this.configurationService, this.eventsService);
        this.bridgeService = BridgeService.newInstance(configurer, this.restService, this.tasksProcessor, this.configurationService);
        this.shutdownHook = new Thread(() -> {
            String instanceId = configurer.octaneConfiguration.getInstanceId();
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "closing OctaneClient " + instanceId + " as per Runtime shutdown request...");
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            try {
                this.isShutdownHookActivated = true;
                this.shutdownHookActivatedTime = System.currentTimeMillis();
                this.close();
            }
            catch (Throwable throwable) {
                logger.error(configurer.octaneConfiguration.getLocationForLog() + "failed during shutdown of OctaneClient " + instanceId, throwable);
            }
            finally {
                logger.info(configurer.octaneConfiguration.getLocationForLog() + "...OctaneClient " + instanceId + " CLOSED");
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        configurer.octaneConfiguration.getParameterNames().forEach(paramName -> logger.info(configurer.octaneConfiguration.getLocationForLog() + String.format("System parameter %s:%s", paramName, configurer.octaneConfiguration.getParameter((String)paramName).getRawValue())));
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "OctaneClient initialized with instance ID: " + configurer.octaneConfiguration.getInstanceId());
    }

    @Override
    public void refreshSdkSupported() {
        OctaneConnectivityStatus octaneConnectivityStatus = this.configurationService.getOctaneConnectivityStatus();
        if (octaneConnectivityStatus != null) {
            this.configurer.octaneConfiguration.setSdkSupported(CIPluginSDKUtils.isSdkSupported(octaneConnectivityStatus));
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "sdkSupported = " + this.configurer.octaneConfiguration.isSdkSupported());
        } else {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "refreshSdkSupported : octaneConnectivityStatus==null");
        }
    }

    @Override
    public String getInstanceId() {
        return this.configurer.octaneConfiguration.getInstanceId();
    }

    @Override
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public CoverageService getCoverageService() {
        return this.coverageService;
    }

    @Override
    public SonarService getSonarService() {
        return this.sonarService;
    }

    @Override
    public EntitiesService getEntitiesService() {
        return this.entitiesService;
    }

    @Override
    public BridgeService getBridgeService() {
        return this.bridgeService;
    }

    @Override
    public PipelineContextService getPipelineContextService() {
        return this.pipelineContextService;
    }

    @Override
    public EventsService getEventsService() {
        return this.eventsService;
    }

    @Override
    public LogsService getLogsService() {
        return this.logsService;
    }

    @Override
    public RestService getRestService() {
        return this.restService;
    }

    @Override
    public TasksProcessor getTasksProcessor() {
        return this.tasksProcessor;
    }

    @Override
    public TestsService getTestsService() {
        return this.testsService;
    }

    @Override
    public PullRequestAndBranchService getPullRequestAndBranchService() {
        return this.pullRequestAndBranchService;
    }

    @Override
    public TestExecutionService getTestExecutionService() {
        return this.testExecutionService;
    }

    @Override
    public VulnerabilitiesService getVulnerabilitiesService() {
        return this.vulnerabilitiesService;
    }

    @Override
    public SCMDataService getSCMDataService() {
        return this.scmDataService;
    }

    @Override
    public void validateOctaneIsActiveAndSupportVersion(String version) {
        if (!this.getConfigurationService().isConnected()) {
            throw new OctaneValidationException("ALM Octane is not connected.");
        }
        if (this.configurer.octaneConfiguration.isSuspended()) {
            throw new OctaneValidationException("ALM Octane is suspended.");
        }
        if (!this.getConfigurationService().isOctaneVersionGreaterOrEqual(version)) {
            throw new OctaneValidationException(String.format("Required ALM Octane version is %s, but connected ALM Octane has lower version %s.", version, this.getConfigurationService().getOctaneConnectivityStatus().getOctaneVersion()));
        }
    }

    public String toString() {
        return "OctaneClientImpl{ instanceId: " + this.configurer.octaneConfiguration.getInstanceId() + " }";
    }

    private void close() {
        this.queueingService.shutdown();
        this.bridgeService.shutdown();
        this.coverageService.shutdown();
        this.sonarService.shutdown();
        this.eventsService.shutdown();
        this.logsService.shutdown();
        this.testsService.shutdown();
        this.vulnerabilitiesService.shutdown();
        this.restService.obtainOctaneRestClient().shutdown();
        this.loggingService.shutdown();
        this.scmDataService.shutdown();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    void remove() {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Removing client");
        this.close();
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Removing client - services closed");
        if (this.configurer.pluginServices.getAllowedOctaneStorage() != null) {
            String instanceId = this.configurer.octaneConfiguration.getInstanceId();
            File instanceOrientedStorage = new File(this.configurer.pluginServices.getAllowedOctaneStorage(), "nga" + File.separator + instanceId);
            if (this.deleteFolder(instanceOrientedStorage)) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "cleaned dedicated storage");
            } else {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to clean dedicated storage");
            }
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Removing client done");
    }

    private void ensureStorageIfAny() {
        if (this.configurer.pluginServices.getAllowedOctaneStorage() != null) {
            String instanceId = this.configurer.octaneConfiguration.getInstanceId();
            File instanceOrientedStorage = new File(this.configurer.pluginServices.getAllowedOctaneStorage(), "nga" + File.separator + instanceId);
            if (instanceOrientedStorage.exists()) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "dedicated storage is exist for instance " + this.configurer.octaneConfiguration.getInstanceId());
            } else if (instanceOrientedStorage.mkdirs()) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "dedicated storage is created for instance " + this.configurer.octaneConfiguration.getInstanceId());
            } else {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to create dedicated storage : " + instanceOrientedStorage.getAbsolutePath());
            }
        }
    }

    private boolean deleteFolder(File folder) {
        File[] children = folder.listFiles();
        if (children != null) {
            for (File file : children) {
                this.deleteFolder(file);
            }
        }
        return folder.delete();
    }

    void notifyCredentialsChanged() {
        this.restService.notifyConfigurationChange();
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("location", this.configurer.octaneConfiguration.getLocationForLog());
        map.put("instanceId", this.configurer.octaneConfiguration.getInstanceId());
        map.put("sdkSupported", this.configurer.octaneConfiguration.isSdkSupported());
        map.put("isDisabled", this.configurer.octaneConfiguration.isDisabled());
        map.put("shutdownHookActivated", this.isShutdownHookActivated);
        if (this.isShutdownHookActivated) {
            map.put("shutdownHookActivatedTime", new Date(this.shutdownHookActivatedTime));
        }
        map.put("isConnected", this.getConfigurationService().isConnected());
        OctaneConnectivityStatus status = this.getConfigurationService().getOctaneConnectivityStatus();
        if (status != null) {
            map.put("octaneVersion", status.getOctaneVersion());
            map.put("supportedSdkVersion", status.getSupportedSdkVersion());
        }
        map.put("started", new Date(this.started));
        return map;
    }
}

