/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.util.GenericRecordUtil;

public class GenericRecordJsonWriter
implements Closeable {
    private static final String TABS;
    private static final String ZEROS = "0000000000000000";
    private static final Pattern ESC_CHARS;
    private static final List<Map.Entry<Class, BiConsumer<GenericRecordJsonWriter, Object>>> handler;
    private final PrintWriter fw;
    private int indent = 0;
    private boolean withComments = true;
    private int childIndex = 0;

    private static void handler(Class c, BiConsumer<GenericRecordJsonWriter, Object> printer) {
        handler.add(new AbstractMap.SimpleEntry<Class, BiConsumer<GenericRecordJsonWriter, Object>>(c, printer));
    }

    public GenericRecordJsonWriter(File fileName) throws IOException {
        OutputStream os = "null".equals(fileName.getName()) ? new NullOutputStream() : new FileOutputStream(fileName);
        this.fw = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public GenericRecordJsonWriter(Appendable buffer) {
        this.fw = new PrintWriter(new AppendableWriter(buffer));
    }

    public static String marshal(GenericRecord record) {
        return GenericRecordJsonWriter.marshal(record, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String marshal(GenericRecord record, boolean withComments) {
        StringBuilder sb = new StringBuilder();
        try (GenericRecordJsonWriter w = new GenericRecordJsonWriter(sb);){
            w.setWithComments(withComments);
            w.write(record);
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            return "{}";
        }
    }

    public void setWithComments(boolean withComments) {
        this.withComments = withComments;
    }

    @Override
    public void close() throws IOException {
        this.fw.close();
    }

    private String tabs() {
        return TABS.substring(0, Math.min(this.indent, TABS.length()));
    }

    public void write(GenericRecord record) {
        String tabs = this.tabs();
        Enum type = record.getGenericRecordType();
        String recordName = type != null ? type.name() : record.getClass().getSimpleName();
        this.fw.append(tabs);
        this.fw.append("{");
        if (this.withComments) {
            this.fw.append("   /* ");
            this.fw.append(recordName);
            if (this.childIndex > 0) {
                this.fw.append(" - index: ");
                this.fw.print(this.childIndex);
            }
            this.fw.append(" */");
        }
        this.fw.println();
        Map<String, Supplier<?>> prop = record.getGenericProperties();
        if (prop != null) {
            int oldChildIndex = this.childIndex;
            this.childIndex = 0;
            prop.forEach(this::writeProp);
            this.childIndex = oldChildIndex;
        }
        this.fw.println();
        List<? extends GenericRecord> list = record.getGenericChildren();
        if (list != null && !list.isEmpty()) {
            ++this.indent;
            this.fw.append(this.tabs());
            if (prop != null && !prop.isEmpty()) {
                this.fw.append(", ");
            }
            this.fw.append("children: [");
            int oldChildIndex = this.childIndex;
            this.childIndex = 0;
            list.forEach(l -> {
                this.writeValue(l);
                ++this.childIndex;
            });
            this.childIndex = oldChildIndex;
            this.fw.println();
            this.fw.append(this.tabs());
            this.fw.append("]");
            this.fw.println();
            --this.indent;
        }
        this.fw.append(tabs);
        this.fw.append("}");
    }

    public void writeError(String errorMsg) {
        this.fw.append("{ error: ");
        this.printObject(errorMsg);
        this.fw.append(" }");
    }

    private void writeProp(String k, Supplier<?> v) {
        boolean isNext;
        boolean bl = isNext = this.childIndex++ > 0;
        if (isNext) {
            this.fw.println();
        }
        this.fw.write(this.tabs());
        this.fw.write(9);
        this.fw.write(isNext ? ", " : "  ");
        this.fw.write(k);
        this.fw.write(": ");
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        this.writeValue(v.get());
        this.childIndex = oldChildIndex;
    }

    private void writeValue(Object o) {
        if (this.childIndex > 0) {
            this.fw.println(',');
        }
        if (o == null) {
            this.fw.write("null");
        } else {
            handler.stream().filter(h -> GenericRecordJsonWriter.matchInstanceOrArray((Class)h.getKey(), o)).findFirst().ifPresent(h -> ((BiConsumer)h.getValue()).accept(this, o));
        }
    }

    private static boolean matchInstanceOrArray(Class key, Object instance) {
        return key.isInstance(instance) || Array.class.equals((Object)key) && instance.getClass().isArray();
    }

    private void printNumber(Object o) {
        Number n = (Number)o;
        this.fw.print(n.toString());
        int size = n instanceof Byte ? 2 : (n instanceof Short ? 4 : (n instanceof Integer ? 8 : (n instanceof Long ? 16 : -1)));
        long l = n.longValue();
        if (this.withComments && size > 0 && (l < 0L || l > 9L)) {
            this.fw.write(" /* 0x");
            this.fw.write(GenericRecordJsonWriter.trimHex(l, size));
            this.fw.write(" */");
        }
    }

    private void printBoolean(Object o) {
        this.fw.write(((Boolean)o).toString());
    }

    private void printList(Object o) {
        this.fw.println('[');
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        ((List)o).forEach(e -> {
            this.writeValue(e);
            ++this.childIndex;
        });
        this.childIndex = oldChildIndex;
        this.fw.write(93);
    }

    private void printGenericRecord(Object o) {
        this.fw.println();
        ++this.indent;
        this.write((GenericRecord)o);
        --this.indent;
    }

    private void printAnnotatedFlag(Object o) {
        GenericRecordUtil.AnnotatedFlag af = (GenericRecordUtil.AnnotatedFlag)o;
        this.fw.write("0x");
        this.fw.write(Long.toHexString(af.getValue().get().longValue()));
        if (this.withComments) {
            this.fw.write(" /* ");
            this.fw.write(af.getDescription());
            this.fw.write(" */ ");
        }
    }

    private void printBytes(Object o) {
        this.fw.write(34);
        this.fw.write(DatatypeConverter.printBase64Binary((byte[])o));
        this.fw.write(34);
    }

    private void printPoint(Object o) {
        Point2D p = (Point2D)o;
        this.fw.write("{ x: " + p.getX() + ", y: " + p.getY() + " }");
    }

    private void printDimension(Object o) {
        Dimension2D p = (Dimension2D)o;
        this.fw.write("{ width: " + p.getWidth() + ", height: " + p.getHeight() + " }");
    }

    private void printRectangle(Object o) {
        Rectangle2D p = (Rectangle2D)o;
        this.fw.write("{ x: " + p.getX() + ", y: " + p.getY() + ", width: " + p.getWidth() + ", height: " + p.getHeight() + " }");
    }

    private void printPath(Object o) {
        PathIterator iter = ((Path2D)o).getPathIterator(null);
        double[] pnts = new double[6];
        this.fw.print("[");
        this.indent += 2;
        String t = this.tabs();
        this.indent -= 2;
        boolean isNext = false;
        while (!iter.isDone()) {
            this.fw.println(isNext ? ", " : "");
            this.fw.print(t);
            isNext = true;
            int segType = iter.currentSegment(pnts);
            this.fw.append("{ type: ");
            switch (segType) {
                case 0: {
                    this.fw.write("'move', x: " + pnts[0] + ", y: " + pnts[1]);
                    break;
                }
                case 1: {
                    this.fw.write("'lineto', x: " + pnts[0] + ", y: " + pnts[1]);
                    break;
                }
                case 2: {
                    this.fw.write("'quad', x1: " + pnts[0] + ", y1: " + pnts[1] + ", x2: " + pnts[2] + ", y2: " + pnts[3]);
                    break;
                }
                case 3: {
                    this.fw.write("'cubic', x1: " + pnts[0] + ", y1: " + pnts[1] + ", x2: " + pnts[2] + ", y2: " + pnts[3] + ", x3: " + pnts[4] + ", y3: " + pnts[5]);
                    break;
                }
                case 4: {
                    this.fw.write("'close'");
                }
            }
            this.fw.append(" }");
            iter.next();
        }
        this.fw.write("]");
    }

    private void printObject(Object o) {
        this.fw.write(34);
        Matcher m = ESC_CHARS.matcher(o.toString());
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String repl;
            String match;
            switch (match = m.group()) {
                case "\n": {
                    repl = "\\\\n";
                    break;
                }
                case "\r": {
                    repl = "\\\\r";
                    break;
                }
                case "\t": {
                    repl = "\\\\t";
                    break;
                }
                case "\b": {
                    repl = "\\\\b";
                    break;
                }
                case "\f": {
                    repl = "\\\\f";
                    break;
                }
                case "\\": {
                    repl = "\\\\\\\\";
                    break;
                }
                case "\"": {
                    repl = "\\\\\"";
                    break;
                }
                default: {
                    repl = "\\\\u" + GenericRecordJsonWriter.trimHex(match.charAt(0), 4);
                }
            }
            m.appendReplacement(sb, repl);
        }
        m.appendTail(sb);
        this.fw.write(sb.toString());
        this.fw.write(34);
    }

    private void printAffineTransform(Object o) {
        AffineTransform xForm = (AffineTransform)o;
        this.fw.write("{ scaleX: " + xForm.getScaleX() + ", shearX: " + xForm.getShearX() + ", transX: " + xForm.getTranslateX() + ", scaleY: " + xForm.getScaleY() + ", shearY: " + xForm.getShearY() + ", transY: " + xForm.getTranslateY() + " }");
    }

    private void printColor(Object o) {
        int rgb = ((Color)o).getRGB();
        this.fw.print(rgb);
        if (this.withComments) {
            this.fw.write(" /* 0x");
            this.fw.write(GenericRecordJsonWriter.trimHex(rgb, 8));
            this.fw.write(" */");
        }
    }

    private void printArray(Object o) {
        this.fw.println('[');
        int length = Array.getLength(o);
        int oldChildIndex = this.childIndex;
        this.childIndex = 0;
        while (this.childIndex < length) {
            this.writeValue(Array.get(o, this.childIndex));
            ++this.childIndex;
        }
        this.childIndex = oldChildIndex;
        this.fw.write(93);
    }

    static String trimHex(long l, int size) {
        String b = Long.toHexString(l);
        int len = b.length();
        return ZEROS.substring(0, Math.max(0, size - len)) + b.substring(Math.max(0, len - size), len);
    }

    static {
        ESC_CHARS = Pattern.compile("[\"\\p{Cntrl}\\\\]");
        handler = new ArrayList<Map.Entry<Class, BiConsumer<GenericRecordJsonWriter, Object>>>();
        char[] t = new char[255];
        Arrays.fill(t, '\t');
        TABS = new String(t);
        GenericRecordJsonWriter.handler(String.class, GenericRecordJsonWriter::printObject);
        GenericRecordJsonWriter.handler(Number.class, GenericRecordJsonWriter::printNumber);
        GenericRecordJsonWriter.handler(Boolean.class, GenericRecordJsonWriter::printBoolean);
        GenericRecordJsonWriter.handler(List.class, GenericRecordJsonWriter::printList);
        GenericRecordJsonWriter.handler(GenericRecord.class, GenericRecordJsonWriter::printGenericRecord);
        GenericRecordJsonWriter.handler(GenericRecordUtil.AnnotatedFlag.class, GenericRecordJsonWriter::printAnnotatedFlag);
        GenericRecordJsonWriter.handler(byte[].class, GenericRecordJsonWriter::printBytes);
        GenericRecordJsonWriter.handler(Point2D.class, GenericRecordJsonWriter::printPoint);
        GenericRecordJsonWriter.handler(Dimension2D.class, GenericRecordJsonWriter::printDimension);
        GenericRecordJsonWriter.handler(Rectangle2D.class, GenericRecordJsonWriter::printRectangle);
        GenericRecordJsonWriter.handler(Path2D.class, GenericRecordJsonWriter::printPath);
        GenericRecordJsonWriter.handler(AffineTransform.class, GenericRecordJsonWriter::printAffineTransform);
        GenericRecordJsonWriter.handler(Color.class, GenericRecordJsonWriter::printColor);
        GenericRecordJsonWriter.handler(Array.class, GenericRecordJsonWriter::printArray);
        GenericRecordJsonWriter.handler(Object.class, GenericRecordJsonWriter::printObject);
    }

    static class AppendableWriter
    extends Writer {
        private Appendable buffer;

        AppendableWriter(Appendable buffer) {
            super(buffer);
            this.buffer = buffer;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(String.valueOf(cbuf), off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer instanceof Flushable) {
                ((Flushable)((Object)this.buffer)).flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            if (this.buffer instanceof Closeable) {
                ((Closeable)((Object)this.buffer)).close();
            }
        }
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    }
}

