/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.hp.octane.integrations.executor.TestsToRunConverterResult;
import com.hp.octane.integrations.executor.TestsToRunConvertersFactory;
import com.hp.octane.integrations.executor.TestsToRunFramework;
import com.hp.octane.plugins.bamboo.octane.utils.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Scanned
@Path(value="/converter-task/convert")
public class FrameworkConverterRestResources {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doTestConvert(@Context HttpServletRequest request, String body) {
        try {
            Map params = JsonHelper.deserialize(body, HashMap.class);
            String rawTests = (String)params.get("testsToRun");
            String framework = (String)params.get("framework");
            String format = (String)params.get("customConverterFormat");
            if (!this.hasPermissions(request)) {
                throw new IllegalArgumentException("Bamboo user does not exist");
            }
            if (StringUtils.isEmpty((String)rawTests)) {
                throw new IllegalArgumentException("'Tests to run' parameter is missing");
            }
            if (StringUtils.isEmpty((String)framework)) {
                throw new IllegalArgumentException("'Framework' parameter is missing");
            }
            TestsToRunFramework testsToRunFramework = TestsToRunFramework.fromValue(framework);
            if (TestsToRunFramework.Custom.equals(testsToRunFramework) && StringUtils.isEmpty((String)format)) {
                throw new IllegalArgumentException("'Format' parameter is missing");
            }
            TestsToRunConverterResult convertResult = TestsToRunConvertersFactory.createConverter(testsToRunFramework).setFormat(format).convert(rawTests, "${bamboo.build.working.directory}", null);
            return Response.ok((Object)("Conversion is successful : " + convertResult.getConvertedTestsString())).build();
        }
        catch (Exception e) {
            return Response.status((int)405).entity((Object)("Failed to convert : " + e.getMessage())).build();
        }
    }

    private boolean hasPermissions(HttpServletRequest request) {
        UserProfile username = ((UserManager)ComponentLocator.getComponent(UserManager.class)).getRemoteUser(request);
        return username != null;
    }
}

