/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/actions")
@Scanned
public class ActionsRestResource {
    @Context
    HttpServletRequest request;
    private UserManager userManager;

    @Path(value="/octane-roots-cache")
    @GET
    @Produces(value={"application/json"})
    public Response getOctaneRootsCache() {
        if (!this.hasPermissions(this.request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user does not have permission").build();
        }
        HashMap clients = new HashMap();
        OctaneSDK.getClients().forEach(client -> {
            ConfigurationService cs = client.getConfigurationService();
            clients.put(cs.getConfiguration().getLocationForLog(), cs.getOctaneRootsCacheCollection());
        });
        return Response.ok(clients).build();
    }

    @Path(value="/octane-roots-cache/clear")
    @GET
    @Produces(value={"text/plain"})
    public Response clearOctaneRootsCache() {
        if (!this.hasPermissions(this.request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user does not have permission").build();
        }
        OctaneSDK.getClients().stream().forEach(oc -> oc.getConfigurationService().resetOctaneRootsCache());
        return Response.ok((Object)"done").build();
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        }
        return this.userManager;
    }

    private boolean hasPermissions(HttpServletRequest request) {
        UserProfile username = this.getUserManager().getRemoteUser(request);
        return username != null && (this.getUserManager().isSystemAdmin(username.getUserKey()) || this.getUserManager().isAdmin(username.getUserKey()));
    }
}

