/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.uft;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UftDiscoveryTaskConfigurator
extends AbstractTaskConfigurator {
    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("workspaceId", taskDefinition.getConfiguration().get("workspaceId"));
        context.put("scmRepositoryId", taskDefinition.getConfiguration().get("scmRepositoryId"));
        context.put("testRunnerId", taskDefinition.getConfiguration().get("testRunnerId"));
        context.put("spaceConfigurationId", taskDefinition.getConfiguration().get("spaceConfigurationId"));
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("workspaceId", params.getString("workspaceId"));
        config.put("scmRepositoryId", params.getString("scmRepositoryId"));
        config.put("testRunnerId", params.getString("testRunnerId"));
        config.put("spaceConfigurationId", params.getString("spaceConfigurationId"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.validateNumericalValue("workspaceId", params.getString("workspaceId"), errorCollection);
        this.validateNumericalValue("scmRepositoryId", params.getString("scmRepositoryId"), errorCollection);
        this.validateNumericalValue("testRunnerId", params.getString("testRunnerId"), errorCollection);
        this.validateRequiredStringValue("spaceConfigurationId", params.getString("spaceConfigurationId"), errorCollection);
    }

    private void validateNumericalValue(String field, String value, ErrorCollection errorCollection) {
        try {
            Long.parseLong(value);
        }
        catch (Exception e) {
            errorCollection.addError(field, "Expected numerical value");
        }
    }

    private void validateRequiredStringValue(String field, String value, ErrorCollection errorCollection) {
        if (StringUtils.isEmpty((String)value)) {
            errorCollection.addError(field, "Value is missing");
        }
    }
}

