/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.mqmtestresults;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.SystemProperty;
import com.hp.octane.integrations.dto.tests.TestRun;
import com.hp.octane.integrations.dto.tests.TestRunResult;
import com.hp.octane.integrations.dto.tests.TestsResult;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MqmTestResultsReporterTask
implements TaskType {
    public static final String DEFAULT_GLOB = "**/*octaneResults*.xml";
    private TestCollationService testCollationService;

    public MqmTestResultsReporterTask(TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        if (!taskContext.isFinalising()) {
            buildLogger.addBuildLogEntry("***************ALM octane test reporter task must be final*************");
        }
        File targetDirectory = Paths.get(taskContext.getWorkingDirectory().getAbsolutePath(), "ALM_Octane_Test_Results", "Build_" + taskContext.getBuildContext().getBuildNumber()).toFile();
        targetDirectory.mkdirs();
        try {
            MqmTestResultsReporterTask.addLogEntry(buildLogger, "Collecting results");
            String pattern = (String)taskContext.getConfigurationMap().get((Object)"testResultFilePattern");
            Path found = MqmTestResultsReporterTask.findResultFile(taskContext.getWorkingDirectory().getAbsolutePath(), pattern, buildLogger, taskContext.getBuildContext().getBuildResult().getTasksStartDate());
            if (found == null) {
                MqmTestResultsReporterTask.addLogEntry(buildLogger, "No appropriate test result file is found");
                return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
            }
            MqmTestResultsReporterTask.addLogEntry(buildLogger, "Test result file is found : " + found);
            MqmTestResultsReporterTask.copyTestResults(found, targetDirectory.getAbsolutePath(), buildLogger);
            boolean publishToBamboo = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"publishToBamboo"));
            if (publishToBamboo) {
                this.publishToBamboo(taskContext, found.toFile(), buildLogger);
            }
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        catch (Exception e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            buildLogger.addBuildLogEntry("Exception running ALM Octane test reporter task : " + e.getMessage() + ", " + errors.toString());
            e.printStackTrace();
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
    }

    private static void addLogEntry(BuildLogger buildLogger, String message) {
        buildLogger.addBuildLogEntry("Micro Focus ALM Octane test reporter: " + message);
    }

    private static Path findResultFile(String workingDirectoryPath, String userPattern, final BuildLogger buildLogger, final Date taskStartDate) throws IOException {
        Path startDir = Paths.get(workingDirectoryPath, new String[0]);
        FileSystem fs = FileSystems.getDefault();
        if (StringUtils.isEmpty((String)userPattern)) {
            userPattern = DEFAULT_GLOB;
        }
        MqmTestResultsReporterTask.addLogEntry(buildLogger, "Using search pattern : " + userPattern);
        userPattern = "{" + userPattern + "}";
        final PathMatcher matcher = fs.getPathMatcher("glob:" + userPattern);
        final PathMatcher exclude = fs.getPathMatcher("glob:**/ALM_Octane_Test_Results/**");
        final ArrayList finalCollection = new ArrayList();
        SimpleFileVisitor<Path> matcherVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attribs) {
                if (matcher.matches(file.toAbsolutePath()) && !exclude.matches(file.toAbsolutePath())) {
                    File tempFile = file.toFile();
                    boolean isFileRecentEnough = this.isFileRecentEnough(tempFile);
                    if (!isFileRecentEnough) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        String msg = String.format("File %s was ignored because it was modified (%s) before task started (%s)", file, dateFormat.format(new Date(tempFile.lastModified())), dateFormat.format(taskStartDate));
                        MqmTestResultsReporterTask.addLogEntry(buildLogger, msg);
                    } else {
                        finalCollection.add(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isFileRecentEnough(File file) {
                return file.lastModified() >= taskStartDate.getTime() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue();
            }
        };
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)matcherVisitor);
        return finalCollection.isEmpty() ? null : (Path)finalCollection.get(0);
    }

    private static void copyTestResults(Path source, String targetDirectoryPath, BuildLogger buildLogger) throws IOException {
        String targetFilePath = targetDirectoryPath + File.separator + "mqmTests.xml";
        File newTestResultsFile = new File(targetFilePath);
        MqmTestResultsReporterTask.addLogEntry(buildLogger, "Copying " + source.getFileName() + " to " + newTestResultsFile.getAbsolutePath());
        FileUtils.copyFile((File)source.toFile(), (File)newTestResultsFile);
    }

    private void publishToBamboo(TaskContext taskContext, File file, BuildLogger buildLogger) {
        MqmTestResultsReporterTask.addLogEntry(buildLogger, "Publish test results to Bamboo ");
        final TestsResult result = DefaultOctaneConverter.getDTOFactory().dtoFromXmlFile(file, TestsResult.class);
        this.testCollationService.collateTestResults(taskContext, new TestReportProvider(){

            @NotNull
            public TestCollectionResult getTestCollectionResult() {
                Map<TestState, List<TestResults>> map = result.getTestRuns().stream().map(t -> this.convertToBambooResult((TestRun)t)).collect(Collectors.groupingBy(TestResults::getState));
                TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
                if (map.containsKey(TestState.SUCCESS)) {
                    builder.addSuccessfulTestResults((Collection)map.get(TestState.SUCCESS));
                }
                if (map.containsKey(TestState.FAILED)) {
                    builder.addFailedTestResults((Collection)map.get(TestState.FAILED));
                }
                if (map.containsKey(TestState.SKIPPED)) {
                    builder.addSkippedTestResults((Collection)map.get(TestState.SKIPPED));
                }
                return builder.build();
            }

            private TestResults convertToBambooResult(TestRun run) {
                String className = StringUtils.isNotEmpty((String)run.getPackageName()) && StringUtils.isNotEmpty((String)run.getClassName()) ? run.getPackageName() + "." + run.getClassName() : run.getClassName();
                TestResults bambooRun = new TestResults(className, run.getTestName(), Long.valueOf(run.getDuration()));
                if (run.getError() != null) {
                    String errorContent = StringUtils.isNotEmpty((String)run.getError().getStackTrace()) ? run.getError().getStackTrace() : (StringUtils.isNotEmpty((String)run.getError().getErrorType()) ? run.getError().getErrorType() + ": " + run.getError().getErrorMessage() : run.getError().getErrorMessage());
                    TestCaseResultErrorImpl er = new TestCaseResultErrorImpl(errorContent);
                    bambooRun.addError((TestCaseResultError)er);
                }
                TestState state = null;
                if (TestRunResult.PASSED.equals((Object)run.getResult())) {
                    state = TestState.SUCCESS;
                } else if (TestRunResult.FAILED.equals((Object)run.getResult())) {
                    state = TestState.FAILED;
                } else if (TestRunResult.SKIPPED.equals((Object)run.getResult())) {
                    state = TestState.SKIPPED;
                }
                bambooRun.setState(state);
                return bambooRun;
            }
        });
    }
}

