/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.hp.octane.integrations.dto.tests.BuildContext;
import com.hp.octane.integrations.dto.tests.TestField;
import com.hp.octane.integrations.dto.tests.TestRun;
import com.hp.octane.integrations.dto.tests.TestRunResult;
import com.hp.octane.integrations.dto.tests.TestsResult;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import com.hp.octane.plugins.bamboo.octane.HPRunnerType;
import com.hp.octane.plugins.bamboo.octane.HPRunnerTypeUtils;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class MqmResultsHelper {
    private static StorageLocationService storageLocationService;
    private static DefaultOctaneConverter CONVERTER;
    private static final Logger log;

    private static StorageLocationService getStorageLocationService() {
        if (storageLocationService == null) {
            storageLocationService = (StorageLocationService)ComponentLocator.getComponent(StorageLocationService.class);
        }
        return storageLocationService;
    }

    public static File getBuildResultDirectory(PlanKey plan) {
        return MqmResultsHelper.getStorageLocationService().getBuildResultsDirectory((Key)plan);
    }

    public static Path getMqmResultFilePath(PlanResultKey planResultKey) {
        File dirFile = MqmResultsHelper.getBuildResultDirectory(planResultKey.getPlanKey());
        return Paths.get(dirFile.getAbsolutePath(), "ALM_Octane_Test_Results", "Build_" + planResultKey.getBuildNumber(), "mqmTests.xml");
    }

    public static Path getScmDataFilePath(PlanResultKey planResultKey) {
        File dirFile = MqmResultsHelper.getBuildResultDirectory(planResultKey.getPlanKey());
        return Paths.get(dirFile.getAbsolutePath(), "ALM_Octane_Test_Results", "Build_" + planResultKey.getBuildNumber(), "scmData.xml");
    }

    public static Path getDiscoveryFilePath(PlanResultKey planResultKey) {
        File dirFile = MqmResultsHelper.getBuildResultDirectory(planResultKey.getPlanKey());
        return Paths.get(dirFile.getAbsolutePath(), "_discovery_results", "Build_" + planResultKey.getBuildNumber(), "uft_discovery_result_build_" + planResultKey.getBuildNumber());
    }

    public static InputStream generateTestResultStream(com.atlassian.bamboo.v2.build.BuildContext buildContext, String jobId, String buildId) {
        List<TestRun> filteredTestRuns;
        InputStream output = null;
        HPRunnerType runnerType = HPRunnerTypeUtils.getHPRunnerType(buildContext.getRuntimeTaskDefinitions());
        CurrentBuildResult results = buildContext.getBuildResult();
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        if (results.getFailedTestResults() != null) {
            for (TestResults currentTestResult : results.getFailedTestResults()) {
                testRuns.add(CONVERTER.getTestRunFromTestResult(buildContext, runnerType, currentTestResult, TestRunResult.FAILED, results.getTasksStartDate().getTime()));
            }
        }
        if (results.getSkippedTestResults() != null) {
            for (TestResults currentTestResult : results.getSkippedTestResults()) {
                testRuns.add(CONVERTER.getTestRunFromTestResult(buildContext, runnerType, currentTestResult, TestRunResult.SKIPPED, results.getTasksStartDate().getTime()));
            }
        }
        if (results.getSuccessfulTestResults() != null) {
            for (TestResults currentTestResult : results.getSuccessfulTestResults()) {
                testRuns.add(CONVERTER.getTestRunFromTestResult(buildContext, runnerType, currentTestResult, TestRunResult.PASSED, results.getTasksStartDate().getTime()));
            }
        }
        if (!(filteredTestRuns = MqmResultsHelper.filterTestToIgnoreFromResults(testRuns, buildContext)).isEmpty()) {
            List<TestField> testFields = runnerType.getTestFields();
            BuildContext context = CONVERTER.getBuildContext("to-be-filled-in-SDK", jobId, buildId);
            TestsResult testsResult = DefaultOctaneConverter.getDTOFactory().newDTO(TestsResult.class).setTestRuns(filteredTestRuns).setBuildContext(context).setTestFields(testFields);
            output = DefaultOctaneConverter.getDTOFactory().dtoToXmlStream(testsResult);
        }
        return output;
    }

    private static List<TestRun> filterTestToIgnoreFromResults(List<TestRun> testRuns, com.atlassian.bamboo.v2.build.BuildContext buildContext) {
        HashSet testsToIgnoreList = new HashSet();
        testsToIgnoreList.addAll(MqmResultsHelper.getTestToIgnoreFromVariable((VariableDefinitionContext)buildContext.getVariableContext().getEffectiveVariables().get("octaneIgnoreTestsByName")));
        testsToIgnoreList.addAll(MqmResultsHelper.getTestToIgnoreFromVariable((VariableDefinitionContext)buildContext.getVariableContext().getEffectiveVariables().get("octaneIgnoreTestsByNameGlobal")));
        List<TestRun> returnVal = testRuns.stream().filter(x -> !testsToIgnoreList.contains(x.getTestName())).collect(Collectors.toList());
        return returnVal;
    }

    private static List getTestToIgnoreFromVariable(VariableDefinitionContext testsToIgnoreVar) {
        if (testsToIgnoreVar == null || testsToIgnoreVar.getValue() == null || testsToIgnoreVar.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        String[] testsToIgnore = testsToIgnoreVar.getValue().split(";");
        return Arrays.asList(testsToIgnore);
    }

    public static synchronized void saveStreamToFile(InputStream is, PlanResultKey planResultKey, Path targetFilePath) {
        try {
            if (is == null) {
                targetFilePath.toFile().createNewFile();
            } else {
                targetFilePath.getParent().toFile().mkdirs();
                Files.copy(is, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            log.error("Failed to saveToTestResultFile of " + planResultKey.toString(), (Throwable)e);
        }
    }

    static {
        CONVERTER = DefaultOctaneConverter.getInstance();
        log = SDKBasedLoggerProvider.getLogger(MqmResultsHelper.class);
    }
}

