/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.artifact.FileSystemArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.TrampolineArtifactFileData;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.sal.api.component.ComponentLocator;
import com.google.common.io.Files;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.plugins.bamboo.octane.MqmResultsHelper;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;

public class ArtifactsHelper {
    private static final Logger log = SDKBasedLoggerProvider.getLogger(ArtifactsHelper.class);
    private static ArtifactLinkManager artifactLinkManager = (ArtifactLinkManager)ComponentLocator.getComponent(ArtifactLinkManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerArtifactDefinition(@NotNull Job job, String name, String pattern) {
        block8: {
            if (job == null || StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)pattern)) {
                return false;
            }
            String HTTP_REQUEST_IS_MUTATIVE_KEY = "bamboo.http.request.isMutative";
            boolean isMutativeKeyWasChanged = false;
            ArtifactDefinitionManager artifactDefinitionManager = (ArtifactDefinitionManager)ComponentLocator.getComponent(ArtifactDefinitionManager.class);
            if (artifactDefinitionManager.findArtifactDefinition((ImmutablePlan)job, name) != null) break block8;
            ArtifactDefinitionImpl artifactDefinition = new ArtifactDefinitionImpl(name, "", pattern);
            artifactDefinition.setProducerJob(job);
            if (XsrfUtils.areMutativeGetsForbiddenByConfig() && !XsrfUtils.noRequestOrRequestCanMutateState() && !RequestCacheThreadLocal.canRequestMutateState()) {
                isMutativeKeyWasChanged = true;
                RequestCacheThreadLocal.getRequestCache().put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
            }
            artifactDefinitionManager.saveArtifactDefinition((ArtifactDefinition)artifactDefinition);
            if (isMutativeKeyWasChanged) {
                RequestCacheThreadLocal.getRequestCache().put(HTTP_REQUEST_IS_MUTATIVE_KEY, false);
            }
            boolean bl = true;
            return bl;
        }
        try {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("Failed to registerArtifactDefinition : " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static UftTestDiscoveryResult getTestDiscovery(MutableArtifact artifact, PlanResultKey planResultKey) {
        try {
            File f;
            ArtifactLinkDataProvider dataProvider = artifactLinkManager.getArtifactLinkDataProvider((Artifact)artifact);
            if (dataProvider instanceof FileSystemArtifactLinkDataProvider) {
                f = ArtifactsHelper.getDiscoveryFile((FileSystemArtifactLinkDataProvider)dataProvider);
            } else {
                f = MqmResultsHelper.getDiscoveryFilePath(planResultKey).toFile();
                ArtifactsHelper.getDiscoveryFile(dataProvider, f, "");
            }
            if (f != null && f.exists()) {
                return UftTestDiscoveryResult.readFromFile(f);
            }
        }
        catch (IOException e) {
            ArtifactsHelper.logAndThrow(e, "Failed to download artifacts");
        }
        return null;
    }

    private static File getDiscoveryFile(FileSystemArtifactLinkDataProvider dataProvider) {
        return Arrays.asList(Objects.requireNonNull(dataProvider.getFile().listFiles())).stream().filter(File::isFile).filter(f -> f.getName().contains("uft_discovery_result_build")).findFirst().orElse(null);
    }

    private static void getDiscoveryFile(ArtifactLinkDataProvider dataProvider, File targetDir, String startFrom) {
        for (ArtifactFileData data : Objects.requireNonNull(dataProvider).listObjects(startFrom)) {
            try {
                if (!(data instanceof TrampolineArtifactFileData)) continue;
                TrampolineArtifactFileData trampolineData = (TrampolineArtifactFileData)data;
                if ((data = trampolineData.getDelegate()).getFileType().equals((Object)ArtifactFileData.FileType.REGULAR_FILE)) {
                    if (data.getUrl() == null) continue;
                    FileUtils.copyURLToFile((URL)new URL(data.getUrl()), (File)targetDir);
                    continue;
                }
                ArtifactsHelper.getDiscoveryFile(dataProvider, targetDir, trampolineData.getTag());
            }
            catch (IOException e) {
                ArtifactsHelper.logAndThrow(e, "Failed to download artifacts to " + targetDir);
            }
        }
    }

    public static void copyArtifactTo(File targetDir, MutableArtifact artifact) {
        targetDir.mkdirs();
        ArtifactLinkDataProvider dataProvider = artifactLinkManager.getArtifactLinkDataProvider((Artifact)artifact);
        if (dataProvider instanceof FileSystemArtifactLinkDataProvider) {
            ArtifactsHelper.downloadAllArtifactsTo((FileSystemArtifactLinkDataProvider)dataProvider, targetDir);
        } else {
            ArtifactsHelper.downloadAllArtifactsTo(dataProvider, targetDir, "");
        }
    }

    private static void downloadAllArtifactsTo(ArtifactLinkDataProvider dataProvider, File targetDir, String startFrom) {
        for (ArtifactFileData data : Objects.requireNonNull(dataProvider).listObjects(startFrom)) {
            try {
                if (!(data instanceof TrampolineArtifactFileData)) continue;
                TrampolineArtifactFileData trampolineData = (TrampolineArtifactFileData)data;
                if ((data = trampolineData.getDelegate()).getFileType().equals((Object)ArtifactFileData.FileType.REGULAR_FILE)) {
                    String fileName = Paths.get(data.getName(), new String[0]).toFile().getName();
                    FileUtils.copyURLToFile((URL)new URL(data.getUrl()), (File)Paths.get(targetDir.getPath(), fileName).toFile());
                    continue;
                }
                ArtifactsHelper.downloadAllArtifactsTo(dataProvider, targetDir, trampolineData.getTag());
            }
            catch (IOException e) {
                ArtifactsHelper.logAndThrow(e, "Failed to download artifacts to " + targetDir);
            }
        }
    }

    private static void downloadAllArtifactsTo(FileSystemArtifactLinkDataProvider dataProvider, File targetDir) {
        Optional.ofNullable(dataProvider.getFile().listFiles()).map(Arrays::asList).ifPresent(list -> list.forEach(file -> {
            try {
                if (file.isFile()) {
                    Files.copy((File)file, (File)Paths.get(targetDir.getPath(), file.getName()).toFile());
                } else if (!file.getName().equals(".") && !file.getName().equals("..")) {
                    FileUtils.copyDirectory((File)dataProvider.getFile(), (File)targetDir);
                }
            }
            catch (IOException e) {
                ArtifactsHelper.logAndThrow(e, "Failed to download artifacts to " + targetDir);
            }
        }));
    }

    private static void logAndThrow(Exception e, String message) {
        log.error(message, (Throwable)e);
        throw new RuntimeException(message, e);
    }
}

