/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.plugins.PreChainAction;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.plugins.bamboo.listener.BaseListener;
import com.hp.octane.plugins.bamboo.listener.MultibranchHelper;
import com.hp.octane.plugins.bamboo.listener.ParametersHelper;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.util.Collections;

public class OctanePreChainAction
extends BaseListener
implements PreChainAction {
    public void execute(Chain chain, ChainExecution chainExecution) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        this.log.info("Executing chain " + chain.getName() + " build id " + chainExecution.getBuildIdentifier().getPlanResultKey().getKey() + " build number " + chainExecution.getBuildIdentifier().getBuildNumber());
        CIEvent event = CONVERTER.getEventWithDetails(chainExecution.getPlanResultKey().getPlanKey().getKey(), chainExecution.getBuildIdentifier().getPlanResultKey().getKey(), chain.getName(), CIEventType.STARTED, chainExecution.getStartTime() != null ? chainExecution.getStartTime().getTime() : System.currentTimeMillis(), chainExecution.getAverageDuration(), Collections.singletonList(CONVERTER.getCause(chainExecution.getTriggerReason())), String.valueOf(chainExecution.getBuildIdentifier().getBuildNumber()), PhaseType.INTERNAL);
        MultibranchHelper.enrichMultiBranchEvent((ImmutableChain)chain, event);
        BuildContext buildContext = (BuildContext)chainExecution.getBuildIdentifier();
        ParametersHelper.addParametersToEvent(event, buildContext);
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(event));
    }
}

