/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class SdkStringUtils {
    public static String strip(String str, String stripChars) {
        if (SdkStringUtils.isEmpty(str)) {
            return str;
        }
        return SdkStringUtils.stripEnd(SdkStringUtils.stripStart(str, stripChars), stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            int start;
            if (stripChars == null) {
                for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
            return str.substring(start);
        }
        return str;
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str != null && (end = str.length()) != 0) {
            if (stripChars == null) {
                while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                if (stripChars.length() == 0) {
                    return str;
                }
                while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
            return str.substring(0, end);
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !SdkStringUtils.isEmpty(str);
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (buffer.length() != 0) {
                buffer.append(separator);
            }
            buffer.append(iterator.next().toString());
        }
        return buffer.toString();
    }

    public static String join(String[] collection, String separator) {
        return SdkStringUtils.join(Arrays.asList(collection), separator);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }
}

