/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.ScmResourceFile;
import com.hp.octane.integrations.uft.items.UftParameterDirection;
import com.hp.octane.integrations.uft.items.UftTestAction;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.uft.items.UftTestParameter;
import com.hp.octane.integrations.uft.items.UftTestType;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UftTestDiscoveryUtils {
    private static final Logger logger = LogManager.getLogger(UftTestDiscoveryUtils.class);
    private static final String STFileExtention = ".st";
    private static final String QTPFileExtention = ".tsp";
    private static final String XLSXExtention = ".xlsx";
    private static final String XLSExtention = ".xls";
    private static final String GUI_TEST_FILE = "test.tsp";
    private static final String API_ACTIONS_FILE = "actions.xml";
    private static final String RESOURCE_MTR_FILE = "resource.mtr";
    private static final Set<String> SKIP_FOLDERS = Stream.of("_discovery_results").collect(Collectors.toSet());
    public static final String ACTION_0 = "action0";
    public static final String UFT_PARAM_ARG_DEFAULT_VALUE_NODE_NAME = "ArgDefaultValue";
    public static final String UFT_PARAM_ARG_NAME_NODE_NAME = "ArgName";
    public static final String UFT_PARAM_ARGUMENTS_COLLECTION_NODE_NAME = "ArgumentsCollection";
    public static final String UFT_ACTION_DESCRIPTION_NODE_NAME = "Description";
    public static final String UFT_COMPONENT_NODE_NAME = "Component";
    public static final String UFT_DEPENDENCY_NODE_NAME = "Dependency";
    public static final String UFT_ACTION_LOGICAL_ATTR = "Logical";
    public static final String UFT_ACTION_KIND_ATTR = "Kind";
    public static final String UFT_ACTION_TYPE_ATTR = "Type";
    public static final String UFT_ACTION_SCOPE_ATTR = "Scope";
    public static final String UFT_ACTION_KIND_VALUE = "16";
    public static final String UFT_ACTION_TYPE_VALUE = "1";
    public static final String UFT_ACTION_SCOPE_VALUE = "0";

    public static UftTestDiscoveryResult doFullDiscovery(File root) {
        return UftTestDiscoveryUtils.doFullDiscovery(root, TestingToolType.UFT);
    }

    public static UftTestDiscoveryResult doFullDiscovery(File root, TestingToolType testingToolType) {
        logger.info("Full sync requested for: {}, path: {}, ", (Object)testingToolType, (Object)root.getAbsolutePath());
        UftTestDiscoveryResult result = new UftTestDiscoveryResult();
        UftTestDiscoveryUtils.scanFileSystemRecursively(root, root, result, testingToolType);
        result.setFullScan(true);
        result.setTestingToolType(testingToolType);
        return result;
    }

    private static void scanFileSystemRecursively(File root, File dirPath, UftTestDiscoveryResult discoveryResult, TestingToolType testingToolType) {
        UftTestType testType;
        File[] fileArray;
        if (dirPath.isDirectory() && SKIP_FOLDERS.contains(dirPath.getName())) {
            return;
        }
        if (dirPath.isDirectory()) {
            fileArray = dirPath.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = dirPath;
        }
        File[] paths = fileArray;
        UftTestType uftTestType = testType = paths != null ? UftTestDiscoveryUtils.isUftTestFolder(paths) : UftTestType.None;
        if (!testType.isNone()) {
            if (!TestingToolType.MBT.equals((Object)testingToolType) || !UftTestType.API.equals((Object)testType)) {
                AutomatedTest test = UftTestDiscoveryUtils.createAutomatedTest(root, dirPath, testType, testingToolType);
                discoveryResult.getAllTests().add(test);
            }
        } else if (paths != null) {
            for (File path : paths) {
                if (path.isDirectory()) {
                    UftTestDiscoveryUtils.scanFileSystemRecursively(root, path, discoveryResult, testingToolType);
                    continue;
                }
                if (!UftTestDiscoveryUtils.isUftDataTableFile(path.getName())) continue;
                ScmResourceFile dataTable = UftTestDiscoveryUtils.createDataTable(root, path);
                discoveryResult.getAllScmResourceFiles().add(dataTable);
            }
        }
    }

    public static ScmResourceFile createDataTable(File root, File path) {
        ScmResourceFile resourceFile = new ScmResourceFile();
        resourceFile.setName(path.getName());
        resourceFile.setRelativePath(UftTestDiscoveryUtils.getRelativePath(root, path));
        resourceFile.setOctaneStatus(OctaneStatus.NEW);
        return resourceFile;
    }

    public static boolean isUftDataTableFile(String path) {
        String loweredPath = path.toLowerCase();
        return loweredPath.endsWith(XLSXExtention) || loweredPath.endsWith(XLSExtention);
    }

    public static UftTestType isUftTestFolder(File[] paths) {
        if (paths == null) {
            return UftTestType.None;
        }
        for (File path : paths) {
            if (path.getName().endsWith(STFileExtention)) {
                return UftTestType.API;
            }
            if (!path.getName().endsWith(QTPFileExtention)) continue;
            return UftTestType.GUI;
        }
        return UftTestType.None;
    }

    public static boolean isUftActionFile(String path) {
        String loweredPath = path.toLowerCase();
        return loweredPath.endsWith(RESOURCE_MTR_FILE);
    }

    public static boolean isTestMainFilePath(String path) {
        return !UftTestDiscoveryUtils.getUftTestType(path).isNone();
    }

    public static UftTestType getUftTestType(String testMainFilePath) {
        String lowerPath = testMainFilePath.toLowerCase();
        if (lowerPath.endsWith(QTPFileExtention)) {
            return UftTestType.GUI;
        }
        if (lowerPath.endsWith(STFileExtention) || lowerPath.endsWith(API_ACTIONS_FILE)) {
            return UftTestType.API;
        }
        return UftTestType.None;
    }

    public static File getTestFolderForTestMainFile(String path) {
        if (UftTestDiscoveryUtils.isTestMainFilePath(path)) {
            File file = new File(path);
            File parent = file.getParentFile();
            return parent;
        }
        return null;
    }

    public static AutomatedTest createAutomatedTest(File root, File dirPath, UftTestType testType, TestingToolType testingToolType) {
        AutomatedTest test = new AutomatedTest();
        test.setName(dirPath.getName());
        String relativePath = UftTestDiscoveryUtils.getRelativePath(root, dirPath);
        String packageName = relativePath.length() != dirPath.getName().length() ? relativePath.substring(0, relativePath.length() - dirPath.getName().length() - 1) : "";
        test.setPackage(packageName);
        test.setExecutable(true);
        test.setUftTestType(testType);
        Document testDocument = UftTestDiscoveryUtils.getDocument(dirPath, testType);
        String description = UftTestDiscoveryUtils.getTestDescription(testDocument, testType);
        description = UftTestDiscoveryUtils.convertToHtmlFormatIfRequired(description);
        test.setDescription(description);
        test.setOctaneStatus(OctaneStatus.NEW);
        if (TestingToolType.MBT.equals((Object)testingToolType) && UftTestType.GUI.equals((Object)testType)) {
            String actionPathPrefix = UftTestDiscoveryUtils.getActionPathPrefix(test, false);
            test.setActions(UftTestDiscoveryUtils.parseActionsAndParameters(testDocument, actionPathPrefix, test.getName(), dirPath));
        }
        return test;
    }

    protected static String getActionPathPrefix(AutomatedTest test, boolean orgPath) {
        return UftTestDiscoveryUtils.getTestPathPrefix(test, orgPath) + "\\%s:%s";
    }

    protected static String getTestPathPrefix(AutomatedTest test, boolean orgPath) {
        String testPackage = orgPath ? test.getOldPackage() : test.getPackage();
        String testName = orgPath ? test.getOldName() : test.getName();
        return (SdkStringUtils.isEmpty(testPackage) ? "" : testPackage + "\\") + testName;
    }

    public static String convertToHtmlFormatIfRequired(String description) {
        if (description == null || !description.contains("\n")) {
            return description;
        }
        String[] lines = description.split("\n");
        StringBuilder sb = new StringBuilder(description.length() + lines.length * 10 + 30);
        sb.append("<html><body>");
        for (String line : lines) {
            sb.append("<p>");
            sb.append(line);
            sb.append("</p>");
            sb.append("\n");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private static String getRelativePath(File root, File path) {
        String testPath = path.getPath();
        String rootPath = root.getPath();
        String relativePath = testPath.replace(rootPath, "");
        relativePath = SdkStringUtils.strip(relativePath, "\\/");
        relativePath = relativePath.replaceAll("/", "\\\\");
        return relativePath;
    }

    public static String getTestDescription(Document testDocument, UftTestType testType) {
        if (Objects.isNull(testDocument) || testType.isNone()) {
            return null;
        }
        String description = UftTestType.GUI.equals((Object)testType) ? UftTestDiscoveryUtils.getTestDescriptionFromGuiTest(testDocument) : UftTestDiscoveryUtils.getTestDescriptionFromAPITest(testDocument);
        if (description != null) {
            description = description.trim();
        }
        return description;
    }

    private static String getTestDescriptionFromAPITest(Document document) {
        NodeList actions = document.getElementsByTagName("Action");
        for (int temp = 0; temp < actions.getLength(); ++temp) {
            Node nNode = actions.item(temp);
            NamedNodeMap attributes = nNode.getAttributes();
            Node internalNameAttr = attributes.getNamedItem("internalName");
            if (internalNameAttr == null || !"MainAction".equals(internalNameAttr.getNodeValue())) continue;
            return attributes.getNamedItem("description").getNodeValue();
        }
        return null;
    }

    private static String getTestDescriptionFromGuiTest(Document document) {
        return document.getElementsByTagName(UFT_ACTION_DESCRIPTION_NODE_NAME).item(0).getTextContent();
    }

    public static String extractXmlContentFromTspFile(InputStream stream) throws IOException {
        POIFSFileSystem poiFS = new POIFSFileSystem(stream);
        DirectoryNode root = poiFS.getRoot();
        String xmlData = "";
        for (Entry entry : root) {
            String name = entry.getName();
            if (!"ComponentInfo".equals(name)) continue;
            if (entry instanceof DirectoryEntry) {
                System.out.println(entry);
                continue;
            }
            if (!(entry instanceof DocumentEntry)) continue;
            byte[] content = new byte[((DocumentEntry)entry).getSize()];
            int readBytes = poiFS.createDocumentInputStream("ComponentInfo").read(content);
            if (readBytes < content.length) {
                logger.warn("expected to read " + content.length + " bytes, but read and stopped after " + readBytes);
            }
            String fromUnicodeLE = StringUtil.getFromUnicodeLE(content);
            xmlData = fromUnicodeLE.substring(fromUnicodeLE.indexOf(60)).replaceAll("\u0000", "");
        }
        return xmlData;
    }

    public static Document getDocument(File dirPath, UftTestType testType) {
        if (Objects.isNull(dirPath) || !dirPath.exists()) {
            logger.error("test path is expected to be non null or exist");
            return null;
        }
        try {
            if (UftTestType.GUI.equals((Object)testType)) {
                return UftTestDiscoveryUtils.getGuiTestDocument(dirPath);
            }
            return UftTestDiscoveryUtils.getApiTestDocument(dirPath);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Failed to create document for path: {}, test type: {}", (Object)dirPath.getPath(), (Object)testType.name(), (Object)e);
            return null;
        }
    }

    private static Document getGuiTestDocument(File dirPath) throws IOException, ParserConfigurationException, SAXException {
        File tspTestFile = UftTestDiscoveryUtils.getFileIfExist(dirPath, GUI_TEST_FILE);
        if (tspTestFile == null) {
            return null;
        }
        FileInputStream is = new FileInputStream(tspTestFile);
        String xmlContent = UftTestDiscoveryUtils.extractXmlContentFromTspFile(is);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
    }

    private static Document getApiTestDocument(File dirPath) throws ParserConfigurationException, IOException, SAXException {
        File actionsFile = UftTestDiscoveryUtils.getFileIfExist(dirPath, API_ACTIONS_FILE);
        if (actionsFile == null) {
            return null;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(actionsFile);
    }

    private static File getFileIfExist(File dirPath, String fileName) {
        if (SystemUtils.IS_OS_LINUX) {
            Optional<File> optionalFile = Arrays.stream(dirPath.listFiles()).filter(file -> file.getName().equalsIgnoreCase(fileName)).findFirst();
            if (optionalFile.isPresent()) {
                return optionalFile.get();
            }
            logger.warn("File {} does not exist", (Object)(dirPath.getAbsolutePath() + File.separator + fileName));
        } else {
            File file2 = new File(dirPath, fileName);
            if (file2.exists()) {
                return file2;
            }
            logger.warn("File {} does not exist", (Object)file2.getAbsolutePath());
        }
        return null;
    }

    private static List<UftTestAction> parseActionsAndParameters(Document document, String actionPathPrefix, String testName, File dirPath) {
        ArrayList<UftTestAction> actions = new ArrayList<UftTestAction>();
        if (Objects.isNull(document)) {
            logger.warn("received null gui test document, actions will not be parsed");
        } else {
            Map<String, UftTestAction> actionMap = UftTestDiscoveryUtils.parseActionComponents(document, testName);
            UftTestDiscoveryUtils.fillActionsLogicalName(document, actionMap, actionPathPrefix);
            actions.addAll(actionMap.values());
            try {
                UftTestDiscoveryUtils.readParameters(dirPath, actionMap);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error("failed to parse action's parameters", (Throwable)e);
            }
        }
        return actions;
    }

    private static Map<String, UftTestAction> parseActionComponents(Document document, String testName) {
        HashMap<String, UftTestAction> actionMap = new HashMap<String, UftTestAction>();
        NodeList componentNodes = document.getElementsByTagName(UFT_COMPONENT_NODE_NAME);
        for (int i = 0; i < componentNodes.getLength(); ++i) {
            Node componentNode = componentNodes.item(i);
            String actionName = componentNode.getTextContent();
            if (actionName.equalsIgnoreCase(ACTION_0)) continue;
            UftTestAction action = new UftTestAction();
            action.setName(actionName);
            action.setTestName(testName);
            actionMap.put(actionName, action);
        }
        return actionMap;
    }

    private static void fillActionsLogicalName(Document document, Map<String, UftTestAction> actionMap, String actionPathPrefix) {
        NodeList dependencyNodes = document.getElementsByTagName(UFT_DEPENDENCY_NODE_NAME);
        for (int i = 0; i < dependencyNodes.getLength(); ++i) {
            String dependencyStr;
            String actionName;
            Node dependencyNode = dependencyNodes.item(i);
            NamedNodeMap attributes = dependencyNode.getAttributes();
            String type = attributes.getNamedItem(UFT_ACTION_TYPE_ATTR).getNodeValue();
            String kind = attributes.getNamedItem(UFT_ACTION_KIND_ATTR).getNodeValue();
            String scope = attributes.getNamedItem(UFT_ACTION_SCOPE_ATTR).getNodeValue();
            String logicalName = attributes.getNamedItem(UFT_ACTION_LOGICAL_ATTR).getNodeValue();
            if (!type.equals(UFT_ACTION_TYPE_VALUE) || !kind.equals(UFT_ACTION_KIND_VALUE) || !scope.equals(UFT_ACTION_SCOPE_VALUE) || !SdkStringUtils.isNotEmpty(logicalName) || (actionName = (dependencyStr = dependencyNode.getTextContent()).substring(0, dependencyStr.indexOf("\\"))).equalsIgnoreCase(ACTION_0)) continue;
            UftTestAction action = actionMap.get(actionName);
            action.setLogicalName(logicalName);
            UftTestDiscoveryUtils.setActionPath(action, actionPathPrefix);
        }
    }

    private static void setActionPath(UftTestAction action, String actionPathPrefix) {
        String actionName = SdkStringUtils.isEmpty(action.getLogicalName()) ? action.getName() : action.getLogicalName();
        action.setRepositoryPath(String.format(actionPathPrefix, action.getName(), actionName));
    }

    private static void readParameters(File testDirPath, Map<String, UftTestAction> actionMap) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        for (Map.Entry<String, UftTestAction> entry : actionMap.entrySet()) {
            String actionName = entry.getKey();
            File actionFolder = new File(testDirPath, actionName);
            if (actionFolder.exists()) {
                File resourceMtrFile = UftTestDiscoveryUtils.getFileIfExist(actionFolder, RESOURCE_MTR_FILE);
                if (resourceMtrFile != null) {
                    UftTestDiscoveryUtils.parseActionMtrFile(resourceMtrFile, documentBuilder, entry.getValue());
                    continue;
                }
                logger.warn("resource.mtr file for action {} does not exist", (Object)actionName);
                continue;
            }
            entry.getValue().setParameters(Collections.emptyList());
            logger.warn("folder for action {} does not exist", (Object)actionName);
        }
    }

    private static void parseActionMtrFile(File resourceMtrFile, DocumentBuilder documentBuilder, UftTestAction action) throws IOException, SAXException {
        ArrayList<UftTestParameter> parameters = new ArrayList<UftTestParameter>();
        FileInputStream is = new FileInputStream(resourceMtrFile);
        String xmlContent = UftTestDiscoveryUtils.extractXmlContentFromTspFile(is);
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
        NodeList argumentsCollectionElement = document.getElementsByTagName(UFT_PARAM_ARGUMENTS_COLLECTION_NODE_NAME);
        if (argumentsCollectionElement.getLength() > 0) {
            Node argumentsCollectionItem = argumentsCollectionElement.item(0);
            NodeList childArgumentElements = argumentsCollectionItem.getChildNodes();
            for (int i = 0; i < childArgumentElements.getLength(); ++i) {
                Element argumentElement = (Element)childArgumentElements.item(i);
                UftTestParameter parameter = new UftTestParameter();
                parameter.setName(argumentElement.getElementsByTagName(UFT_PARAM_ARG_NAME_NODE_NAME).item(0).getTextContent());
                parameter.setDirection(UftParameterDirection.get(Integer.parseInt(argumentElement.getElementsByTagName("ArgDirection").item(0).getTextContent())));
                Node defaultValueNode = argumentElement.getElementsByTagName(UFT_PARAM_ARG_DEFAULT_VALUE_NODE_NAME).item(0);
                if (null != defaultValueNode) {
                    parameter.setDefaultValue(defaultValueNode.getTextContent());
                }
                parameters.add(parameter);
            }
        }
        action.setParameters(parameters);
        String description = document.getElementsByTagName(UFT_ACTION_DESCRIPTION_NODE_NAME).item(0).getTextContent();
        action.setDescription(description);
    }
}

