/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.fod.dto;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.securityscans.FodServerConfiguration;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODConfig;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODConnector;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FODSource;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.SecurityTool;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.mock.FodMockSource;

public class FodConnectionFactory {
    private static FODSource fodSource;
    public static final Object syncObject;
    private static SecurityTool securityToolEntity;
    private static OctaneSDK.SDKServicesConfigurer configurer;
    public static final String API_SUFFIX = "/api/v3";

    public static void setConfigurer(OctaneSDK.SDKServicesConfigurer configurer) {
        FodConnectionFactory.configurer = configurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FODSource instance() {
        Object object = syncObject;
        synchronized (object) {
            if (FodConnectionFactory.needToUpdateConnection()) {
                fodSource = FodConnectionFactory.createFodConnector(securityToolEntity);
            }
            return fodSource;
        }
    }

    private static boolean needToUpdateConnection() {
        if (fodSource == null) {
            securityToolEntity = FodConnectionFactory.getFODSecTool();
            return true;
        }
        SecurityTool updatedConnectionParams = FodConnectionFactory.getFODSecTool();
        if (!updatedConnectionParams.equals(securityToolEntity)) {
            securityToolEntity = updatedConnectionParams;
            return true;
        }
        return false;
    }

    public static SecurityTool getFODSecTool() {
        FodServerConfiguration fodProjectConfiguration = FodConnectionFactory.configurer.pluginServices.getFodServerConfiguration();
        return new SecurityTool(fodProjectConfiguration.getBaseUrl(), fodProjectConfiguration.getClientId(), fodProjectConfiguration.getClientSecret());
    }

    private static FODSource createFodConnector(SecurityTool securityToolEntity) {
        if (securityToolEntity.getToolUrl().contains("MockURL")) {
            return new FodMockSource();
        }
        FODConnector instance = new FODConnector(new FODConfig.CredentialsFODConfig(securityToolEntity.getToolUrl(), securityToolEntity.getApiKey(), securityToolEntity.getSecret()));
        instance.initConnection(configurer);
        return instance;
    }

    static {
        syncObject = new Object();
    }
}

