/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.fod;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.dto.securityscans.impl.OctaneIssueImpl;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FodConnectionFactory;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.FODUser;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.Vulnerability;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.VulnerabilityAllData;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.services.FODUsersRestService;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCToOctaneIssueUtil;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FODValuesConverter {
    private static final Logger logger = LogManager.getLogger(FODValuesConverter.class);
    private List<FODUser> allUsers;

    public void init() {
        try {
            this.allUsers = FODUsersRestService.getAllUsers();
        }
        catch (PermanentException e) {
            this.allUsers = new ArrayList<FODUser>();
            logger.error("current user in Unauthorized to get users data, 'Manage users' permission is required. only data that not requires this permission will return (user emails will not be added to the result)");
        }
    }

    private OctaneIssue createIssue(Vulnerability vulnerability, String remoteTag, VulnerabilityAllData vulnerabilityAllData, Date baselineDate) {
        OctaneIssueImpl entity = new OctaneIssueImpl();
        entity.setCategory(vulnerability.category);
        if (vulnerability.introducedDate != null) {
            String dateAsString = this.getIntroducedDate(vulnerability.introducedDate, baselineDate);
            entity.setIntroducedDate(dateAsString);
        }
        this.setAdditionalData(vulnerability, entity, vulnerabilityAllData);
        entity.setLine(vulnerability.lineNumber);
        entity.setToolName("FOD");
        entity.setPackage(vulnerability.packageValue);
        entity.setPrimaryLocationFull(vulnerability.primaryLocationFull);
        this.setStatus(entity, vulnerability.status);
        this.setSeverity(entity, vulnerability.severity);
        entity.setRemoteId(vulnerability.getRemoteId());
        if (vulnerabilityAllData != null) {
            this.setExternalLink(vulnerability, entity);
        }
        this.setAssignedUser(entity, vulnerability.assignedUser);
        this.setAnalysis(entity, vulnerability);
        entity.setRemoteTag(remoteTag);
        return entity;
    }

    private void setAssignedUser(OctaneIssue entity, String assignedUser) {
        String email = this.getEmailFromAssignedUser(assignedUser);
        if (email != null && !email.isEmpty()) {
            entity.setOwnerEmail(email);
        }
    }

    private void setExternalLink(Vulnerability vulnerability, OctaneIssue entity) {
        String baseURL = this.getBaseURL(FodConnectionFactory.instance().getEntitiesURL());
        String externalLink = String.format("%s/Redirect/Issues/%s", baseURL, vulnerability.vulnId);
        if (externalLink != null) {
            entity.setExternalLink(externalLink);
        }
    }

    private String getBaseURL(String entitiesURL) {
        return entitiesURL.replace("/api/v3", "");
    }

    public static boolean sameDay(Date date1, Date date2) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        return fmt.format(date1).equals(fmt.format(date2));
    }

    public String getIntroducedDate(String fodIntroducedDate, Date baselineDate) {
        Date date = FODValuesConverter.dateOfDateString(fodIntroducedDate);
        if (date == null) {
            return null;
        }
        if (FODValuesConverter.sameDay(date, baselineDate)) {
            date = new Date(baselineDate.getTime() + 60000L);
        }
        SimpleDateFormat targetDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String retVal = targetDateFormat.format(date);
        logger.debug("FOD Issue with introduced date:" + retVal);
        return retVal;
    }

    public static Date dateOfDateString(String fodIntroducedDate) {
        SimpleDateFormat sourceDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        try {
            return sourceDateFormat.parse(fodIntroducedDate + "T00:00:00");
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void setAnalysis(OctaneIssue entity, Vulnerability vulnerability) {
        if (FODValuesConverter.isReviewed(vulnerability)) {
            Entity analysisListNode = SSCToOctaneIssueUtil.createListNodeEntity("list_node.issue_analysis_node.reviewed");
            entity.setAnalysis(analysisListNode);
        } else {
            String listNodeId = this.mapFODAnalysisToLogicalName(vulnerability.status);
            if (listNodeId == null) {
                listNodeId = this.mapAuditorStatusToAnalysis(vulnerability.auditorStatus);
            }
            if (listNodeId != null) {
                Entity analysisListNode = SSCToOctaneIssueUtil.createListNodeEntity(listNodeId);
                entity.setAnalysis(analysisListNode);
            }
        }
    }

    private static boolean isReviewed(Vulnerability issue) {
        boolean returnValue = false;
        if (issue.status != null && issue.status.equalsIgnoreCase("reviewed")) {
            returnValue = true;
        } else if (issue.reviewed != null && issue.reviewed.booleanValue()) {
            returnValue = true;
        } else if (issue.audited != null && issue.audited.booleanValue()) {
            returnValue = true;
        }
        return returnValue;
    }

    public List<OctaneIssue> createOctaneIssuesFromVulns(List<Vulnerability> newVulnerabilities, String remoteTag, Map<String, VulnerabilityAllData> idToAllData, Date baselineDate) {
        if (newVulnerabilities.size() == 0) {
            return new ArrayList<OctaneIssue>();
        }
        ArrayList<OctaneIssue> issuesToCreate = new ArrayList<OctaneIssue>();
        for (Vulnerability vulnerability : newVulnerabilities) {
            issuesToCreate.add(this.createIssue(vulnerability, remoteTag, idToAllData.get(vulnerability.id), baselineDate));
        }
        return issuesToCreate;
    }

    private void setAdditionalData(Vulnerability vulnerability, OctaneIssue entity, VulnerabilityAllData vulnerabilityAllData) {
        HashMap<String, String> additionalData = new HashMap<String, String>();
        additionalData.put("kingdom", vulnerability.kingdom);
        additionalData.put("subtype", vulnerability.subtype);
        if (vulnerabilityAllData != null) {
            if (vulnerabilityAllData.details != null) {
                additionalData.put("summary", vulnerabilityAllData.details.summary);
                additionalData.put("explanation", vulnerabilityAllData.details.explanation);
            }
            if (vulnerabilityAllData.recommendations != null) {
                additionalData.put("recommendations", vulnerabilityAllData.recommendations.recommendations);
                additionalData.put("tips", vulnerabilityAllData.recommendations.tips);
            }
        }
        entity.setExtendedData(additionalData);
    }

    private void setStatus(OctaneIssue entity, String status) {
        String logicalName = this.mapFODStatusToLogicalName(status);
        if (logicalName != null) {
            Entity stateListNode = SSCToOctaneIssueUtil.createListNodeEntity(logicalName);
            entity.setState(stateListNode);
        }
    }

    private String mapFODStatusToLogicalName(String status) {
        switch (status) {
            case "New": {
                return "list_node.issue_state_node.new";
            }
            case "Existing": {
                return "list_node.issue_state_node.existing";
            }
            case "close": {
                return "list_node.issue_state_node.closed";
            }
        }
        return null;
    }

    private String mapFODAnalysisToLogicalName(String analysis) {
        switch (analysis) {
            case "Waiting for review": {
                return "list_node.issue_analysis_node.maybe_an_issue";
            }
            case "Reviewed": {
                return "list_node.issue_analysis_node.reviewed";
            }
            case "bug submitted": {
                return "list_node.issue_analysis_node.bug_submitted";
            }
            case "Not an issue": {
                return "list_node.issue_analysis_node.not_an_issue";
            }
        }
        return null;
    }

    private String mapAuditorStatusToAnalysis(String auditorStatus) {
        String returnValue = null;
        if ("Pending Review".equalsIgnoreCase(auditorStatus)) {
            returnValue = "list_node.issue_analysis_node.maybe_an_issue";
        } else if ("Not an Issue".equalsIgnoreCase(auditorStatus) || "Risk accepted".equalsIgnoreCase(auditorStatus)) {
            returnValue = "list_node.issue_analysis_node.not_an_issue";
        } else if ("Remediation Required".equalsIgnoreCase(auditorStatus) || "Remediation Deferred".equalsIgnoreCase(auditorStatus) || "Risk Mitigated".equalsIgnoreCase(auditorStatus)) {
            returnValue = "list_node.issue_analysis_node.is_an_issue";
        }
        return returnValue;
    }

    private void setSeverity(OctaneIssue entity, Integer severity) {
        if (severity == null) {
            return;
        }
        String logicalNameForSeverity = null;
        if (severity.equals(4)) {
            logicalNameForSeverity = "list_node.severity.urgent";
        } else if (severity.equals(3)) {
            logicalNameForSeverity = "list_node.severity.high";
        } else if (severity.equals(2)) {
            logicalNameForSeverity = "list_node.severity.medium";
        } else if (severity.equals(1)) {
            logicalNameForSeverity = "list_node.severity.low";
        }
        Entity listNodeEntity = SSCToOctaneIssueUtil.createListNodeEntity(logicalNameForSeverity);
        if (listNodeEntity != null) {
            entity.setSeverity(listNodeEntity);
        }
    }

    private String getEmailFromAssignedUser(String assignedUser) {
        Optional<FODUser> foundOptional;
        if (SdkStringUtils.isNotEmpty(assignedUser) && (foundOptional = this.allUsers.stream().filter(user -> assignedUser.equals(user.userName) || assignedUser.equals(this.getFullName((FODUser)user))).findFirst()).isPresent()) {
            return foundOptional.get().email;
        }
        return null;
    }

    private String getFullName(FODUser user) {
        return String.format("%s, %s", user.lastName, user.firstName);
    }
}

