/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.fod;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.vulnerabilities.ExistingIssuesInOctane;
import com.hp.octane.integrations.services.vulnerabilities.IssuesFileSerializer;
import com.hp.octane.integrations.services.vulnerabilities.PackIssuesToOctaneUtils;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesQueueItem;
import com.hp.octane.integrations.services.vulnerabilities.fod.FODService;
import com.hp.octane.integrations.services.vulnerabilities.fod.FODValuesConverter;
import com.hp.octane.integrations.services.vulnerabilities.fod.PplnRunStatus;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.Scan;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.Vulnerability;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.pojos.VulnerabilityAllData;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.services.FODReleaseService;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.services.FODVulnerabilityService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FODServiceImpl
implements FODService {
    private static final Logger logger = LogManager.getLogger(FODServiceImpl.class);
    protected final OctaneSDK.SDKServicesConfigurer configurer;
    protected final RestService restService;

    public FODServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService) {
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurer == null) {
            throw new IllegalArgumentException("configurer service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
    }

    @Override
    public InputStream getVulnerabilitiesScanResultStream(VulnerabilitiesQueueItem queueItem) throws IOException {
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "Entered getVulnerabilitiesScanResultStream");
        String targetDir = IssuesFileSerializer.getTargetDir(this.configurer.pluginServices.getAllowedOctaneStorage(), queueItem.getJobId(), queueItem.getBuildId());
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "getVulnerabilitiesScanResultStream target Dir:" + targetDir);
        InputStream cachedScanResult = IssuesFileSerializer.getCachedScanResult(targetDir);
        if (cachedScanResult != null) {
            logger.warn("results " + queueItem.toString() + "are cached!");
            return cachedScanResult;
        }
        this.enrichItemWithFODParams(queueItem);
        PplnRunStatus pplnRunStatus = this.fodScanIsStillInProgress(queueItem);
        if (pplnRunStatus.continuePolling) {
            return null;
        }
        if (pplnRunStatus.tryGetIssues) {
            List<OctaneIssue> octaneIssues = this.fetchIssues(queueItem, this.getRelease(queueItem).toString());
            IssuesFileSerializer.cacheIssues(targetDir, octaneIssues);
            return IssuesFileSerializer.serializeIssues(octaneIssues);
        }
        throw new PermanentException(queueItem.getJobId() + "#" + queueItem.getBuildId() + " , Polling is stopped");
    }

    @Override
    public boolean vulnerabilitiesQueueItemCleanUp(VulnerabilitiesQueueItem vulnerabilitiesQueueItem) {
        String runRootDir = IssuesFileSerializer.getTargetDir(this.configurer.pluginServices.getAllowedOctaneStorage(), vulnerabilitiesQueueItem.getJobId(), vulnerabilitiesQueueItem.getBuildId());
        if (runRootDir == null) {
            return false;
        }
        File directoryToBeDeleted = new File(runRootDir);
        return IssuesFileSerializer.deleteDirectory(directoryToBeDeleted);
    }

    @Override
    public RestService getRestService() {
        return this.restService;
    }

    @Override
    public OctaneSDK.SDKServicesConfigurer getConfigurer() {
        return this.configurer;
    }

    private PplnRunStatus fodScanIsStillInProgress(VulnerabilitiesQueueItem queueItem) {
        Long scan;
        Long release;
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "Check if scan is in progress." + queueItem.getJobId() + "#" + queueItem.getJobId());
        Long pplRunStartTime = queueItem.getStartTime();
        if (this.getScan(queueItem) == null) {
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "need to retrieve the scan Id");
            List<Scan> scans = FODReleaseService.getScansLastInFirstFetched(this.getRelease(queueItem), pplRunStartTime);
            this.setScanIdForItem(queueItem, scans);
            if (this.getScan(queueItem) == null) {
                this.incFailedTries(queueItem);
                logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "scan Id was not found yet");
            }
        } else {
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "scanId is already retrieved from previous polling:" + this.getScan(queueItem));
        }
        if (this.getScan(queueItem) != null && this.scanIsCompleted(release = this.getRelease(queueItem), scan = this.getScan(queueItem))) {
            return new PplnRunStatus(false, true);
        }
        if (this.getFailedTries(queueItem) > 10) {
            logger.error("scan Id was not found, validate that the release in the pipeline configuration is the same as the release in the Jenkins job.");
            return new PplnRunStatus(false, false);
        }
        return new PplnRunStatus(true, false);
    }

    private void incFailedTries(VulnerabilitiesQueueItem queueItem) {
        String failedTriesToGetScanStr = queueItem.getAdditionalProperties().get("failedTriesToGetScan");
        Integer failedTriesToGetScan = 1;
        if (failedTriesToGetScanStr != null) {
            failedTriesToGetScan = Integer.parseInt(failedTriesToGetScanStr) + 1;
        }
        queueItem.getAdditionalProperties().put("failedTriesToGetScan", failedTriesToGetScan.toString());
    }

    private int getFailedTries(VulnerabilitiesQueueItem queueItem) {
        String failedTriesToGetScanStr = queueItem.getAdditionalProperties().get("failedTriesToGetScan");
        return failedTriesToGetScanStr == null ? 0 : Integer.parseInt(failedTriesToGetScanStr);
    }

    private void enrichItemWithFODParams(VulnerabilitiesQueueItem queueItem) {
        String releaseId;
        if (queueItem.getAdditionalProperties() == null) {
            queueItem.setAdditionalProperties(new HashMap<String, String>());
        }
        if ((releaseId = queueItem.getAdditionalProperties().get("releaseId")) == null) {
            releaseId = this.configurer.pluginServices.getFodRelease(queueItem.getJobId(), queueItem.getBuildId()).toString();
            queueItem.getAdditionalProperties().put("releaseId", releaseId);
        }
    }

    Long getRelease(VulnerabilitiesQueueItem item) {
        return Long.valueOf(item.getAdditionalProperties().get("releaseId"));
    }

    Long getScan(VulnerabilitiesQueueItem item) {
        return !item.getAdditionalProperties().containsKey("scanId") ? null : Long.valueOf(item.getAdditionalProperties().get("scanId"));
    }

    private List<OctaneIssue> fetchIssues(VulnerabilitiesQueueItem queueItem, String remoteTag) throws IOException {
        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "Security scan is done.");
        List<Vulnerability> allVulnerabilities = FODVulnerabilityService.getAllVulnerabilities(this.getRelease(queueItem));
        List<Vulnerability> nonClosedIssues = this.filterOutBeforeBaselineIssues(queueItem.getBaselineDate(), allVulnerabilities);
        ExistingIssuesInOctane existingIssuesInOctane = new ExistingIssuesInOctane(this.restService.obtainOctaneRestClient(), this.configurer.octaneConfiguration);
        List<String> existingIssuesInOc = existingIssuesInOctane.getRemoteIdsOpenVulnsFromOctane(queueItem.getJobId(), queueItem.getBuildId(), remoteTag);
        PackIssuesToOctaneUtils.SortedIssues<Vulnerability> sortedIssues = PackIssuesToOctaneUtils.packToOctaneIssues(nonClosedIssues, existingIssuesInOc, true);
        FODValuesConverter securityIssueValuesHelper = new FODValuesConverter();
        securityIssueValuesHelper.init();
        Map<String, VulnerabilityAllData> idToAllData = this.getVulnerabilityAllDataMap(this.getRelease(queueItem), sortedIssues.issuesRequiredExtendedData);
        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "fetch existing issues from Octane");
        List<OctaneIssue> octaneIssuesToUpdate = securityIssueValuesHelper.createOctaneIssuesFromVulns(sortedIssues.issuesToUpdate, remoteTag, idToAllData, queueItem.getBaselineDate());
        ArrayList<OctaneIssue> total = new ArrayList<OctaneIssue>();
        total.addAll(octaneIssuesToUpdate);
        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "ToUpdate " + octaneIssuesToUpdate.size() + " items : " + octaneIssuesToUpdate);
        total.addAll(sortedIssues.issuesToClose);
        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "ToClose " + sortedIssues.issuesToClose.size() + " items : " + sortedIssues.issuesToClose);
        return total;
    }

    private Map<String, VulnerabilityAllData> getVulnerabilityAllDataMap(Long releaseId, List<Vulnerability> requiredExtendedData) {
        long SLEEP_MS = 2000L;
        long EXPECTED_REQUEST_TIME_MS = 1000L;
        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + String.format("getVulnerabilityAllDataMap, requiredExtendedData.size=%s, expected processing duration is %s sec", requiredExtendedData.size(), (long)requiredExtendedData.size() * (SLEEP_MS + EXPECTED_REQUEST_TIME_MS) / 1000L));
        HashMap<String, VulnerabilityAllData> idToAllData = new HashMap<String, VulnerabilityAllData>();
        for (int i = 0; i < requiredExtendedData.size(); ++i) {
            Vulnerability t = requiredExtendedData.get(i);
            if (i > 0) {
                CIPluginSDKUtils.doWait(SLEEP_MS);
            }
            if (i > 0 && i % 50 == 0) {
                logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + String.format("getVulnerabilityAllDataMap, %s/%s is done, remaining processing duration is %s sec", i, requiredExtendedData.size(), (long)(requiredExtendedData.size() - i) * (SLEEP_MS + EXPECTED_REQUEST_TIME_MS) / 1000L));
            }
            idToAllData.put(t.id, FODVulnerabilityService.getSingleVulnAlldata(releaseId, t.vulnId));
        }
        return idToAllData;
    }

    private List<Vulnerability> filterOutBeforeBaselineIssues(Date baseline, List<Vulnerability> allVulnerabilities) {
        return allVulnerabilities.stream().filter(t -> {
            Date date = FODValuesConverter.dateOfDateString(t.introducedDate);
            return date.after(baseline) || FODValuesConverter.sameDay(date, baseline);
        }).collect(Collectors.toList());
    }

    private boolean scanIsCompleted(Long releaseId, Long scanId) {
        try {
            Scan completeScan = FODReleaseService.getCompleteScan(releaseId, scanId);
            if (completeScan == null) {
                return false;
            }
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "scan:" + scanId + " is:" + completeScan.status);
            if (completeScan.status == null) {
                return false;
            }
            return !"In_Progress".equals(completeScan.status) && !"Not_Started".equals(completeScan.status) && !"Queued".equals(completeScan.status);
        }
        catch (PermanentException e) {
            throw e;
        }
        catch (TemporaryException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setScanIdForItem(VulnerabilitiesQueueItem queueItem, List<Scan> scans) {
        Long relevantScanId = this.getRelevantScan(scans, queueItem);
        logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "scan Id is retrieved:" + relevantScanId);
        if (relevantScanId != null) {
            queueItem.getAdditionalProperties().put("scanId", relevantScanId.toString());
        }
    }

    private Long getRelevantScan(List<Scan> scans, VulnerabilitiesQueueItem queueItem) {
        Scan scanByNotes = this.getScanByNotes(scans, queueItem);
        if (scanByNotes != null) {
            return scanByNotes.scanId;
        }
        for (Scan scan : scans) {
            if (!"In_Progress".equals(scan.status)) continue;
            return scan.scanId;
        }
        return null;
    }

    private Scan getScanByNotes(List<Scan> scans, VulnerabilitiesQueueItem queueItem) {
        for (Scan scan : scans) {
            if (scan.notes == null || !scan.notes.contains("[" + queueItem.getBuildId() + "]")) continue;
            return scan;
        }
        return null;
    }
}

