/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities;

import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExistingIssuesInOctane {
    private static final Logger logger = LogManager.getLogger(ExistingIssuesInOctane.class);
    private OctaneRestClient octaneRestClient;
    private OctaneConfiguration octaneConfiguration;

    public ExistingIssuesInOctane(OctaneRestClient octaneRestClient, OctaneConfiguration octaneConfiguration) {
        this.octaneRestClient = octaneRestClient;
        this.octaneConfiguration = octaneConfiguration;
    }

    public List<String> getRemoteIdsOpenVulnsFromOctane(String jobId, String runId, String remoteTag) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        boolean base64 = ConfigurationParameterFactory.isEncodeCiJobBase64(this.octaneConfiguration);
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodeQueryParam(jobId);
        String url = this.getOpenVulnerabilitiesContextPath(this.octaneConfiguration.getUrl(), this.octaneConfiguration.getSharedSpace()) + "?instance-id=" + this.octaneConfiguration.getInstanceId() + String.format("&job-ci-id=%s&build-ci-id=%s&state=open&remote-tag=%s", encodedJobId, CIPluginSDKUtils.urlEncodeQueryParam(runId), CIPluginSDKUtils.urlEncodeQueryParam(remoteTag));
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
        }
        OctaneRequest request = DTOFactory.getInstance().newDTO(OctaneRequest.class).setMethod(HttpMethod.GET).setUrl(url).setHeaders(headers);
        OctaneResponse response = this.octaneRestClient.execute(request);
        logger.info(this.octaneConfiguration.getLocationForLog() + "vulnerabilities retrieve was completed; status: " + response.getStatus() + ", response: " + response.getBody());
        if (response.getStatus() != 200) {
            logger.error(this.octaneConfiguration.getLocationForLog() + "Error retrieving existing vulnerabilities from Octane.");
            throw new IOException();
        }
        logger.info(this.octaneConfiguration.getLocationForLog() + "retrieved existing vulnerabilities from Octane.");
        return CIPluginSDKUtils.getObjectMapper().readValue(response.getBody(), List.class);
    }

    private String getOpenVulnerabilitiesContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/api/shared_spaces/" + sharedSpaceId + "/vulnerabilities/remote-issue-ids";
    }
}

