/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.coverage;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.coverage.CoverageReportType;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.coverage.CoverageService;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CoverageServiceImpl
implements CoverageService {
    private static final Logger logger = LogManager.getLogger(CoverageServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final ExecutorService coveragePushExecutor = Executors.newSingleThreadExecutor(new CoveragePushWorkerThreadFactory());
    private final String BUILD_COVERAGE_QUEUE_FILE = "coverage-push-queue.dat";
    private final ObjectQueue<CoverageQueueItem> coveragePushQueue;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    protected final ConfigurationService configurationService;
    private final WorkerPreflight workerPreflight;
    private int TEMPORARY_ERROR_BREATHE_INTERVAL = 15000;

    CoverageServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, QueueingService queueingService, RestService restService, ConfigurationService configurationService) {
        if (configurer == null || configurer.pluginServices == null || configurer.octaneConfiguration == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (queueingService == null) {
            throw new IllegalArgumentException("queue service MUST NOT be null");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        this.configurationService = configurationService;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        this.coveragePushQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue("coverage-push-queue.dat", CoverageQueueItem.class) : queueingService.initMemoQueue();
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.coveragePushExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.coveragePushQueue.getClass().getSimpleName() + ")");
    }

    private void worker() {
        while (!this.coveragePushExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            CoverageQueueItem coverageQueueItem = null;
            try {
                coverageQueueItem = this.coveragePushQueue.peek();
                this.pushCoverageWithPreflight(coverageQueueItem);
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "successfully processed " + coverageQueueItem);
                this.coveragePushQueue.remove();
            }
            catch (TemporaryException te) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + coverageQueueItem + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying", (Throwable)te);
                CIPluginSDKUtils.doWait(this.TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (PermanentException pe) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + coverageQueueItem + ", passing over", (Throwable)pe);
                this.coveragePushQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build coverage item '" + coverageQueueItem + "', passing over", t);
                this.coveragePushQueue.remove();
            }
        }
    }

    @Override
    public boolean isSonarReportRelevant(String jobId) {
        OctaneResponse response;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        boolean result = false;
        boolean base64 = this.isEncodeBase64();
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodePathParam(jobId);
        try {
            String url = this.getAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "servers/" + CIPluginSDKUtils.urlEncodePathParam(this.configurer.octaneConfiguration.getInstanceId()) + "/jobs/" + encodedJobId + "/workspaceId";
            if (base64) {
                url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
            }
            OctaneRequest preflightRequest = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.GET).setUrl(url);
            response = this.restService.obtainOctaneRestClient().execute(preflightRequest);
            if (response.getStatus() == 503 || response.getStatus() == 502) {
                throw new TemporaryException("preflight request failed with status " + response.getStatus());
            }
            if (response.getStatus() != 200 && response.getStatus() != 204) {
                throw new PermanentException("preflight request failed with status " + response.getStatus());
            }
        }
        catch (IOException ioe) {
            throw new TemporaryException("failed to perform preflight request", ioe);
        }
        if (response.getStatus() == 200 && response.getBody() != null && !response.getBody().isEmpty()) {
            try {
                String[] wss = CIPluginSDKUtils.getObjectMapper().readValue(response.getBody(), String[].class);
                if (wss.length > 0) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "coverage of " + jobId + " found " + wss.length + " interested workspace/s in Octane, dispatching the coverage");
                    result = true;
                } else {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "coverage of " + jobId + ", found no interested workspace in Octane");
                }
            }
            catch (IOException ioe) {
                throw new PermanentException("failed to parse preflight response '" + response.getBody() + "' for '" + jobId + "'");
            }
        }
        return result;
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    @Override
    public OctaneResponse pushCoverage(String jobId, String buildId, CoverageReportType reportType, InputStream coverageReport) {
        String url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (reportType == null) {
            throw new IllegalArgumentException("report type MUST NOT be null");
        }
        if (coverageReport == null) {
            throw new IllegalArgumentException("coverage report data MUST NOT be null");
        }
        boolean base64 = this.isEncodeBase64();
        String tempJobId = jobId;
        if (base64) {
            tempJobId = CIPluginSDKUtils.urlEncodeBase64(jobId);
        }
        try {
            url = new URIBuilder(this.getAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "coverage").setParameter("ci-server-identity", this.configurer.octaneConfiguration.getInstanceId()).setParameter("ci-job-id", tempJobId).setParameter("ci-build-id", buildId).setParameter("file-type", reportType.name()).toString();
            if (base64) {
                url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
            }
        }
        catch (URISyntaxException urise) {
            throw new PermanentException("failed to build URL to push coverage report", urise);
        }
        String correlationId = CIPluginSDKUtils.getNextCorrelationId();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Correlation-ID", correlationId);
        OctaneRequest pushCoverageRequest = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.PUT).setUrl(url).setHeaders(headers).setBody(coverageReport);
        try {
            return this.restService.obtainOctaneRestClient().execute(pushCoverageRequest);
        }
        catch (IOException ioe) {
            throw new TemporaryException("failed to push coverage report", ioe);
        }
    }

    @Override
    public void enqueuePushCoverage(String jobId, String buildId, CoverageReportType reportType, String reportFileName, String rootJobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (reportType == null) {
            throw new IllegalArgumentException("report type MUST NOT be null");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        this.coveragePushQueue.add(new CoverageQueueItem(jobId, buildId, reportType, reportFileName));
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public void shutdown() {
        this.coveragePushExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.coveragePushExecutor.isShutdown();
    }

    private void pushCoverageWithPreflight(CoverageQueueItem queueItem) {
        if (!this.isSonarReportRelevant(queueItem.jobId)) {
            return;
        }
        InputStream coverageReport = this.configurer.pluginServices.getCoverageReport(queueItem.jobId, queueItem.buildId, queueItem.reportFileName);
        if (coverageReport == null) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "no log for " + queueItem + " found, abandoning");
            return;
        }
        OctaneResponse response = this.pushCoverage(queueItem.jobId, queueItem.buildId, queueItem.reportType, coverageReport);
        if (response.getStatus() != 200) {
            if (response.getStatus() == 503 || response.getStatus() == 502) {
                throw new TemporaryException("temporary failed to push coverage of " + queueItem + ", status: " + 503);
            }
            throw new PermanentException("permanently failed to push coverage of " + queueItem + ", status: " + response.getStatus());
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "successfully pushed coverage of " + queueItem + ", CorrelationId - " + response.getCorrelationId());
    }

    private String getAnalyticsContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/internal-api/shared_spaces/" + sharedSpaceId + "/analytics/ci/";
    }

    @Override
    public long getQueueSize() {
        return this.coveragePushQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.coveragePushQueue.size() > 0) {
            this.coveragePushQueue.remove();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private static final class CoveragePushWorkerThreadFactory
    implements ThreadFactory {
        private CoveragePushWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("CoveragePushWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    private static final class CoverageQueueItem
    implements QueueingService.QueueItem {
        private String jobId;
        private String buildId;
        private CoverageReportType reportType;
        private String reportFileName;

        private CoverageQueueItem() {
        }

        private CoverageQueueItem(String jobId, String buildId, CoverageReportType reportType, String reportFileName) {
            this.jobId = jobId;
            this.buildId = buildId;
            this.reportType = reportType;
            this.reportFileName = reportFileName;
        }

        public String toString() {
            return (Object)((Object)this.reportType) + " of '" + this.jobId + " #" + this.buildId + "'  [optional fileName: " + this.reportFileName + "]";
        }
    }
}

