/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.executor;

import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.Serializable;

public enum TestsToRunFramework implements Serializable
{
    JUnit4("mvnSurefire", "JUnit/TestNG over Maven Surefire/Failsafe", ""),
    MF_UFT("uft", "Micro Focus UFT", ""),
    MF_MBT("mbt", "Micro Focus MBT", ""),
    CUCUMBER_JVM("cucumber_jvm", "Cucumber-JVM over Maven", ""),
    BDD_SCENARIO("bdd_scenario", "BDD Scenario", ""),
    JBehave("jbehave", "JBehave over Maven", "{\"testPattern\": \"$featureFilePath\",\"testDelimiter\": \",\"}"),
    Protractor("protractor", "Protractor", "{\"testPattern\":\"$class $testName\",\"testDelimiter\":\"|\"}"),
    Gradle("gradle", "Gradle", "{\"testPattern\":\" --tests $package.$class.$testName\",\"testDelimiter\":\"\"}"),
    Custom("custom", "Custom", "");

    private final String value;
    private final String desc;
    protected final String format;

    private TestsToRunFramework(String value, String desc, String format) {
        this.value = value;
        this.desc = desc;
        this.format = format;
    }

    public String value() {
        return this.value;
    }

    public static TestsToRunFramework fromValue(String value) {
        if (SdkStringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        for (TestsToRunFramework v : TestsToRunFramework.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalStateException("Framework '" + value + "' is not supported");
    }

    public String getDesc() {
        return this.desc;
    }

    public String getFormat() {
        return this.format;
    }
}

