/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.parameters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum CIParameterType {
    UNKNOWN("unknown"),
    PASSWORD("password"),
    BOOLEAN("boolean"),
    STRING("string"),
    NUMBER("number"),
    FILE("file"),
    AXIS("axis");

    private String value;

    private CIParameterType(String value) {
        this.value = value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CIParameterType fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        CIParameterType result = UNKNOWN;
        for (CIParameterType v : CIParameterType.values()) {
            if (v.value.compareTo(value) != 0) continue;
            result = v;
            break;
        }
        return result;
    }
}

