/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo.config;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.develocity.bamboo.config.JsonConfigurationConverter;
import com.gradle.develocity.bamboo.config.PersistentConfiguration;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersistentConfigurationManager {
    static final String CONFIG_V0_KEY = "com.gradle.bamboo.plugins.ge.config";
    static final String CONFIG_V1_KEY = "com.gradle.bamboo.plugins.ge.config.v1";
    static final String CURRENT_CONFIG_KEY = "com.gradle.bamboo.plugins.ge.config.v1";
    private final BandanaManager bandanaManager;

    @Autowired
    public PersistentConfigurationManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void save(PersistentConfiguration configuration) {
        try {
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.gradle.bamboo.plugins.ge.config.v1", (Object)JsonConfigurationConverter.toJson(configuration));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing configuration as json", e);
        }
    }

    public Optional<PersistentConfiguration> load() {
        try {
            Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.gradle.bamboo.plugins.ge.config.v1");
            return Optional.ofNullable(JsonConfigurationConverter.fromJson((String)value));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing configuration from json", e);
        }
    }
}

