/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.develocity.bamboo.config.PersistentConfiguration;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

class JsonConfigurationConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private JsonConfigurationConverter() {
    }

    @Nullable
    static String toJson(@Nullable Object configuration) throws JsonProcessingException {
        if (configuration == null) {
            return null;
        }
        return objectMapper.writeValueAsString(configuration);
    }

    @Nullable
    static PersistentConfiguration fromJson(@Nullable String json) throws IOException {
        if (json == null) {
            return null;
        }
        return (PersistentConfiguration)objectMapper.readValue(json, PersistentConfiguration.class);
    }
}

