/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo.config;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.develocity.bamboo.config.JsonConfigurationConverter;
import com.gradle.develocity.bamboo.config.PersistentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMigrator.class);
    private static final String DEVELOCITY_BAMBOO_PLUGIN_KEY = "com.gradle.enterprise.gradle-enterprise-bamboo-plugin";
    private final BandanaManager bandanaManager;

    @Autowired
    public ConfigurationMigrator(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (DEVELOCITY_BAMBOO_PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.migrateConfigV0ToV1();
        }
    }

    private void migrateConfigV0ToV1() {
        Object value = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.gradle.bamboo.plugins.ge.config");
        if (value != null && PersistentConfiguration.class.getName().equals(value.getClass().getName())) {
            try {
                LOGGER.info("Migrating {} config from {} to {}", new Object[]{DEVELOCITY_BAMBOO_PLUGIN_KEY, "com.gradle.bamboo.plugins.ge.config", "com.gradle.bamboo.plugins.ge.config.v1"});
                String json = JsonConfigurationConverter.toJson(value);
                this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.gradle.bamboo.plugins.ge.config.v1", (Object)json);
                this.bandanaManager.removeValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.gradle.bamboo.plugins.ge.config");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Could not migrate config to json", e);
            }
        }
    }
}

