/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo.admin;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.gradle.develocity.bamboo.admin.AccessKeyValidator;
import com.gradle.develocity.bamboo.config.PersistentConfiguration;
import com.gradle.develocity.bamboo.config.PersistentConfigurationManager;
import com.gradle.develocity.bamboo.config.UsernameAndPassword;
import com.gradle.develocity.bamboo.config.UsernameAndPasswordCredentialsProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BuildScansConfigAction
extends GlobalAdminAction {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+(\\.\\d+)?(-[-\\w]+)?$");
    private String server;
    private boolean allowUntrustedServer;
    private String sharedCredentialName;
    private String develocityPluginVersion;
    private String ccudPluginVersion;
    private String pluginRepository;
    private boolean injectMavenExtension;
    private boolean injectCcudExtension;
    private final UsernameAndPasswordCredentialsProvider credentialsProvider;
    private final PersistentConfigurationManager configurationManager;

    public BuildScansConfigAction(UsernameAndPasswordCredentialsProvider credentialsProvider, PersistentConfigurationManager configurationManager) {
        this.credentialsProvider = credentialsProvider;
        this.configurationManager = configurationManager;
    }

    public String input() {
        this.configurationManager.load().ifPresent(config -> {
            this.server = config.getServer();
            this.allowUntrustedServer = config.isAllowUntrustedServer();
            this.sharedCredentialName = config.getSharedCredentialName();
            this.develocityPluginVersion = config.getGePluginVersion();
            this.ccudPluginVersion = config.getCcudPluginVersion();
            this.pluginRepository = config.getPluginRepository();
            this.injectMavenExtension = config.isInjectMavenExtension();
            this.injectCcudExtension = config.isInjectCcudExtension();
        });
        return "input";
    }

    public void validate() {
        this.clearErrorsAndMessages();
        if (!BuildScansConfigAction.isBlankOrValidUrl(this.server)) {
            this.addFieldError("server", "Please specify a valid URL of the Develocity server.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.sharedCredentialName)) {
            UsernameAndPassword credentials = this.credentialsProvider.findByName(this.sharedCredentialName).orElse(null);
            if (credentials == null) {
                this.addFieldError("sharedCredentialName", "Please specify the name of the existing shared credential of type 'Username and password'.");
            } else {
                String accessKey = credentials.getPassword();
                if (!AccessKeyValidator.isValid(accessKey)) {
                    this.addFieldError("sharedCredentialName", "Shared credential contains an invalid access key.");
                }
            }
        }
        if (!BuildScansConfigAction.isBlankOrValidVersion(this.develocityPluginVersion)) {
            this.addFieldError("develocityPluginVersion", "Please specify a valid version of the Develocity Gradle plugin.");
        }
        if (!BuildScansConfigAction.isBlankOrValidVersion(this.ccudPluginVersion)) {
            this.addFieldError("ccudPluginVersion", "Please specify a valid version of the Common Custom User Data Gradle plugin.");
        }
        if (!BuildScansConfigAction.isBlankOrValidUrl(this.pluginRepository)) {
            this.addFieldError("pluginRepository", "Please specify a valid URL of the Gradle plugins repository.");
        }
    }

    private static boolean isBlankOrValidUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return true;
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static boolean isBlankOrValidVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return true;
        }
        return VERSION_PATTERN.matcher(version).matches();
    }

    public String save() {
        this.configurationManager.save(new PersistentConfiguration().setServer(this.server).setAllowUntrustedServer(this.allowUntrustedServer).setSharedCredentialName(this.sharedCredentialName).setPluginRepository(this.pluginRepository).setGePluginVersion(this.develocityPluginVersion).setCcudPluginVersion(this.ccudPluginVersion).setInjectMavenExtension(this.injectMavenExtension).setInjectCcudExtension(this.injectCcudExtension));
        return "success";
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    public void setAllowUntrustedServer(boolean allowUntrustedServer) {
        this.allowUntrustedServer = allowUntrustedServer;
    }

    public String getSharedCredentialName() {
        return this.sharedCredentialName;
    }

    public void setSharedCredentialName(String sharedCredentialName) {
        this.sharedCredentialName = sharedCredentialName;
    }

    public String getDevelocityPluginVersion() {
        return this.develocityPluginVersion;
    }

    public void setDevelocityPluginVersion(String develocityPluginVersion) {
        this.develocityPluginVersion = develocityPluginVersion;
    }

    public String getCcudPluginVersion() {
        return this.ccudPluginVersion;
    }

    public void setCcudPluginVersion(String ccudPluginVersion) {
        this.ccudPluginVersion = ccudPluginVersion;
    }

    public String getPluginRepository() {
        return this.pluginRepository;
    }

    public void setPluginRepository(String pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public boolean isInjectMavenExtension() {
        return this.injectMavenExtension;
    }

    public void setInjectMavenExtension(boolean injectMavenExtension) {
        this.injectMavenExtension = injectMavenExtension;
    }

    public boolean isInjectCcudExtension() {
        return this.injectCcudExtension;
    }

    public void setInjectCcudExtension(boolean injectCcudExtension) {
        this.injectCcudExtension = injectCcudExtension;
    }
}

